/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.h2.samples.CachedPreparedStatements;
import org.h2.samples.Compact;
import org.h2.samples.CsvSample;
import org.h2.samples.Function;
import org.h2.samples.ReadOnlyDatabaseInZip;
import org.h2.samples.RowAccessRights;
import org.h2.samples.TriggerPassData;
import org.h2.samples.TriggerSample;
import org.h2.samples.UpdatableView;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.RunScript;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class TestSampleApps
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return this.getBaseDir().startsWith("./data");
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/h2/samples/optimizations.sql");
        new File(this.getBaseDir()).mkdirs();
        FileOutputStream out = new FileOutputStream(this.getBaseDir() + "/optimizations.sql");
        IOUtils.copyAndClose(in, out);
        String url = "jdbc:h2:" + this.getBaseDir() + "/" + this.getTestName();
        this.testApp("", RunScript.class, "-url", url, "-user", "sa", "-password", "sa", "-script", this.getBaseDir() + "/optimizations.sql", "-checkResults");
        this.deleteDb(this.getTestName());
        this.testApp("Compacting...\nDone.", Compact.class, new String[0]);
        this.testApp("NAME: Bob Meier\nEMAIL: bob.meier@abcde.abc\nPHONE: +41123456789\n\nNAME: John Jones\nEMAIL: john.jones@abcde.abc\nPHONE: +41976543210\n", CsvSample.class, new String[0]);
        this.testApp("", CachedPreparedStatements.class, new String[0]);
        this.testApp("2 is prime\n3 is prime\n5 is prime\n7 is prime\n11 is prime\n13 is prime\n17 is prime\n19 is prime\n30\n20\n0/0\n0/1\n1/0\n1/1\n10", Function.class, new String[0]);
        this.testApp("The sum is 20.00", TriggerSample.class, new String[0]);
        this.testApp("Hello: 1\nWorld: 2", TriggerPassData.class, new String[0]);
        this.testApp("Key 1 was generated\nKey 2 was generated\n\nTEST_TABLE:\n1 Hallo\n\nTEST_VIEW:\n1 Hallo", UpdatableView.class, new String[0]);
        this.testApp("adding test data...\ndefrag to reduce random access...\ncreate the zip file...\nopen the database from the zip file...", ReadOnlyDatabaseInZip.class, new String[0]);
        this.testApp("a: 1/Hello!\nb: 1/Hallo!\n1/A/Hello!\n1/B/Hallo!", RowAccessRights.class, new String[0]);
        this.testApp("Allows changing the database file encryption password or algorithm*", ChangeFileEncryption.class, "-help");
        this.testApp("Deletes all files belonging to a database.*", DeleteDbFiles.class, "-help");
        FileUtils.delete(this.getBaseDir() + "/optimizations.sql");
    }

    private void testApp(String expected, Class<?> clazz, String ... args) throws Exception {
        DeleteDbFiles.execute("data", "test", true);
        Method m = clazz.getMethod("main", String[].class);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)buff, false, "UTF-8");
        System.setOut(out);
        System.setErr(out);
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException e) {
            TestBase.logError("error", e.getTargetException());
        }
        catch (Throwable e) {
            TestBase.logError("error", e);
        }
        out.flush();
        System.setOut(oldOut);
        System.setErr(oldErr);
        String s = buff.toString(StandardCharsets.UTF_8);
        s = StringUtils.replaceAll(s, "\r\n", "\n");
        s = s.trim();
        expected = expected.trim();
        if (expected.endsWith("*")) {
            if (!s.startsWith(expected = expected.substring(0, expected.length() - 1))) {
                this.assertEquals(expected.trim(), s.trim());
            }
        } else {
            this.assertEquals(expected.trim(), s.trim());
        }
    }
}

