/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Random;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.security.SHA3;
import org.h2.test.TestBase;
import org.h2.util.StringUtils;

public class TestSecurity
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        TestSecurity.testConnectWithHash();
        this.testSHA();
        this.testSHA3();
        this.testAES();
        this.testBlockCiphers();
    }

    private static void testConnectWithHash() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test", "sa", "sa");
        String pwd = StringUtils.convertBytesToHex(SHA256.getKeyPasswordHash("SA", "sa".toCharArray()));
        Connection conn2 = DriverManager.getConnection("jdbc:h2:mem:test;PASSWORD_HASH=TRUE", "sa", pwd);
        conn.close();
        conn2.close();
    }

    private void testSHA() {
        this.testPBKDF2();
        this.testHMAC();
        this.testOneSHA();
    }

    private void testPBKDF2() {
        this.assertEquals("120fb6cffcf8b32c43e7225256c4f837a86548c92ccc35480805987cb70be17b", StringUtils.convertBytesToHex(SHA256.getPBKDF2("password".getBytes(), "salt".getBytes(), 1, 32)));
        this.assertEquals("ae4d0c95af6b46d32d0adff928f06dd02a303f8ef3c251dfd6e2d85a95474c43", StringUtils.convertBytesToHex(SHA256.getPBKDF2("password".getBytes(), "salt".getBytes(), 2, 32)));
        this.assertEquals("c5e478d59288c841aa530db6845c4c8d962893a001ce4e11a4963873aa98134a", StringUtils.convertBytesToHex(SHA256.getPBKDF2("password".getBytes(), "salt".getBytes(), 4096, 32)));
        this.assertEquals("348c89dbcbd32b2f32d814b8116e84cf2b17347ebc1800181c4e2a1fb8dd53e1c635518c7dac47e9", StringUtils.convertBytesToHex(SHA256.getPBKDF2("passwordPASSWORDpassword".getBytes(), "saltSALTsaltSALTsaltSALTsaltSALTsalt".getBytes(), 4096, 40)));
        this.assertEquals("89b69d0516f829893c696226650a8687", StringUtils.convertBytesToHex(SHA256.getPBKDF2("pass\u0000word".getBytes(), "sa\u0000lt".getBytes(), 4096, 16)));
        byte[] password = "Test".getBytes();
        SHA256.getPBKDF2(password, "".getBytes(), 1, 16);
        this.assertEquals(new byte[4], password);
    }

    private void testHMAC() {
        this.assertEquals("b613679a0814d9ec772f95d778c35fc5ff1697c493715653c6c712144292c5ad", StringUtils.convertBytesToHex(SHA256.getHMAC(new byte[0], new byte[0])));
        this.assertEquals("f7bc83f430538424b13298e6aa6fb143ef4d59a14946175997479dbc2d1a3cd8", StringUtils.convertBytesToHex(SHA256.getHMAC("key".getBytes(), "The quick brown fox jumps over the lazy dog".getBytes())));
    }

    private String getHashString(byte[] data) {
        byte[] result = SHA256.getHash(data, true);
        if (data.length > 0) {
            this.assertEquals(0, data[0]);
        }
        return StringUtils.convertBytesToHex(result);
    }

    private void testOneSHA() {
        this.assertEquals("e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", this.getHashString(new byte[0]));
        this.assertEquals("68aa2e2ee5dff96e3355e6c7ee373e3d6a4e17f75f9518d843709c0c9bc3e3d4", this.getHashString(new byte[]{25}));
        this.assertEquals("175ee69b02ba9b58e2b0a5fd13819cea573f3940a94f825128cf4209beabb4e8", this.getHashString(new byte[]{-29, -41, 37, 112, -36, -35, 120, 124, -29, -120, 122, -78, -51, 104, 70, 82}));
        this.checkSHA256("", "E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855");
        this.checkSHA256("a", "CA978112CA1BBDCAFAC231B39A23DC4DA786EFF8147C4E72B9807785AFEE48BB");
        this.checkSHA256("abc", "BA7816BF8F01CFEA414140DE5DAE2223B00361A396177A9CB410FF61F20015AD");
        this.checkSHA256("message digest", "F7846F55CF23E14EEBEAB5B4E1550CAD5B509E3348FBC4EFA3A1413D393CB650");
        this.checkSHA256("abcdefghijklmnopqrstuvwxyz", "71C480DF93D6AE2F1EFAD1447C66C9525E316218CF51FC8D9ED832F2DAF18B73");
        this.checkSHA256("abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "248D6A61D20638B8E5C026930C3E6039A33CE45964FF2167F6ECEDD419DB06C1");
        this.checkSHA256("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "F371BC4A311F2B009EEF952DD83CA80E2B60026C8E935592D0F9C308453C813E");
        StringBuilder buff = new StringBuilder(1000000);
        buff.append('a');
        this.checkSHA256(buff.toString(), "CA978112CA1BBDCAFAC231B39A23DC4DA786EFF8147C4E72B9807785AFEE48BB");
    }

    private void checkSHA256(String message, String expected) {
        String hash = StringUtils.convertBytesToHex(SHA256.getHash(message.getBytes(), true)).toUpperCase();
        this.assertEquals(expected, hash);
    }

    private void testSHA3() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA3-224");
            Random r = new Random();
            byte[] bytes1 = new byte[r.nextInt(1025)];
            byte[] bytes2 = new byte[256];
            r.nextBytes(bytes1);
            r.nextBytes(bytes2);
            this.testSHA3(md, SHA3.getSha3_224(), bytes1, bytes2);
            this.testSHA3(MessageDigest.getInstance("SHA3-256"), SHA3.getSha3_256(), bytes1, bytes2);
            this.testSHA3(MessageDigest.getInstance("SHA3-384"), SHA3.getSha3_384(), bytes1, bytes2);
            this.testSHA3(MessageDigest.getInstance("SHA3-512"), SHA3.getSha3_512(), bytes1, bytes2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private void testSHA3(MessageDigest md1, SHA3 md2, byte[] bytes1, byte[] bytes2) {
        md1.update(bytes1);
        md2.update(bytes1);
        md1.update(bytes2, 0, 1);
        md2.update(bytes2, 0, 1);
        md1.update(bytes2, 1, 33);
        md2.update(bytes2, 1, 33);
        md1.update(bytes2, 34, 222);
        md2.update(bytes2, 34, 222);
        this.assertEquals(md1.digest(), md2.digest());
        md1.update(bytes2, 1, 1);
        md2.update(bytes2, 1, 1);
        this.assertEquals(md1.digest(), md2.digest());
    }

    private void testBlockCiphers() {
        String[] stringArray = new String[]{"AES", "FOG"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String algorithm = stringArray[n2];
            byte[] test = new byte[4096];
            BlockCipher cipher = CipherFactory.getBlockCipher(algorithm);
            cipher.setKey("abcdefghijklmnop".getBytes());
            int i = 0;
            while (i < 10) {
                cipher.encrypt(test, 0, test.length);
                ++i;
            }
            this.assertFalse(TestSecurity.isCompressible(test));
            i = 0;
            while (i < 10) {
                cipher.decrypt(test, 0, test.length);
                ++i;
            }
            this.assertEquals(new byte[test.length], test);
            this.assertTrue(TestSecurity.isCompressible(test));
            ++n2;
        }
    }

    private void testAES() {
        BlockCipher test = CipherFactory.getBlockCipher("AES");
        test.setKey(StringUtils.convertHexToBytes("00000000000000000000000000000000"));
        byte[] data = StringUtils.convertHexToBytes("80000000000000000000000000000000");
        test.encrypt(data, 0, data.length);
        String r = StringUtils.convertBytesToHex(data);
        this.assertEquals("3ad78e726c1ec02b7ebfe92b23d9ec34", r);
        test.setKey(StringUtils.convertHexToBytes("00000000000000000000000000000000"));
        data = StringUtils.convertHexToBytes("ffffffffffffffffffffffffffffffff");
        test.encrypt(data, 0, data.length);
        r = StringUtils.convertBytesToHex(data);
        this.assertEquals("3f5b8cc9ea855a0afa7347d23e8d664e", r);
        test.setKey(StringUtils.convertHexToBytes("2b7e151628aed2a6abf7158809cf4f3c"));
        data = StringUtils.convertHexToBytes("6bc1bee22e409f96e93d7e117393172a");
        test.encrypt(data, 0, data.length);
        r = StringUtils.convertBytesToHex(data);
        this.assertEquals("3ad77bb40d7a3660a89ecaf32466ef97", r);
        test.setKey(StringUtils.convertHexToBytes("000102030405060708090A0B0C0D0E0F"));
        byte[] in = new byte[128];
        byte[] enc = new byte[128];
        test.encrypt(enc, 0, 128);
        test.decrypt(enc, 0, 128);
        if (!Arrays.equals(in, enc)) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < 10) {
            test.encrypt(in, 0, 128);
            test.decrypt(enc, 0, 128);
            ++i;
        }
    }

    private static boolean isCompressible(byte[] data) {
        int x;
        int len = data.length;
        int[] sum = new int[16];
        int i = 0;
        while (i < len) {
            int n = x = (data[i] & 0xFF) >> 4;
            sum[n] = sum[n] + 1;
            ++i;
        }
        int r = 0;
        int[] nArray = sum;
        int n = sum.length;
        int n2 = 0;
        while (n2 < n) {
            x = nArray[n2];
            long v = ((long)x << 32) / (long)len;
            r += 63 - Long.numberOfLeadingZeros(v + 1L);
            ++n2;
        }
        return len * r < len * 120;
    }
}

