/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.h2.test.TestBase;
import org.h2.tools.Shell;
import org.h2.util.Task;

public class TestShell
extends TestBase {
    PrintStream toolOut;
    InputStream toolIn;
    private LineNumberReader lineReader;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        Shell shell = new Shell();
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        shell.setOut(new PrintStream((OutputStream)buff, false, "UTF-8"));
        shell.runTool("-url", "jdbc:h2:mem:", "-driver", "org.h2.Driver", "-user", "sa", "-password", "sa", "-properties", "null", "-sql", "select 'Hello ' || 'World' as hi");
        String s = buff.toString(StandardCharsets.UTF_8);
        this.assertContains(s, "HI");
        this.assertContains(s, "Hello World");
        this.assertContains(s, "(1 row, ");
        shell = new Shell();
        buff = new ByteArrayOutputStream();
        shell.setOut(new PrintStream((OutputStream)buff, false, "UTF-8"));
        shell.runTool("-help");
        s = buff.toString(StandardCharsets.UTF_8);
        this.assertContains(s, "Interactive command line tool to access a database using JDBC.");
        this.test(true);
        this.test(false);
    }

    private void test(final boolean commandLineArgs) throws IOException {
        PipedInputStream testIn = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(testIn);
        this.toolOut = new PrintStream(out, true);
        out = new PipedOutputStream();
        PrintStream testOut = new PrintStream(out, true);
        this.toolIn = new PipedInputStream(out);
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                try {
                    Shell shell = new Shell();
                    shell.setIn(TestShell.this.toolIn);
                    shell.setOut(TestShell.this.toolOut);
                    shell.setErr(TestShell.this.toolOut);
                    if (commandLineArgs) {
                        shell.runTool("-url", "jdbc:h2:mem:", "-user", "sa", "-password", "sa");
                    } else {
                        shell.runTool(new String[0]);
                    }
                }
                finally {
                    TestShell.this.toolOut.close();
                }
            }
        };
        task.execute();
        InputStreamReader reader = new InputStreamReader(testIn);
        this.lineReader = new LineNumberReader(reader);
        this.read("");
        this.read("Welcome to H2 Shell");
        this.read("Exit with");
        if (!commandLineArgs) {
            this.read("[Enter]");
            testOut.println("jdbc:h2:mem:");
            this.read("URL");
            testOut.println("");
            this.read("Driver");
            testOut.println("sa");
            testOut.println("sa");
            testOut.println("sa");
            this.read("User");
            this.read("Password");
        }
        this.read("Commands are case insensitive");
        this.read("help or ?");
        this.read("list");
        this.read("maxwidth");
        this.read("autocommit");
        this.read("history");
        this.read("quit or exit");
        this.read("");
        testOut.println("history");
        this.read("sql> No history");
        testOut.println("1");
        this.read("sql> Not found");
        testOut.println("select 1 a;");
        this.read("sql> A");
        this.read("1");
        this.read("(1 row,");
        testOut.println("history");
        this.read("sql> #1: select 1 a");
        this.read("To re-run a statement, type the number and press and enter");
        testOut.println("1");
        this.read("sql> select 1 a");
        this.read("A");
        this.read("1");
        this.read("(1 row,");
        testOut.println("select 'x' || space(1000) large, 'y' small;");
        this.read("sql> LARGE");
        this.read("x");
        this.read("(data is partially truncated)");
        this.read("(1 row,");
        testOut.println("select x, 's' s from system_range(0, 10001);");
        this.read("sql> X    | S");
        int i = 0;
        while (i < 10000) {
            this.read((i + "     ").substring(0, 4) + " | s");
            ++i;
        }
        i = 10000;
        while (i <= 10001) {
            this.read((i + "     ").substring(0, 5) + " | s");
            ++i;
        }
        this.read("(10002 rows,");
        testOut.println("select error;");
        this.read("sql> Error:");
        if (this.read("").startsWith("Column \"ERROR\" not found")) {
            this.read("");
        }
        testOut.println("create table test(id int primary key, name varchar)\n;");
        this.read("sql> ...>");
        testOut.println("insert into test values(1, 'Hello');");
        this.read("sql>");
        testOut.println("select null n, * from test;");
        this.read("sql> N    | ID | NAME");
        this.read("null | 1  | Hello");
        this.read("(1 row,");
        i = 0;
        while (i < 30) {
            testOut.println("select " + i + " ID from test;");
            this.read("sql> ID");
            this.read("" + i);
            this.read("(1 row,");
            ++i;
        }
        testOut.println("20");
        this.read("sql> select 10 ID from test");
        this.read("ID");
        this.read("10");
        this.read("(1 row,");
        testOut.println("maxwidth");
        this.read("sql> Usage: maxwidth <integer value>");
        this.read("Maximum column width is now 100");
        testOut.println("maxwidth 80");
        this.read("sql> Maximum column width is now 80");
        testOut.println("autocommit");
        this.read("sql> Usage: autocommit [true|false]");
        this.read("Autocommit is now true");
        testOut.println("autocommit false");
        this.read("sql> Autocommit is now false");
        testOut.println("autocommit true");
        this.read("sql> Autocommit is now true");
        testOut.println("list");
        this.read("sql> Result list mode is now on");
        testOut.println("select 1 first, 2 `second`;");
        this.read("sql> FIRST : 1");
        this.read("SECOND: 2");
        this.read("(1 row, ");
        testOut.println("select x from system_range(1, 3);");
        this.read("sql> X: 1");
        this.read("");
        this.read("X: 2");
        this.read("");
        this.read("X: 3");
        this.read("(3 rows, ");
        testOut.println("select x, 2 as y from system_range(1, 3) where 1 = 0;");
        this.read("sql> X");
        this.read("Y");
        this.read("(0 rows, ");
        testOut.println("list");
        this.read("sql> Result list mode is now off");
        testOut.println("help");
        this.read("sql> Commands are case insensitive");
        this.read("help or ?");
        this.read("list");
        this.read("maxwidth");
        this.read("autocommit");
        this.read("history");
        this.read("quit or exit");
        this.read("");
        testOut.println("exit");
        this.read("sql>");
        task.get();
    }

    private String read(String expectedStart) throws IOException {
        String line = this.lineReader.readLine();
        this.assertStartsWith(line, expectedStart);
        return line;
    }
}

