/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.dev.sort.InPlaceStableMergeSort;
import org.h2.dev.sort.InPlaceStableQuicksort;
import org.h2.test.TestBase;

public class TestSort
extends TestBase {
    private AtomicInteger compareCount = new AtomicInteger();
    Comparator<Long> comp = (o1, o2) -> {
        this.compareCount.incrementAndGet();
        return Long.compare(o1 >> 32, o2 >> 32);
    };
    private final Long[] array = new Long[100000];
    private Class<?> clazz;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.test(InPlaceStableMergeSort.class);
        this.test(InPlaceStableQuicksort.class);
        this.test(Arrays.class);
    }

    private void test(Class<?> c) throws Exception {
        this.clazz = c;
        TestSort.ordered(this.array);
        TestSort.shuffle(this.array);
        TestSort.stabilize(this.array);
        this.test("random");
        TestSort.ordered(this.array);
        TestSort.stabilize(this.array);
        this.test("ordered");
        TestSort.ordered(this.array);
        TestSort.reverse(this.array);
        TestSort.stabilize(this.array);
        this.test("reverse");
        TestSort.ordered(this.array);
        TestSort.stretch(this.array);
        TestSort.shuffle(this.array);
        TestSort.stabilize(this.array);
        this.test("few random");
        TestSort.ordered(this.array);
        TestSort.stretch(this.array);
        TestSort.stabilize(this.array);
        this.test("few ordered");
        TestSort.ordered(this.array);
        TestSort.reverse(this.array);
        TestSort.stretch(this.array);
        TestSort.stabilize(this.array);
        this.test("few reverse");
    }

    private void test(String type) throws Exception {
        this.compareCount.set(0);
        this.clazz.getMethod("sort", Object[].class, Comparator.class).invoke(null, this.array, this.comp);
        TestSort.verify(this.array);
    }

    private static void verify(Long[] array) {
        long last = Long.MIN_VALUE;
        int len = array.length;
        int i = 0;
        while (i < len) {
            long x = array[i];
            long x1 = x >> 32;
            long x2 = x - (x1 << 32);
            long last1 = last >> 32;
            long last2 = last - (last1 << 32);
            if (x1 < last1) {
                if (array.length < 1000) {
                    System.out.println(Arrays.toString((Object[])array));
                }
                throw new RuntimeException("" + x);
            }
            if (x1 == last1 && x2 < last2) {
                if (array.length < 1000) {
                    System.out.println(Arrays.toString((Object[])array));
                }
                throw new RuntimeException("" + x);
            }
            last = x;
            ++i;
        }
    }

    private static void ordered(Long[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = i;
            ++i;
        }
    }

    private static void stretch(Long[] array) {
        int i = array.length - 1;
        while (i >= 0) {
            array[i] = array[i / 4];
            --i;
        }
    }

    private static void reverse(Long[] array) {
        int i = 0;
        while (i < array.length / 2) {
            long temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
            ++i;
        }
    }

    private static void shuffle(Long[] array) {
        Random r = new Random(1L);
        int i = 0;
        while (i < array.length) {
            long temp = array[i];
            int j = r.nextInt(array.length);
            array[j] = array[i];
            array[i] = temp;
            ++i;
        }
    }

    private static void stabilize(Long[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = (array[i] << 32) + (long)i;
            ++i;
        }
    }
}

