/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.util.StringUtils;

public class TestStringCache
extends TestBase {
    volatile boolean stop;
    private final Random random = new Random(1L);
    private final String[] some;
    private boolean useIntern;

    public TestStringCache() {
        String[] stringArray = new String[6];
        stringArray[1] = "";
        stringArray[2] = "ABC";
        stringArray[3] = "this is a medium sized string";
        stringArray[4] = "1";
        stringArray[5] = "2";
        this.some = stringArray;
    }

    public static void main(String ... args) throws Exception {
        TestBase.createCaller().init().testFromMain();
        new TestStringCache().runBenchmark();
    }

    @Override
    public void test() throws InterruptedException {
        this.testToUpperToLower();
        StringUtils.clearCache();
        this.testSingleThread(this.getSize(5000, 20000));
        this.testMultiThreads();
    }

    private void testToUpperCache() {
        String y;
        String x;
        int n;
        int n2;
        String[] stringArray;
        Random r = new Random();
        String[] test = new String[50];
        int i = 0;
        while (i < test.length) {
            StringBuilder buff = new StringBuilder();
            int a = 0;
            while (a < 50) {
                buff.append((char)r.nextInt());
                ++a;
            }
            test[i] = a = buff.toString();
            ++i;
        }
        int repeat = 100000;
        int testLen = 0;
        long time = System.nanoTime();
        int a = 0;
        while (a < repeat) {
            stringArray = test;
            n2 = test.length;
            n = 0;
            while (n < n2) {
                x = stringArray[n];
                y = StringUtils.toUpperEnglish(x);
                testLen += y.length();
                ++n;
            }
            ++a;
        }
        time = System.nanoTime() - time;
        System.out.println("cache " + TimeUnit.NANOSECONDS.toMillis(time));
        time = System.nanoTime();
        a = 0;
        while (a < repeat) {
            stringArray = test;
            n2 = test.length;
            n = 0;
            while (n < n2) {
                x = stringArray[n];
                y = x.toUpperCase(Locale.ENGLISH);
                testLen -= y.length();
                ++n;
            }
            ++a;
        }
        time = System.nanoTime() - time;
        System.out.println("toUpperCase " + TimeUnit.NANOSECONDS.toMillis(time));
        this.assertEquals(0, testLen);
    }

    private void testToUpperToLower() {
        Random r = new Random();
        int i = 0;
        while (i < 1000) {
            StringBuilder buff = new StringBuilder();
            int a = 0;
            while (a < 100) {
                buff.append((char)r.nextInt());
                ++a;
            }
            String a2 = buff.toString();
            String b = StringUtils.toUpperEnglish(a2);
            String c = a2.toUpperCase(Locale.ENGLISH);
            this.assertEquals(c, b);
            String d = StringUtils.toLowerEnglish(a2);
            String e = a2.toLowerCase(Locale.ENGLISH);
            this.assertEquals(e, d);
            ++i;
        }
    }

    private void runBenchmark() {
        this.testToUpperCache();
        this.testToUpperCache();
        this.testToUpperCache();
        int i = 0;
        while (i < 6) {
            this.useIntern = i % 2 == 0;
            long time = System.nanoTime();
            this.testSingleThread(100000);
            time = System.nanoTime() - time;
            System.out.println(TimeUnit.NANOSECONDS.toMillis(time) + " ms (useIntern=" + this.useIntern + ")");
            ++i;
        }
    }

    private String randomString() {
        if (this.random.nextBoolean()) {
            String s = this.some[this.random.nextInt(this.some.length)];
            if (s != null && this.random.nextBoolean()) {
                s = new String(s);
            }
            return s;
        }
        int len = this.random.nextBoolean() ? this.random.nextInt(1000) : this.random.nextInt(10);
        StringBuilder buff = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            buff.append(this.random.nextInt(4095));
            ++i;
        }
        return buff.toString();
    }

    void testString() {
        String a = this.randomString();
        String b = this.useIntern ? (a == null ? null : a.intern()) : StringUtils.cache(a);
        try {
            this.assertEquals(a, b);
        }
        catch (Exception e) {
            TestBase.logError("error", e);
        }
    }

    private void testSingleThread(int len) {
        int i = 0;
        while (i < len) {
            this.testString();
            ++i;
        }
    }

    private void testMultiThreads() throws InterruptedException {
        int threadCount = this.getSize(3, 100);
        Thread[] threads = new Thread[threadCount];
        int i = 0;
        while (i < threadCount) {
            Thread t;
            threads[i] = t = new Thread(() -> {
                while (!this.stop) {
                    this.testString();
                }
            });
            ++i;
        }
        i = 0;
        while (i < threadCount) {
            threads[i].start();
            ++i;
        }
        int wait = this.getSize(200, 2000);
        Thread.sleep(wait);
        this.stop = true;
        int i2 = 0;
        while (i2 < threadCount) {
            threads[i2].join();
            ++i2;
        }
    }
}

