/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Random;
import org.h2.expression.function.DateTimeFormatFunction;
import org.h2.message.DbException;
import org.h2.test.TestBase;
import org.h2.util.StringUtils;
import org.h2.value.ValueTimestampTimeZone;

public class TestStringUtils
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testParseUInt31();
        this.testHex();
        this.testXML();
        this.testSplit();
        this.testJavaString();
        this.testURL();
        this.testPad();
        this.testReplaceAll();
        this.testTrim();
        this.testTrimSubstring();
        this.testTruncateString();
    }

    private void testParseUInt31() {
        this.assertEquals(0, StringUtils.parseUInt31("101", 1, 2));
        this.assertEquals(11, StringUtils.parseUInt31("11", 0, 2));
        this.assertEquals(0, StringUtils.parseUInt31("000", 0, 3));
        this.assertEquals(1, StringUtils.parseUInt31("01", 0, 2));
        this.assertEquals(999999999, StringUtils.parseUInt31("X999999999", 1, 10));
        this.assertEquals(Integer.MAX_VALUE, StringUtils.parseUInt31("2147483647", 0, 10));
        this.testParseUInt31Bad(null, 0, 1);
        this.testParseUInt31Bad("1", -1, 1);
        this.testParseUInt31Bad("1", 0, 0);
        this.testParseUInt31Bad("12", 1, 0);
        this.testParseUInt31Bad("-0", 0, 2);
        this.testParseUInt31Bad("+0", 0, 2);
        this.testParseUInt31Bad("2147483648", 0, 10);
        this.testParseUInt31Bad("21474836470", 0, 11);
    }

    private void testParseUInt31Bad(String s, int start, int end) {
        try {
            StringUtils.parseUInt31(s, start, end);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            return;
        }
        this.fail();
    }

    private void testHex() {
        this.assertEquals("face", StringUtils.convertBytesToHex(new byte[]{-6, -50}));
        this.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes("face"));
        this.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes("fAcE"));
        this.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes("FaCe"));
        this.assertThrows(DbException.class, () -> StringUtils.convertHexToBytes("120"));
        this.assertThrows(DbException.class, () -> StringUtils.convertHexToBytes("fast"));
        this.assertThrows(DbException.class, () -> StringUtils.convertHexToBytes("012=abcf"));
    }

    private void testPad() {
        this.assertEquals("large", StringUtils.pad("larger text", 5, null, true));
        this.assertEquals("large", StringUtils.pad("larger text", 5, null, false));
        this.assertEquals("short+++++", StringUtils.pad("short", 10, "+", true));
        this.assertEquals("+++++short", StringUtils.pad("short", 10, "+", false));
    }

    private void testXML() {
        this.assertEquals("<!-- - - - - - -abc- - - - - - -->\n", StringUtils.xmlComment("------abc------"));
        this.assertEquals("<test/>\n", StringUtils.xmlNode("test", null, null));
        this.assertEquals("<test>Gr&#xfc;bel</test>\n", StringUtils.xmlNode("test", null, StringUtils.xmlText("Gr\u00fcbel")));
        this.assertEquals("Rand&amp;Blue", StringUtils.xmlText("Rand&Blue"));
        this.assertEquals("&lt;&lt;[[[]]]&gt;&gt;", StringUtils.xmlCData("<<[[[]]]>>"));
        ValueTimestampTimeZone dt = DateTimeFormatFunction.parseDateTime(null, "2001-02-03 04:05:06 GMT", "yyyy-MM-dd HH:mm:ss z", "en", "GMT");
        String s = StringUtils.xmlStartDoc() + StringUtils.xmlComment("Test Comment") + StringUtils.xmlNode("rss", StringUtils.xmlAttr("version", "2.0"), StringUtils.xmlComment("Test Comment\nZeile2") + StringUtils.xmlNode("channel", null, StringUtils.xmlNode("title", null, "H2 Database Engine") + StringUtils.xmlNode("link", null, "https://h2database.com") + StringUtils.xmlNode("description", null, "H2 Database Engine") + StringUtils.xmlNode("language", null, "en-us") + StringUtils.xmlNode("pubDate", null, DateTimeFormatFunction.formatDateTime(null, dt, "EEE, d MMM yyyy HH:mm:ss z", "en", "GMT")) + StringUtils.xmlNode("lastBuildDate", null, DateTimeFormatFunction.formatDateTime(null, dt, "EEE, d MMM yyyy HH:mm:ss z", "en", "GMT")) + StringUtils.xmlNode("item", null, StringUtils.xmlNode("title", null, "New Version 0.9.9.9.9") + StringUtils.xmlNode("link", null, "https://h2database.com") + StringUtils.xmlNode("description", null, StringUtils.xmlCData("\nNew Features\nTest\n")))));
        this.assertEquals(s, "<?xml version=\"1.0\"?>\n<!-- Test Comment -->\n<rss version=\"2.0\">\n    <!--\n        Test Comment\n        Zeile2\n    -->\n    <channel>\n        <title>H2 Database Engine</title>\n        <link>https://h2database.com</link>\n        <description>H2 Database Engine</description>\n        <language>en-us</language>\n        <pubDate>Sat, 3 Feb 2001 04:05:06 GMT</pubDate>\n        <lastBuildDate>Sat, 3 Feb 2001 04:05:06 GMT</lastBuildDate>\n        <item>\n            <title>New Version 0.9.9.9.9</title>\n            <link>https://h2database.com</link>\n            <description>\n                <![CDATA[\n                New Features\n                Test\n                ]]>\n            </description>\n        </item>\n    </channel>\n</rss>\n");
    }

    private void testURL() throws UnsupportedEncodingException {
        Random random = new Random(1L);
        int i = 0;
        while (i < 100) {
            int len = random.nextInt(10);
            StringBuilder buff = new StringBuilder();
            int j = 0;
            while (j < len) {
                if (random.nextBoolean()) {
                    buff.append((char)random.nextInt(12288));
                } else {
                    buff.append((char)random.nextInt(255));
                }
                ++j;
            }
            String a = buff.toString();
            String b = URLEncoder.encode(a, "UTF-8");
            String c = URLDecoder.decode(b, "UTF-8");
            this.assertEquals(a, c);
            String d = StringUtils.urlDecode(b);
            this.assertEquals(d, c);
            ++i;
        }
    }

    private void testJavaString() {
        this.assertEquals("a\"b", StringUtils.javaDecode("a\"b"));
        Random random = new Random(1L);
        int i = 0;
        while (i < 1000) {
            int len = random.nextInt(10);
            StringBuilder buff = new StringBuilder();
            int j = 0;
            while (j < len) {
                if (random.nextBoolean()) {
                    buff.append((char)random.nextInt(12288));
                } else {
                    buff.append((char)random.nextInt(255));
                }
                ++j;
            }
            String a = buff.toString();
            String b = StringUtils.javaEncode(a);
            String c = StringUtils.javaDecode(b);
            this.assertEquals(a, c);
            ++i;
        }
    }

    private void testSplit() {
        this.assertEquals(3, StringUtils.arraySplit("ABC,DEF,G\\,HI", ',', false).length);
        this.assertEquals(StringUtils.arrayCombine(new String[]{"", " ", ","}, ','), ", ,\\,");
        Random random = new Random(1L);
        int i = 0;
        while (i < 100) {
            int len = random.nextInt(10);
            StringBuilder buff = new StringBuilder();
            String select = "abcd,";
            int j = 0;
            while (j < len) {
                char c = select.charAt(random.nextInt(select.length()));
                if (c == 'a') {
                    buff.append("\\\\");
                } else if (c == 'b') {
                    buff.append("\\,");
                } else {
                    buff.append(c);
                }
                ++j;
            }
            String a = buff.toString();
            String[] b = StringUtils.arraySplit(a, ',', false);
            String c = StringUtils.arrayCombine(b, ',');
            this.assertEquals(a, c);
            ++i;
        }
    }

    private void testReplaceAll() {
        this.assertEquals("def", StringUtils.replaceAll("abc def", "abc ", ""));
        this.assertEquals("af", StringUtils.replaceAll("abc def", "bc de", ""));
        this.assertEquals("abc def", StringUtils.replaceAll("abc def", "bc ", "bc "));
        this.assertEquals("abc ", StringUtils.replaceAll("abc def", "def", ""));
        this.assertEquals(" ", StringUtils.replaceAll("abc abc", "abc", ""));
        this.assertEquals("xyz xyz", StringUtils.replaceAll("abc abc", "abc", "xyz"));
        this.assertEquals("abc def", StringUtils.replaceAll("abc def", "xyz", "abc"));
        this.assertEquals("", StringUtils.replaceAll("abcabcabc", "abc", ""));
        this.assertEquals("abcabcabc", StringUtils.replaceAll("abcabcabc", "aBc", ""));
        this.assertEquals("abcabcabc", StringUtils.replaceAll("abcabcabc", "", "abc"));
    }

    private void testTrim() {
        this.assertEquals("a a", StringUtils.trim("a a", true, true, null));
        this.assertEquals("  a a  ", StringUtils.trim("  a a  ", false, false, null));
        this.assertEquals("  a a", StringUtils.trim("  a a  ", false, true, null));
        this.assertEquals("a a  ", StringUtils.trim("  a a  ", true, false, null));
        this.assertEquals("a a", StringUtils.trim("  a a  ", true, true, null));
        this.assertEquals("a a", StringUtils.trim("  a a  ", true, true, ""));
        this.assertEquals("zzbbzz", StringUtils.trim("zzbbzz", false, false, "z"));
        this.assertEquals("zzbb", StringUtils.trim("zzbbzz", false, true, "z"));
        this.assertEquals("bbzz", StringUtils.trim("zzbbzz", true, false, "z"));
        this.assertEquals("bb", StringUtils.trim("zzbbzz", true, true, "z"));
    }

    private void testTrimSubstring() {
        this.testTrimSubstringImpl("", "", 0, 0);
        this.testTrimSubstringImpl("", "    ", 0, 0);
        this.testTrimSubstringImpl("", "    ", 4, 4);
        this.testTrimSubstringImpl("select", " select  from", 1, 7);
        this.testTrimSubstringImpl("a b", " a b ", 1, 4);
        this.testTrimSubstringImpl("a b", " a b ", 1, 5);
        this.testTrimSubstringImpl("b", " a b ", 2, 5);
        this.assertThrows(StringIndexOutOfBoundsException.class, () -> StringUtils.trimSubstring(" with (", 1, 8));
    }

    private void testTrimSubstringImpl(String expected, String string, int startIndex, int endIndex) {
        this.assertEquals(expected, StringUtils.trimSubstring(string, startIndex, endIndex));
        this.assertEquals(expected, StringUtils.trimSubstring(new StringBuilder(endIndex - startIndex), string, startIndex, endIndex).toString());
    }

    private void testTruncateString() {
        this.assertEquals("", StringUtils.truncateString("", 1));
        this.assertEquals("", StringUtils.truncateString("a", 0));
        this.assertEquals("_\ud83d\ude00", StringUtils.truncateString("_\ud83d\ude00", 3));
        this.assertEquals("_", StringUtils.truncateString("_\ud83d\ude00", 2));
        this.assertEquals("_\ud83d", StringUtils.truncateString("_\ud83d_", 2));
    }
}

