/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;

public class TestTraceSystem
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testTraceDebug();
        this.testReadOnly();
        this.testAdapter();
        this.testInvalidLevel();
    }

    private void testAdapter() {
        TraceSystem ts = new TraceSystem(null);
        ts.setName("test");
        ts.setLevelFile(4);
        ts.getTrace("test").debug("test");
        ts.getTrace("test").info("test");
        ts.getTrace("test").error(new Exception(), "test");
        this.assertFalse(ts.isEnabled(2));
        this.assertFalse(ts.getTrace("test").isInfoEnabled());
        ts.close();
    }

    private void testTraceDebug() throws Exception {
        TraceSystem ts = new TraceSystem(null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ts.setSysOut(new PrintStream((OutputStream)out, false, "UTF-8"));
        ts.setLevelSystemOut(3);
        ts.getTrace("test").debug(new Exception("error"), "test");
        ts.close();
        String outString = out.toString(StandardCharsets.UTF_8);
        this.assertContains(outString, "error");
        this.assertContains(outString, "Exception");
        this.assertContains(outString, "test");
    }

    private void testReadOnly() throws Exception {
        String readOnlyFile = this.getBaseDir() + "/readOnly.log";
        FileUtils.delete(readOnlyFile);
        FileUtils.newOutputStream(readOnlyFile, false).close();
        FileUtils.setReadOnly(readOnlyFile);
        TraceSystem ts = new TraceSystem(readOnlyFile);
        ts.setLevelFile(2);
        ts.getTrace("test").info("test");
        FileUtils.delete(readOnlyFile);
        ts.close();
    }

    private void testInvalidLevel() {
        TraceSystem ts = new TraceSystem(null);
        this.testInvalidLevel(ts, false, -2);
        this.testInvalidLevel(ts, false, 4);
        this.testInvalidLevel(ts, false, 5);
        this.testInvalidLevel(ts, true, -2);
        this.testInvalidLevel(ts, true, 5);
        ts.close();
    }

    private void testInvalidLevel(TraceSystem ts, boolean file, int level) {
        try {
            if (file) {
                ts.setLevelFile(level);
            } else {
                ts.setLevelSystemOut(level);
            }
            this.fail("Expected DbException: 90008");
        }
        catch (DbException ex) {
            this.assertEquals(90008, ex.getErrorCode());
        }
    }
}

