/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.tools.Upgrade;

public class TestUpgrade
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb();
        this.testUpgrade(1, 2, 120);
        this.testUpgrade(1, 4, 200);
    }

    private void testUpgrade(int major, int minor, int build) throws Exception {
        Statement stat;
        Connection conn;
        Object var12_14;
        Throwable throwable;
        String baseDir = this.getBaseDir();
        String url = "jdbc:h2:" + baseDir + "/testUpgrade";
        Properties p = new Properties();
        p.put("user", "sa");
        p.put("password", "password");
        Random r = new Random();
        byte[] bytes = new byte[10000];
        r.nextBytes(bytes);
        String s = new String(bytes, StandardCharsets.ISO_8859_1);
        Driver driver = Upgrade.loadH2(build);
        try {
            this.assertEquals(major, driver.getMajorVersion());
            this.assertEquals(minor, driver.getMinorVersion());
            throwable = null;
            var12_14 = null;
            try {
                conn = driver.connect(url, p);
                try {
                    stat = conn.createStatement();
                    stat.execute("CREATE TABLE TEST(ID BIGINT AUTO_INCREMENT PRIMARY KEY, B BINARY, L BLOB, C CLOB)");
                    PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(B, L, C) VALUES (?, ?, ?)");
                    prep.setBytes(1, bytes);
                    prep.setBytes(2, bytes);
                    prep.setString(3, s);
                    prep.execute();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Upgrade.unloadH2(driver);
        }
        this.assertTrue(Upgrade.upgrade(url, p, build));
        throwable = null;
        var12_14 = null;
        try {
            conn = DriverManager.getConnection(url, p);
            try {
                ResultSet rs;
                stat = conn.createStatement();
                Throwable throwable3 = null;
                Object var16_23 = null;
                try {
                    rs = stat.executeQuery("TABLE TEST");
                    try {
                        this.assertTrue(rs.next());
                        this.assertEquals(bytes, rs.getBytes(2));
                        this.assertEquals(bytes, rs.getBytes(3));
                        this.assertEquals(s, rs.getString(4));
                        this.assertFalse(rs.next());
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                throwable3 = null;
                var16_23 = null;
                try {
                    rs = stat.executeQuery("SELECT COLUMN_NAME, DATA_TYPE, CHARACTER_OCTET_LENGTH FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TEST' ORDER BY ORDINAL_POSITION");
                    try {
                        this.assertTrue(rs.next());
                        this.assertEquals("ID", rs.getString(1));
                        this.assertEquals("BIGINT", rs.getString(2));
                        this.assertTrue(rs.next());
                        this.assertEquals("B", rs.getString(1));
                        this.assertEquals("BINARY VARYING", rs.getString(2));
                        this.assertEquals(1000000000L, rs.getLong(3));
                        this.assertTrue(rs.next());
                        this.assertEquals("L", rs.getString(1));
                        this.assertEquals("BINARY LARGE OBJECT", rs.getString(2));
                        this.assertEquals(Long.MAX_VALUE, rs.getLong(3));
                        this.assertTrue(rs.next());
                        this.assertEquals("C", rs.getString(1));
                        this.assertEquals("CHARACTER LARGE OBJECT", rs.getString(2));
                        this.assertEquals(Long.MAX_VALUE, rs.getLong(3));
                        this.assertFalse(rs.next());
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        this.deleteDb();
    }

    private void deleteDb() {
        for (FilePath p : FilePath.get(this.getBaseDir()).newDirectoryStream()) {
            if (!p.getName().startsWith("testUpgrade")) continue;
            FileUtils.deleteRecursive(p.toString(), false);
        }
    }
}

