/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.IOUtils;
import org.h2.util.Utils;

public class TestUtils
extends TestBase {
    public final String testField = "abc";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testIOUtils();
        this.testSortTopN();
        this.testSortTopNRandom();
        this.testGetNonPrimitiveClass();
        this.testGetNonPrimitiveClass();
        this.testGetNonPrimitiveClass();
        this.testReflectionUtils();
        this.testParseBoolean();
    }

    private void testIOUtils() throws IOException {
        int l;
        int read;
        int off;
        int j;
        Object[] buffer;
        Closeable in;
        Object[] data;
        int i = 0;
        while (i < 20) {
            data = new byte[i];
            in = new ByteArrayInputStream((byte[])data);
            buffer = new byte[i];
            this.assertEquals(0, IOUtils.readFully(in, buffer, -2));
            this.assertEquals(0, IOUtils.readFully(in, buffer, -1));
            this.assertEquals(0, IOUtils.readFully(in, buffer, 0));
            j = 1;
            off = 0;
            while (true) {
                read = Math.max(0, Math.min(i - off, j));
                l = IOUtils.readFully(in, buffer, j);
                this.assertEquals(read, l);
                off += l;
                if (l == 0) break;
                ++j;
            }
            this.assertEquals(0, IOUtils.readFully(in, buffer, 1));
            ++i;
        }
        i = 0;
        while (i < 10) {
            data = new char[i];
            in = new StringReader(new String((char[])data));
            buffer = new char[i];
            this.assertEquals(0, IOUtils.readFully((Reader)in, (char[])buffer, -2));
            this.assertEquals(0, IOUtils.readFully((Reader)in, (char[])buffer, -1));
            this.assertEquals(0, IOUtils.readFully((Reader)in, (char[])buffer, 0));
            j = 1;
            off = 0;
            while (true) {
                read = Math.max(0, Math.min(i - off, j));
                l = IOUtils.readFully((Reader)in, (char[])buffer, j);
                this.assertEquals(read, l);
                off += l;
                if (l == 0) break;
                ++j;
            }
            this.assertEquals(0, IOUtils.readFully((Reader)in, (char[])buffer, 1));
            ++i;
        }
    }

    private void testSortTopN() {
        Comparator comp = Comparator.naturalOrder();
        Integer[] arr = new Integer[]{};
        Utils.sortTopN(arr, 0, 0, comp);
        arr = new Integer[]{1};
        Utils.sortTopN(arr, 0, 1, comp);
        arr = new Integer[]{3, 5, 1, 4, 2};
        Utils.sortTopN(arr, 0, 2, comp);
        this.assertEquals((int)arr[0], 1);
        this.assertEquals((int)arr[1], 2);
    }

    private void testSortTopNRandom() {
        Random rnd = new Random();
        Comparator comp = Comparator.naturalOrder();
        int z = 0;
        while (z < 10000) {
            int length = 1 + rnd.nextInt(500);
            Object[] arr = new Integer[length];
            int i = 0;
            while (i < length) {
                arr[i] = rnd.nextInt(50);
                ++i;
            }
            Object[] arr2 = Arrays.copyOf(arr, length);
            int offset = rnd.nextInt(length);
            int limit = rnd.nextInt(length - offset + 1);
            Utils.sortTopN(arr, offset, offset + limit, comp);
            Arrays.sort(arr2, comp);
            int i2 = offset;
            int end = offset + limit;
            while (i2 < end) {
                if (!arr[i2].equals(arr2[i2])) {
                    this.fail(offset + " " + end + "\n" + Arrays.toString(arr) + "\n" + Arrays.toString(arr2));
                }
                ++i2;
            }
            ++z;
        }
    }

    private void testGetNonPrimitiveClass() {
        this.testGetNonPrimitiveClass(BigInteger.class, BigInteger.class);
        this.testGetNonPrimitiveClass(Boolean.class, Boolean.TYPE);
        this.testGetNonPrimitiveClass(Byte.class, Byte.TYPE);
        this.testGetNonPrimitiveClass(Character.class, Character.TYPE);
        this.testGetNonPrimitiveClass(Byte.class, Byte.TYPE);
        this.testGetNonPrimitiveClass(Double.class, Double.TYPE);
        this.testGetNonPrimitiveClass(Float.class, Float.TYPE);
        this.testGetNonPrimitiveClass(Integer.class, Integer.TYPE);
        this.testGetNonPrimitiveClass(Long.class, Long.TYPE);
        this.testGetNonPrimitiveClass(Short.class, Short.TYPE);
        this.testGetNonPrimitiveClass(Void.class, Void.TYPE);
    }

    private void testGetNonPrimitiveClass(Class<?> expected, Class<?> p) {
        this.assertEquals(expected.getName(), Utils.getNonPrimitiveClass(p).getName());
    }

    private void testReflectionUtils() throws Exception {
        long currentTimeNanos2;
        long currentTimeNanos1 = System.nanoTime();
        this.assertTrue(currentTimeNanos1 <= (currentTimeNanos2 = ((Long)Utils.callStaticMethod("java.lang.System.nanoTime", new Object[0])).longValue()));
        Object instance = Utils.newInstance("java.lang.StringBuilder", new Object[0]);
        instance = Utils.newInstance("java.lang.StringBuilder", 10);
        instance = Utils.newInstance("java.lang.Integer", 10);
        long x = (Long)Utils.callMethod(instance, "longValue", new Object[0]);
        this.assertEquals(10L, x);
        Utils.callStaticMethod("java.lang.String.valueOf", "a");
        Utils.callStaticMethod("java.awt.AWTKeyStroke.getAWTKeyStroke", Character.valueOf('x'), 64);
    }

    private void testParseBooleanCheckFalse(String value) {
        this.assertFalse(Utils.parseBoolean(value, false, false));
        this.assertFalse(Utils.parseBoolean(value, false, true));
        this.assertFalse(Utils.parseBoolean(value, true, false));
        this.assertFalse(Utils.parseBoolean(value, true, true));
    }

    private void testParseBooleanCheckTrue(String value) {
        this.assertTrue(Utils.parseBoolean(value, false, false));
        this.assertTrue(Utils.parseBoolean(value, false, true));
        this.assertTrue(Utils.parseBoolean(value, true, false));
        this.assertTrue(Utils.parseBoolean(value, true, true));
    }

    private void testParseBoolean() {
        this.assertFalse(Utils.parseBoolean(null, false, false));
        this.assertFalse(Utils.parseBoolean(null, false, true));
        this.assertTrue(Utils.parseBoolean(null, true, false));
        this.assertTrue(Utils.parseBoolean(null, true, true));
        this.testParseBooleanCheckFalse("0");
        this.testParseBooleanCheckFalse("f");
        this.testParseBooleanCheckFalse("F");
        this.testParseBooleanCheckFalse("n");
        this.testParseBooleanCheckFalse("N");
        this.testParseBooleanCheckFalse("no");
        this.testParseBooleanCheckFalse("No");
        this.testParseBooleanCheckFalse("NO");
        this.testParseBooleanCheckFalse("false");
        this.testParseBooleanCheckFalse("False");
        this.testParseBooleanCheckFalse("FALSE");
        this.testParseBooleanCheckTrue("1");
        this.testParseBooleanCheckTrue("t");
        this.testParseBooleanCheckTrue("T");
        this.testParseBooleanCheckTrue("y");
        this.testParseBooleanCheckTrue("Y");
        this.testParseBooleanCheckTrue("yes");
        this.testParseBooleanCheckTrue("Yes");
        this.testParseBooleanCheckTrue("YES");
        this.testParseBooleanCheckTrue("true");
        this.testParseBooleanCheckTrue("True");
        this.testParseBooleanCheckTrue("TRUE");
        this.assertFalse(Utils.parseBoolean("BAD", false, false));
        this.assertTrue(Utils.parseBoolean("BAD", true, false));
        this.assertThrows(IllegalArgumentException.class, () -> Utils.parseBoolean("BAD", false, true));
        this.assertThrows(IllegalArgumentException.class, () -> Utils.parseBoolean("BAD", true, true));
    }
}

