/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import org.h2.api.H2Type;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.DataHandler;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Bits;
import org.h2.util.JdbcUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBlob;
import org.h2.value.ValueClob;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueToObjectConverter2;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public class TestValue
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testBinaryAndUuid();
        this.testCastTrim();
        this.testDataType();
        this.testArray();
        this.testUUID();
        this.testDouble(false);
        this.testDouble(true);
        this.testTimestamp();
        this.testModulusDouble();
        this.testModulusDecimal();
        this.testModulusOperator();
        this.testLobComparison();
        this.testTypeInfo();
        this.testH2Type();
        this.testHigherType();
    }

    private void testBinaryAndUuid() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("binaryAndUuid");){
                UUID uuid = UUID.randomUUID();
                PreparedStatement prep = conn.prepareStatement("SELECT * FROM TABLE(X BINARY(16)=?)");
                prep.setObject(1, new Object[]{uuid});
                ResultSet rs = prep.executeQuery();
                rs.next();
                this.assertTrue(Arrays.equals(Bits.uuidToBytes(uuid), (byte[])rs.getObject(1)));
                prep = conn.prepareStatement("SELECT * FROM TABLE(X VARBINARY=?)");
                prep.setObject(1, new Object[]{uuid});
                rs = prep.executeQuery();
                rs.next();
                this.assertTrue(Arrays.equals(Bits.uuidToBytes(uuid), (byte[])rs.getObject(1)));
                prep = conn.prepareStatement("SELECT * FROM TABLE(X UUID=?)");
                prep.setObject(1, new Object[]{uuid});
                rs = prep.executeQuery();
                rs.next();
                this.assertEquals(uuid, rs.getObject(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("binaryAndUuid");
        }
    }

    private void testCastTrim() {
        String spaces = new String(new char[100]).replace('\u0000', ' ');
        Value v = ValueArray.get(new Value[]{ValueVarchar.get("hello"), ValueVarchar.get("world")}, null);
        TypeInfo typeInfo = TypeInfo.getTypeInfo(40, 1L, 0, TypeInfo.TYPE_VARCHAR);
        this.assertEquals(2L, v.getType().getPrecision());
        this.assertEquals(1L, v.castTo(typeInfo, null).getType().getPrecision());
        v = ValueArray.get(new Value[]{ValueVarchar.get(""), ValueVarchar.get("")}, null);
        this.assertEquals(2L, v.getType().getPrecision());
        this.assertEquals("ARRAY ['']", v.castTo(typeInfo, null).toString());
        v = ValueVarbinary.get(spaces.getBytes());
        typeInfo = TypeInfo.getTypeInfo(6, 10L, 0, null);
        this.assertEquals(100L, v.getType().getPrecision());
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        this.assertEquals(10, v.castTo(typeInfo, null).getBytes().length);
        this.assertEquals(32, v.castTo(typeInfo, null).getBytes()[9]);
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        v = ValueClob.createSmall(spaces.getBytes(), 100L);
        typeInfo = TypeInfo.getTypeInfo(3, 10L, 0, null);
        this.assertEquals(100L, v.getType().getPrecision());
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        this.assertEquals(10, v.castTo(typeInfo, null).getString().length());
        this.assertEquals("          ", v.castTo(typeInfo, null).getString());
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        v = ValueBlob.createSmall(spaces.getBytes());
        typeInfo = TypeInfo.getTypeInfo(7, 10L, 0, null);
        this.assertEquals(100L, v.getType().getPrecision());
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        this.assertEquals(10, v.castTo(typeInfo, null).getBytes().length);
        this.assertEquals(32, v.castTo(typeInfo, null).getBytes()[9]);
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        v = ValueVarchar.get(spaces);
        typeInfo = TypeInfo.getTypeInfo(2, 10L, 0, null);
        this.assertEquals(100L, v.getType().getPrecision());
        this.assertEquals(10L, v.castTo(typeInfo, null).getType().getPrecision());
        this.assertEquals("          ", v.castTo(typeInfo, null).getString());
        this.assertEquals("          ", v.castTo(typeInfo, null).getString());
    }

    private void testDataType() {
        this.testDataType(TypeInfo.TYPE_NULL, null);
        this.testDataType(TypeInfo.TYPE_NULL, Void.class);
        this.testDataType(TypeInfo.TYPE_NULL, Void.TYPE);
        this.testDataType(TypeInfo.getTypeInfo(40, Integer.MAX_VALUE, 0, TypeInfo.TYPE_VARCHAR), String[].class);
        this.testDataType(TypeInfo.TYPE_VARCHAR, String.class);
        this.testDataType(TypeInfo.TYPE_INTEGER, Integer.class);
        this.testDataType(TypeInfo.TYPE_BIGINT, Long.class);
        this.testDataType(TypeInfo.TYPE_BOOLEAN, Boolean.class);
        this.testDataType(TypeInfo.TYPE_DOUBLE, Double.class);
        this.testDataType(TypeInfo.TYPE_TINYINT, Byte.class);
        this.testDataType(TypeInfo.TYPE_SMALLINT, Short.class);
        this.testDataType(TypeInfo.TYPE_REAL, Float.class);
        this.testDataType(TypeInfo.TYPE_VARBINARY, byte[].class);
        this.testDataType(TypeInfo.TYPE_UUID, UUID.class);
        this.testDataType(TypeInfo.TYPE_NULL, Void.class);
        this.testDataType(TypeInfo.TYPE_NUMERIC_FLOATING_POINT, BigDecimal.class);
        this.testDataType(TypeInfo.TYPE_DATE, Date.class);
        this.testDataType(TypeInfo.TYPE_TIME, Time.class);
        this.testDataType(TypeInfo.TYPE_TIMESTAMP, Timestamp.class);
        this.testDataType(TypeInfo.TYPE_TIMESTAMP, java.util.Date.class);
        this.testDataType(TypeInfo.TYPE_CLOB, Reader.class);
        this.testDataType(TypeInfo.TYPE_CLOB, Clob.class);
        this.testDataType(TypeInfo.TYPE_BLOB, InputStream.class);
        this.testDataType(TypeInfo.TYPE_BLOB, Blob.class);
        this.testDataType(TypeInfo.getTypeInfo(40, Integer.MAX_VALUE, 0, TypeInfo.TYPE_JAVA_OBJECT), Object[].class);
        this.testDataType(TypeInfo.TYPE_JAVA_OBJECT, StringBuffer.class);
    }

    private void testDataType(TypeInfo type, Class<?> clazz) {
        this.assertEquals(type, ValueToObjectConverter2.classToType(clazz));
    }

    private void testDouble(boolean useFloat) {
        double[] d = new double[]{Double.NEGATIVE_INFINITY, -1.0, 0.0, 1.0, Double.POSITIVE_INFINITY, Double.NaN};
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = 1;
        nArray[4] = 1;
        int[] signum = nArray;
        Value[] values = new Value[d.length];
        int i = 0;
        while (i < d.length) {
            Value v;
            values[i] = v = useFloat ? ValueReal.get((float)d[i]) : ValueDouble.get(d[i]);
            this.assertTrue(values[i].compareTypeSafe(values[i], null, null) == 0);
            this.assertTrue(v.equals(v));
            this.assertEquals(signum[i], v.getSignum());
            ++i;
        }
        i = 0;
        while (i < d.length - 1) {
            this.assertTrue(values[i].compareTypeSafe(values[i + 1], null, null) < 0);
            this.assertTrue(values[i + 1].compareTypeSafe(values[i], null, null) > 0);
            this.assertFalse(values[i].equals(values[i + 1]));
            ++i;
        }
    }

    private void testTimestamp() {
        ValueTimestamp valueTs = ValueTimestamp.parse("2000-01-15 10:20:30.333222111", null);
        Timestamp ts = Timestamp.valueOf("2000-01-15 10:20:30.333222111");
        this.assertEquals(ts.toString(), valueTs.getString());
        this.assertEquals(ts, LegacyDateTimeUtils.toTimestamp(null, null, valueTs));
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        c.set(2018, 2, 25, 1, 59, 0);
        c.set(14, 123);
        long expected = c.getTimeInMillis();
        ts = LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("2018-03-25 01:59:00.123123123 Europe/Berlin", null));
        this.assertEquals(expected, ts.getTime());
        this.assertEquals(123123123, ts.getNanos());
        ts = LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("2018-03-25 01:59:00.123123123+01", null));
        this.assertEquals(expected, ts.getTime());
        this.assertEquals(123123123, ts.getNanos());
        ts = LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("2018-03-25 03:00:00.123123123 Europe/Berlin", null));
        this.assertEquals(expected += 60000L, ts.getTime());
        this.assertEquals(123123123, ts.getNanos());
        ts = LegacyDateTimeUtils.toTimestamp(null, null, ValueTimestamp.parse("2018-03-25 03:00:00.123123123+02", null));
        this.assertEquals(expected, ts.getTime());
        this.assertEquals(123123123, ts.getNanos());
    }

    private void testArray() {
        ValueArray src = ValueArray.get(new Value[]{ValueVarchar.get("1"), ValueVarchar.get("22"), ValueVarchar.get("333")}, null);
        this.assertEquals(3L, src.getType().getPrecision());
        this.assertSame(src, src.castTo(TypeInfo.getTypeInfo(40, 3L, 0, TypeInfo.TYPE_VARCHAR), null));
        ValueArray exp = ValueArray.get(new Value[]{ValueVarchar.get("1"), ValueVarchar.get("22")}, null);
        Value got = src.castTo(TypeInfo.getTypeInfo(40, 2L, 0, TypeInfo.TYPE_VARCHAR), null);
        this.assertEquals(exp, got);
        this.assertEquals(2, ((ValueArray)got).getComponentType().getValueType());
        exp = ValueArray.get(TypeInfo.TYPE_VARCHAR, new Value[0], null);
        got = src.castTo(TypeInfo.getTypeInfo(40, 0L, 0, TypeInfo.TYPE_VARCHAR), null);
        this.assertEquals(exp, got);
        this.assertEquals(2, ((ValueArray)got).getComponentType().getValueType());
    }

    private void testUUID() {
        long maxHigh = 0L;
        long maxLow = 0L;
        long minHigh = -1L;
        long minLow = -1L;
        int i = 0;
        while (i < 100) {
            ValueUuid uuid = ValueUuid.getNewRandom();
            maxHigh |= uuid.getHigh();
            maxLow |= uuid.getLow();
            minHigh &= uuid.getHigh();
            minLow &= uuid.getLow();
            ++i;
        }
        ValueUuid max = ValueUuid.get(maxHigh, maxLow);
        this.assertEquals("ffffffff-ffff-4fff-bfff-ffffffffffff", max.getString());
        ValueUuid min = ValueUuid.get(minHigh, minLow);
        this.assertEquals("00000000-0000-4000-8000-000000000000", min.getString());
        String uuidStr = "12345678-1234-4321-8765-123456789012";
        UUID origUUID = UUID.fromString(uuidStr);
        ValueJavaObject valObj = ValueJavaObject.getNoCopy(JdbcUtils.serialize(origUUID, null));
        ValueUuid valUUID = valObj.convertToUuid();
        this.assertEquals(uuidStr, valUUID.getString());
        this.assertEquals(origUUID, valUUID.getUuid());
        ValueJavaObject voString = ValueJavaObject.getNoCopy(JdbcUtils.serialize(new String("This is not a ValueUuid object"), null));
        this.assertThrows(90027, () -> voString.convertToUuid());
    }

    private void testModulusDouble() {
        ValueDouble vd1 = ValueDouble.get(12.0);
        this.assertThrows(22012, () -> vd1.modulus(ValueDouble.ZERO));
        ValueDouble vd2 = ValueDouble.get(10.0);
        ValueDouble vd3 = vd1.modulus(vd2);
        this.assertEquals(2.0, vd3.getDouble());
    }

    private void testModulusDecimal() {
        ValueNumeric vd1 = ValueNumeric.get(new BigDecimal(12));
        this.assertThrows(22012, () -> vd1.modulus(ValueNumeric.ZERO));
        ValueNumeric vd2 = ValueNumeric.get(new BigDecimal(10));
        Value vd3 = vd1.modulus(vd2);
        this.assertEquals(2.0, vd3.getDouble());
    }

    private void testModulusOperator() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("modulus");){
                ResultSet rs = conn.createStatement().executeQuery("CALL 12 % 10");
                rs.next();
                this.assertEquals(2, rs.getInt(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("modulus");
        }
    }

    private void testLobComparison() throws SQLException {
        this.assertEquals(0, TestValue.testLobComparisonImpl(null, 7, 0, 0, 0, 0));
        this.assertEquals(0, TestValue.testLobComparisonImpl(null, 3, 0, 0, 0, 0));
        this.assertEquals(-1, TestValue.testLobComparisonImpl(null, 7, 1, 1, 200, 210));
        this.assertEquals(-1, TestValue.testLobComparisonImpl(null, 3, 1, 1, 97, 98));
        this.assertEquals(1, TestValue.testLobComparisonImpl(null, 7, 512, 512, 210, 200));
        this.assertEquals(1, TestValue.testLobComparisonImpl(null, 3, 512, 512, 66, 65));
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection c = DriverManager.getConnection("jdbc:h2:mem:testValue");){
            Database dh = ((SessionLocal)((JdbcConnection)c).getSession()).getDatabase();
            this.assertEquals(1, TestValue.testLobComparisonImpl(dh, 7, 1024, 1024, 210, 200));
            this.assertEquals(1, TestValue.testLobComparisonImpl(dh, 3, 1024, 1024, 66, 65));
            this.assertEquals(-1, TestValue.testLobComparisonImpl(dh, 7, 10000, 10000, 200, 210));
            this.assertEquals(-1, TestValue.testLobComparisonImpl(dh, 3, 10000, 10000, 97, 98));
            this.assertEquals(0, TestValue.testLobComparisonImpl(dh, 7, 10000, 10000, 0, 0));
            this.assertEquals(0, TestValue.testLobComparisonImpl(dh, 3, 10000, 10000, 0, 0));
            this.assertEquals(-1, TestValue.testLobComparisonImpl(dh, 7, 1000, 10000, 0, 0));
            this.assertEquals(-1, TestValue.testLobComparisonImpl(dh, 3, 1000, 10000, 0, 0));
            this.assertEquals(1, TestValue.testLobComparisonImpl(dh, 7, 10000, 1000, 0, 0));
            this.assertEquals(1, TestValue.testLobComparisonImpl(dh, 3, 10000, 1000, 0, 0));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int testLobComparisonImpl(DataHandler dh, int type, int size1, int size2, int suffix1, int suffix2) {
        byte[] bytes1 = new byte[size1];
        byte[] bytes2 = new byte[size2];
        if (size1 > 0) {
            bytes1[size1 - 1] = (byte)suffix1;
        }
        if (size2 > 0) {
            bytes2[size2 - 1] = (byte)suffix2;
        }
        Value lob1 = TestValue.createLob(dh, type, bytes1);
        Value lob2 = TestValue.createLob(dh, type, bytes2);
        return lob1.compareTypeSafe(lob2, null, null);
    }

    private static Value createLob(DataHandler dh, int type, byte[] bytes) {
        if (dh == null) {
            return type == 7 ? ValueBlob.createSmall(bytes) : ValueClob.createSmall(bytes);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (type == 7) {
            return dh.getLobStorage().createBlob(in, -1L);
        }
        return dh.getLobStorage().createClob(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), -1L);
    }

    private void testTypeInfo() {
        int d;
        this.testTypeInfoCheck(-1, -1L, -1, -1, TypeInfo.TYPE_UNKNOWN);
        this.assertThrows(50004, () -> TypeInfo.getTypeInfo(-1));
        this.testTypeInfoCheck(0, 1L, 0, 4, TypeInfo.TYPE_NULL, TypeInfo.getTypeInfo(0));
        this.testTypeInfoCheck(8, 1L, 0, 5, TypeInfo.TYPE_BOOLEAN, TypeInfo.getTypeInfo(8));
        this.testTypeInfoCheck(9, 8L, 0, 4, TypeInfo.TYPE_TINYINT, TypeInfo.getTypeInfo(9));
        this.testTypeInfoCheck(10, 16L, 0, 6, TypeInfo.TYPE_SMALLINT, TypeInfo.getTypeInfo(10));
        this.testTypeInfoCheck(11, 32L, 0, 11, TypeInfo.TYPE_INTEGER, TypeInfo.getTypeInfo(11));
        this.testTypeInfoCheck(12, 64L, 0, 20, TypeInfo.TYPE_BIGINT, TypeInfo.getTypeInfo(12));
        this.testTypeInfoCheck(14, 24L, 0, 15, TypeInfo.TYPE_REAL, TypeInfo.getTypeInfo(14));
        this.testTypeInfoCheck(15, 53L, 0, 24, TypeInfo.TYPE_DOUBLE, TypeInfo.getTypeInfo(15));
        this.testTypeInfoCheck(13, 100000L, 50000, 100002, TypeInfo.TYPE_NUMERIC_FLOATING_POINT);
        this.testTypeInfoCheck(18, 18L, 9, 18, TypeInfo.TYPE_TIME, TypeInfo.getTypeInfo(18));
        int s = 0;
        while (s <= 9) {
            d = s > 0 ? s + 9 : 8;
            this.testTypeInfoCheck(18, (long)d, s, d, TypeInfo.getTypeInfo(18, 0L, s, null));
            ++s;
        }
        this.testTypeInfoCheck(17, 10L, 0, 10, TypeInfo.TYPE_DATE, TypeInfo.getTypeInfo(17));
        this.testTypeInfoCheck(20, 29L, 9, 29, TypeInfo.TYPE_TIMESTAMP, TypeInfo.getTypeInfo(20));
        s = 0;
        while (s <= 9) {
            d = s > 0 ? s + 20 : 19;
            this.testTypeInfoCheck(20, (long)d, s, d, TypeInfo.getTypeInfo(20, 0L, s, null));
            ++s;
        }
        this.testTypeInfoCheck(21, 35L, 9, 35, TypeInfo.TYPE_TIMESTAMP_TZ, TypeInfo.getTypeInfo(21));
        s = 0;
        while (s <= 9) {
            d = s > 0 ? s + 26 : 25;
            this.testTypeInfoCheck(21, (long)d, s, d, TypeInfo.getTypeInfo(21, 0L, s, null));
            ++s;
        }
        this.testTypeInfoCheck(5, 1L, 0, 2, TypeInfo.getTypeInfo(5));
        this.testTypeInfoCheck(6, 1000000000L, 0, 2000000000, TypeInfo.getTypeInfo(6));
        this.testTypeInfoCheck(7, Long.MAX_VALUE, 0, Integer.MAX_VALUE, TypeInfo.getTypeInfo(7));
        this.testTypeInfoCheck(3, Long.MAX_VALUE, 0, Integer.MAX_VALUE, TypeInfo.getTypeInfo(3));
        this.testTypeInfoCheck(2, 1000000000L, 0, 1000000000, TypeInfo.TYPE_VARCHAR, TypeInfo.getTypeInfo(2));
        this.testTypeInfoCheck(1, 1L, 0, 1, TypeInfo.getTypeInfo(1));
        this.testTypeInfoCheck(4, 1000000000L, 0, 1000000000, TypeInfo.getTypeInfo(4));
        this.testTypeInfoCheck(40, 65536L, 0, Integer.MAX_VALUE, TypeInfo.TYPE_ARRAY_UNKNOWN, TypeInfo.getTypeInfo(40));
        this.testTypeInfoCheck(41, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, TypeInfo.TYPE_ROW_EMPTY, TypeInfo.getTypeInfo(41));
        this.testTypeInfoCheck(35, 1000000000L, 0, 2000000000, TypeInfo.TYPE_JAVA_OBJECT, TypeInfo.getTypeInfo(35));
        this.testTypeInfoCheck(39, 16L, 0, 36, TypeInfo.TYPE_UUID, TypeInfo.getTypeInfo(39));
        this.testTypeInfoCheck(37, 1000000000L, 0, Integer.MAX_VALUE, TypeInfo.TYPE_GEOMETRY, TypeInfo.getTypeInfo(37));
        this.testTypeInfoCheck(36, 1000000000L, 0, 1000000000, TypeInfo.TYPE_ENUM_UNDEFINED, TypeInfo.getTypeInfo(36));
        this.testTypeInfoInterval1(22);
        this.testTypeInfoInterval1(23);
        this.testTypeInfoInterval1(24);
        this.testTypeInfoInterval1(25);
        this.testTypeInfoInterval1(26);
        this.testTypeInfoInterval2(27);
        this.testTypeInfoInterval1(28);
        this.testTypeInfoInterval1(29);
        this.testTypeInfoInterval1(30);
        this.testTypeInfoInterval2(31);
        this.testTypeInfoInterval1(32);
        this.testTypeInfoInterval2(33);
        this.testTypeInfoInterval2(34);
        this.testTypeInfoCheck(38, 1000000000L, 0, 1000000000, TypeInfo.TYPE_JSON, TypeInfo.getTypeInfo(38));
    }

    private void testTypeInfoInterval1(int type) {
        this.testTypeInfoCheck(type, 18L, 0, ValueInterval.getDisplaySize(type, 18, 0), TypeInfo.getTypeInfo(type));
        int p = 1;
        while (p <= 18) {
            this.testTypeInfoCheck(type, (long)p, 0, ValueInterval.getDisplaySize(type, p, 0), TypeInfo.getTypeInfo(type, p, 0, null));
            ++p;
        }
    }

    private void testTypeInfoInterval2(int type) {
        this.testTypeInfoCheck(type, 18L, 9, ValueInterval.getDisplaySize(type, 18, 9), TypeInfo.getTypeInfo(type));
        int p = 1;
        while (p <= 18) {
            int s = 0;
            while (s <= 9) {
                this.testTypeInfoCheck(type, (long)p, s, ValueInterval.getDisplaySize(type, p, s), TypeInfo.getTypeInfo(type, p, s, null));
                ++s;
            }
            ++p;
        }
    }

    private void testTypeInfoCheck(int valueType, long precision, int scale, int displaySize, TypeInfo ... typeInfos) {
        TypeInfo[] typeInfoArray = typeInfos;
        int n = typeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            TypeInfo typeInfo = typeInfoArray[n2];
            this.testTypeInfoCheck(valueType, precision, scale, displaySize, typeInfo);
            ++n2;
        }
    }

    private void testTypeInfoCheck(int valueType, long precision, int scale, int displaySize, TypeInfo typeInfo) {
        this.assertEquals(valueType, typeInfo.getValueType());
        this.assertEquals(precision, typeInfo.getPrecision());
        this.assertEquals(scale, typeInfo.getScale());
        this.assertEquals(displaySize, typeInfo.getDisplaySize());
    }

    private void testH2Type() {
        this.assertEquals(1, (int)H2Type.CHAR.getVendorTypeNumber());
        this.assertEquals(2, (int)H2Type.VARCHAR.getVendorTypeNumber());
        this.assertEquals(3, (int)H2Type.CLOB.getVendorTypeNumber());
        this.assertEquals(4, (int)H2Type.VARCHAR_IGNORECASE.getVendorTypeNumber());
        this.assertEquals(5, (int)H2Type.BINARY.getVendorTypeNumber());
        this.assertEquals(6, (int)H2Type.VARBINARY.getVendorTypeNumber());
        this.assertEquals(7, (int)H2Type.BLOB.getVendorTypeNumber());
        this.assertEquals(8, (int)H2Type.BOOLEAN.getVendorTypeNumber());
        this.assertEquals(9, (int)H2Type.TINYINT.getVendorTypeNumber());
        this.assertEquals(10, (int)H2Type.SMALLINT.getVendorTypeNumber());
        this.assertEquals(11, (int)H2Type.INTEGER.getVendorTypeNumber());
        this.assertEquals(12, (int)H2Type.BIGINT.getVendorTypeNumber());
        this.assertEquals(13, (int)H2Type.NUMERIC.getVendorTypeNumber());
        this.assertEquals(14, (int)H2Type.REAL.getVendorTypeNumber());
        this.assertEquals(15, (int)H2Type.DOUBLE_PRECISION.getVendorTypeNumber());
        this.assertEquals(16, (int)H2Type.DECFLOAT.getVendorTypeNumber());
        this.assertEquals(17, (int)H2Type.DATE.getVendorTypeNumber());
        this.assertEquals(18, (int)H2Type.TIME.getVendorTypeNumber());
        this.assertEquals(19, (int)H2Type.TIME_WITH_TIME_ZONE.getVendorTypeNumber());
        this.assertEquals(20, (int)H2Type.TIMESTAMP.getVendorTypeNumber());
        this.assertEquals(21, (int)H2Type.TIMESTAMP_WITH_TIME_ZONE.getVendorTypeNumber());
        this.assertEquals(22, (int)H2Type.INTERVAL_YEAR.getVendorTypeNumber());
        this.assertEquals(23, (int)H2Type.INTERVAL_MONTH.getVendorTypeNumber());
        this.assertEquals(24, (int)H2Type.INTERVAL_DAY.getVendorTypeNumber());
        this.assertEquals(25, (int)H2Type.INTERVAL_HOUR.getVendorTypeNumber());
        this.assertEquals(26, (int)H2Type.INTERVAL_MINUTE.getVendorTypeNumber());
        this.assertEquals(27, (int)H2Type.INTERVAL_SECOND.getVendorTypeNumber());
        this.assertEquals(28, (int)H2Type.INTERVAL_YEAR_TO_MONTH.getVendorTypeNumber());
        this.assertEquals(29, (int)H2Type.INTERVAL_DAY_TO_HOUR.getVendorTypeNumber());
        this.assertEquals(30, (int)H2Type.INTERVAL_DAY_TO_MINUTE.getVendorTypeNumber());
        this.assertEquals(31, (int)H2Type.INTERVAL_DAY_TO_SECOND.getVendorTypeNumber());
        this.assertEquals(32, (int)H2Type.INTERVAL_HOUR_TO_MINUTE.getVendorTypeNumber());
        this.assertEquals(33, (int)H2Type.INTERVAL_HOUR_TO_SECOND.getVendorTypeNumber());
        this.assertEquals(34, (int)H2Type.INTERVAL_MINUTE_TO_SECOND.getVendorTypeNumber());
        this.assertEquals(35, (int)H2Type.JAVA_OBJECT.getVendorTypeNumber());
        this.assertEquals(36, (int)H2Type.ENUM.getVendorTypeNumber());
        this.assertEquals(37, (int)H2Type.GEOMETRY.getVendorTypeNumber());
        this.assertEquals(38, (int)H2Type.JSON.getVendorTypeNumber());
        this.assertEquals(39, (int)H2Type.UUID.getVendorTypeNumber());
        this.assertEquals(40, (int)H2Type.array(H2Type.VARCHAR).getVendorTypeNumber());
        this.assertEquals(41, (int)H2Type.row(H2Type.VARCHAR).getVendorTypeNumber());
    }

    private void testHigherType() {
        this.testHigherTypeNumeric(15L, 6, 10L, 1, 5L, 6);
        this.testHigherTypeNumeric(15L, 6, 5L, 6, 10L, 1);
        TypeInfo intArray10 = TypeInfo.getTypeInfo(40, 10L, 0, TypeInfo.TYPE_INTEGER);
        TypeInfo bigintArray1 = TypeInfo.getTypeInfo(40, 1L, 0, TypeInfo.TYPE_BIGINT);
        TypeInfo bigintArray10 = TypeInfo.getTypeInfo(40, 10L, 0, TypeInfo.TYPE_BIGINT);
        this.assertEquals(bigintArray10, TypeInfo.getHigherType(intArray10, bigintArray1));
        TypeInfo intArray10Array1 = TypeInfo.getTypeInfo(40, 1L, 0, intArray10);
        TypeInfo bigintArray1Array10 = TypeInfo.getTypeInfo(40, 10L, 0, bigintArray1);
        TypeInfo bigintArray10Array10 = TypeInfo.getTypeInfo(40, 10L, 0, bigintArray10);
        this.assertEquals(bigintArray10Array10, TypeInfo.getHigherType(intArray10Array1, bigintArray1Array10));
        this.assertEquals(bigintArray10Array10, TypeInfo.getHigherType(intArray10, bigintArray1Array10));
        TypeInfo bigintArray10Array1 = TypeInfo.getTypeInfo(40, 1L, 0, bigintArray10);
        this.assertEquals(bigintArray10Array1, TypeInfo.getHigherType(intArray10Array1, bigintArray1));
    }

    private void testHigherTypeNumeric(long expectedPrecision, int expectedScale, long precision1, int scale1, long precision2, int scale2) {
        this.assertEquals(TypeInfo.getTypeInfo(13, expectedPrecision, expectedScale, null), TypeInfo.getHigherType(TypeInfo.getTypeInfo(13, precision1, scale1, null), TypeInfo.getTypeInfo(13, precision2, scale2, null)));
    }
}

