/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Random;
import org.h2.api.IntervalQualifier;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorageInterface;
import org.h2.test.TestBase;
import org.h2.test.utils.MemoryFootprint;
import org.h2.util.DateTimeUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

public class TestValueMemory
extends TestBase
implements DataHandler {
    private static final long MIN_ABSOLUTE_DAY = DateTimeUtils.absoluteDayFromDateValue(-511999999967L);
    private static final long MAX_ABSOLUTE_DAY = DateTimeUtils.absoluteDayFromDateValue(512000000415L);
    private final Random random = new Random(1L);
    private final SmallLRUCache<String, String[]> lobFileListCache = SmallLRUCache.newInstance(128);
    private LobStorageTest lobStorage;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.testFromMain();
    }

    @Override
    public void test() throws SQLException {
        Value v;
        this.testCompare();
        int i = 0;
        while (i < 42) {
            if (i != 23 && i != 36) {
                v = this.create(i);
                String s = "type: " + v.getValueType() + " calculated: " + v.getMemory() + " real: " + MemoryFootprint.getObjectSize(v) + " " + v.getClass().getName() + ": " + v.toString();
                this.trace(s);
            }
            ++i;
        }
        i = 0;
        while (i < 42) {
            if (i != 23 && i != 36 && ((v = this.create(i)) != ValueNull.INSTANCE || i != 37)) {
                this.assertEquals(i, v.getValueType());
                this.testType(i);
            }
            ++i;
        }
    }

    private void testCompare() {
        ValueNumeric a = ValueNumeric.get(new BigDecimal("0.0"));
        ValueNumeric b = ValueNumeric.get(new BigDecimal("-0.00"));
        this.assertTrue(a.hashCode() != b.hashCode());
        this.assertFalse(a.equals(b));
    }

    private void testType(int type) throws SQLException {
        System.gc();
        System.gc();
        long first = Utils.getMemoryUsed();
        ArrayList<Value> list = new ArrayList<Value>();
        long memory = 0L;
        while (memory < 1000000L) {
            Value v = this.create(type);
            memory += (long)(v.getMemory() + 8);
            list.add(v);
        }
        Object[] array = list.toArray();
        IdentityHashMap<Object, Object> map = new IdentityHashMap<Object, Object>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            map.put(a, a);
            ++n2;
        }
        int size = map.size();
        map.clear();
        map = null;
        list = null;
        System.gc();
        System.gc();
        long used = Utils.getMemoryUsed() - first;
        if (this.config.traceTest || used > (memory /= 1024L) * 3L) {
            String msg = "Type: " + type + " Used memory: " + used + " calculated: " + memory + " length: " + array.length + " size: " + size;
            if (this.config.traceTest) {
                this.trace(msg);
            }
            if (used > memory * 3L) {
                this.fail(msg);
            }
        }
    }

    private Value create(int type) throws SQLException {
        switch (type) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 8: {
                return ValueBoolean.FALSE;
            }
            case 9: {
                return ValueTinyint.get((byte)this.random.nextInt());
            }
            case 10: {
                return ValueSmallint.get((short)this.random.nextInt());
            }
            case 11: {
                return ValueInteger.get(this.random.nextInt());
            }
            case 12: {
                return ValueBigint.get(this.random.nextLong());
            }
            case 13: {
                return ValueNumeric.get(new BigDecimal(this.random.nextInt()));
            }
            case 15: {
                return ValueDouble.get(this.random.nextDouble());
            }
            case 14: {
                return ValueReal.get(this.random.nextFloat());
            }
            case 16: {
                return ValueDecfloat.get(new BigDecimal(this.random.nextInt()));
            }
            case 18: {
                return ValueTime.fromNanos(this.randomTimeNanos());
            }
            case 19: {
                return ValueTimeTimeZone.fromNanos(this.randomTimeNanos(), this.randomZoneOffset());
            }
            case 17: {
                return ValueDate.fromDateValue(this.randomDateValue());
            }
            case 20: {
                return ValueTimestamp.fromDateValueAndNanos(this.randomDateValue(), this.randomTimeNanos());
            }
            case 21: {
                return ValueTimestampTimeZone.fromDateValueAndNanos(this.randomDateValue(), this.randomTimeNanos(), this.randomZoneOffset());
            }
            case 6: {
                return ValueVarbinary.get(this.randomBytes(this.random.nextInt(1000)));
            }
            case 2: {
                return ValueVarchar.get(this.randomString(this.random.nextInt(100)));
            }
            case 4: {
                return ValueVarcharIgnoreCase.get(this.randomString(this.random.nextInt(100)));
            }
            case 7: {
                int len = (int)Math.abs(this.random.nextGaussian() * 10.0);
                byte[] data = this.randomBytes(len);
                return this.getLobStorage().createBlob(new ByteArrayInputStream(data), len);
            }
            case 3: {
                int len = (int)Math.abs(this.random.nextGaussian() * 10.0);
                String s = this.randomString(len);
                return this.getLobStorage().createClob(new StringReader(s), len);
            }
            case 40: {
                return ValueArray.get(this.createArray(), null);
            }
            case 41: {
                return ValueRow.get(this.createArray());
            }
            case 35: {
                return ValueJavaObject.getNoCopy(this.randomBytes(this.random.nextInt(100)));
            }
            case 39: {
                return ValueUuid.get(this.random.nextLong(), this.random.nextLong());
            }
            case 1: {
                return ValueChar.get(this.randomString(this.random.nextInt(100)));
            }
            case 37: {
                return ValueGeometry.get("POINT (" + this.random.nextInt(100) + " " + this.random.nextInt(100) + ")");
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return ValueInterval.from(IntervalQualifier.valueOf(type - 22), this.random.nextBoolean(), this.random.nextInt(Integer.MAX_VALUE), 0L);
            }
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                return ValueInterval.from(IntervalQualifier.valueOf(type - 22), this.random.nextBoolean(), this.random.nextInt(Integer.MAX_VALUE), this.random.nextInt(1000000000));
            }
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                return ValueInterval.from(IntervalQualifier.valueOf(type - 22), this.random.nextBoolean(), this.random.nextInt(Integer.MAX_VALUE), this.random.nextInt(12));
            }
            case 38: {
                return ValueJson.fromJson("{\"key\":\"value\"}");
            }
            case 5: {
                return ValueBinary.get(this.randomBytes(this.random.nextInt(1000)));
            }
        }
        throw new AssertionError((Object)("type=" + type));
    }

    private long randomDateValue() {
        return DateTimeUtils.dateValueFromAbsoluteDay((this.random.nextLong() & Long.MAX_VALUE) % (MAX_ABSOLUTE_DAY - MIN_ABSOLUTE_DAY + 1L) + MIN_ABSOLUTE_DAY);
    }

    private long randomTimeNanos() {
        return (this.random.nextLong() & Long.MAX_VALUE) % 86400000000000L;
    }

    private short randomZoneOffset() {
        return (short)(this.random.nextInt() % 1080);
    }

    private Value[] createArray() throws SQLException {
        int len = this.random.nextInt(20);
        Value[] list = new Value[len];
        int i = 0;
        while (i < list.length) {
            list[i] = this.create(2);
            ++i;
        }
        return list;
    }

    private byte[] randomBytes(int len) {
        byte[] data = new byte[len];
        if (this.random.nextBoolean()) {
            this.random.nextBytes(data);
        }
        return data;
    }

    private String randomString(int len) {
        char[] chars = new char[len];
        if (this.random.nextBoolean()) {
            int i = 0;
            while (i < chars.length) {
                chars[i] = (char)(this.random.nextGaussian() * 100.0);
                ++i;
            }
        }
        return new String(chars);
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public String getDatabasePath() {
        return this.getBaseDir() + "/valueMemory";
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return 100;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        return FileStore.open(this, name, mode);
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return this.lobFileListCache;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageInterface getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorageTest();
        }
        return this.lobStorage;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        return -1;
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }

    private class LobStorageTest
    implements LobStorageInterface {
        LobStorageTest() {
        }

        @Override
        public void removeLob(ValueLob lob) {
        }

        @Override
        public InputStream getInputStream(long lobId, long byteCount) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public InputStream getInputStream(long lobId, int tableId, long byteCount) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public ValueLob copyLob(ValueLob old, int tableId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllForTable(int tableId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueBlob createBlob(InputStream in, long maxLength) {
            return ValueBlob.createTempBlob(in, maxLength, TestValueMemory.this);
        }

        @Override
        public ValueClob createClob(Reader reader, long maxLength) {
            return ValueClob.createTempClob(reader, maxLength, TestValueMemory.this);
        }
    }
}

