/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.test.utils.FilePathDebug;

class FileDebug
extends FileBase {
    private final FilePathDebug debug;
    private final FileChannel channel;
    private final String name;

    FileDebug(FilePathDebug debug, FileChannel channel, String name) {
        this.debug = debug;
        this.channel = channel;
        this.name = name;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.debug("close", new Object[0]);
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        this.debug("getFilePointer", new Object[0]);
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        this.debug("length", new Object[0]);
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.debug("read", this.channel.position(), dst.position(), dst.remaining());
        return this.channel.read(dst);
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        this.debug("seek", pos);
        this.channel.position(pos);
        return this;
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        this.checkPowerOff();
        this.debug("truncate", newLength);
        this.channel.truncate(newLength);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.debug("force", new Object[0]);
        this.channel.force(metaData);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkPowerOff();
        this.debug("write", this.channel.position(), src.position(), src.remaining());
        return this.channel.write(src);
    }

    private void debug(String method, Object ... params) {
        this.debug.trace(this.name, method, params);
    }

    private void checkPowerOff() throws IOException {
        try {
            this.debug.checkPowerOff();
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        this.debug("tryLock", new Object[0]);
        return this.channel.tryLock(position, size, shared);
    }

    public String toString() {
        return this.name;
    }
}

