/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.List;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.test.utils.FileDebug;

public class FilePathDebug
extends FilePathWrapper {
    private static final FilePathDebug INSTANCE = new FilePathDebug();
    private static final IOException POWER_OFF = new IOException("Simulated power failure");
    private int powerOffCount;
    private boolean trace;

    public static FilePathDebug register() {
        FilePath.register(INSTANCE);
        return INSTANCE;
    }

    void checkPowerOff() throws IOException {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        this.powerOffCount = -1;
        throw POWER_OFF;
    }

    @Override
    public void createDirectory() {
        this.trace(this.name, "createDirectory", new Object[0]);
        super.createDirectory();
    }

    @Override
    public boolean createFile() {
        this.trace(this.name, "createFile", new Object[0]);
        return super.createFile();
    }

    @Override
    public void delete() {
        this.trace(this.name, "fileName", new Object[0]);
        super.delete();
    }

    @Override
    public boolean exists() {
        this.trace(this.name, "exists", new Object[0]);
        return super.exists();
    }

    @Override
    public String getName() {
        this.trace(this.name, "getName", new Object[0]);
        return super.getName();
    }

    @Override
    public long lastModified() {
        this.trace(this.name, "lastModified", new Object[0]);
        return super.lastModified();
    }

    @Override
    public FilePath getParent() {
        this.trace(this.name, "getParent", new Object[0]);
        return super.getParent();
    }

    @Override
    public boolean isAbsolute() {
        this.trace(this.name, "isAbsolute", new Object[0]);
        return super.isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        this.trace(this.name, "isDirectory", new Object[0]);
        return super.isDirectory();
    }

    @Override
    public boolean isRegularFile() {
        this.trace(this.name, "isRegularFile", new Object[0]);
        return super.isRegularFile();
    }

    @Override
    public boolean canWrite() {
        this.trace(this.name, "canWrite", new Object[0]);
        return super.canWrite();
    }

    @Override
    public boolean setReadOnly() {
        this.trace(this.name, "setReadOnly", new Object[0]);
        return super.setReadOnly();
    }

    @Override
    public long size() {
        this.trace(this.name, "size", new Object[0]);
        return super.size();
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        this.trace(this.name, "newDirectoryStream", new Object[0]);
        return super.newDirectoryStream();
    }

    @Override
    public FilePath toRealPath() {
        this.trace(this.name, "toRealPath", new Object[0]);
        return super.toRealPath();
    }

    @Override
    public InputStream newInputStream() throws IOException {
        this.trace(this.name, "newInputStream", new Object[0]);
        InputStream in = super.newInputStream();
        if (!this.isTrace()) {
            return in;
        }
        final String fileName = this.name;
        return new FilterInputStream(in){

            @Override
            public int read(byte[] b) throws IOException {
                FilePathDebug.this.trace(fileName, "in.read(b)", new Object[0]);
                return super.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                FilePathDebug.this.trace(fileName, "in.read(b)", "in.read(b, " + off + ", " + len + ")");
                return super.read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                FilePathDebug.this.trace(fileName, "in.read(b)", "in.skip(" + n + ")");
                return super.skip(n);
            }
        };
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        this.trace(this.name, "open", mode);
        return new FileDebug(this, super.open(mode), this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        this.trace(this.name, "newOutputStream", append);
        return super.newOutputStream(append);
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        this.trace(this.name, "moveTo", this.unwrap(((FilePathDebug)newName).name));
        super.moveTo(newName, atomicReplace);
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        this.trace(this.name, "createTempFile", suffix, inTempDir);
        return super.createTempFile(suffix, inTempDir);
    }

    void trace(String fileName, String method, Object ... params) {
        if (this.isTrace()) {
            StringBuilder buff = new StringBuilder("    ");
            buff.append(this.unwrap(fileName)).append(' ').append(method);
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                buff.append(' ').append(s);
                ++n2;
            }
            System.out.println(buff);
        }
    }

    public void setPowerOffCount(int count) {
        this.powerOffCount = count;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    public boolean isTrace() {
        return FilePathDebug.INSTANCE.trace;
    }

    public void setTrace(boolean trace) {
        FilePathDebug.INSTANCE.trace = trace;
    }

    @Override
    public String getScheme() {
        return "debug";
    }
}

