/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.test.utils.FileReorderWrites;
import org.h2.util.IOUtils;

public class FilePathReorderWrites
extends FilePathWrapper {
    static final boolean TRACE = false;
    private static final FilePathReorderWrites INSTANCE = new FilePathReorderWrites();
    private static final IOException POWER_FAILURE = new IOException("Power Failure");
    private static int powerFailureCountdown;
    private static boolean partialWrites;
    private static Random random;

    static {
        random = new Random(1L);
    }

    public static FilePathReorderWrites register() {
        FilePath.register(INSTANCE);
        return INSTANCE;
    }

    public void setPowerOffCountdown(int count, int seed) {
        powerFailureCountdown = count;
        random.setSeed(seed);
    }

    public int getPowerOffCountdown() {
        return powerFailureCountdown;
    }

    public static void setPartialWrites(boolean b) {
        partialWrites = b;
    }

    static boolean isPartialWrites() {
        return partialWrites;
    }

    ByteBuffer getRandomSubset(ByteBuffer src) {
        int len = src.remaining();
        len = Math.min(4096, Math.min(len, 1 + random.nextInt(len)));
        ByteBuffer temp = ByteBuffer.allocate(len);
        src.get(temp.array());
        return temp;
    }

    Random getRandom() {
        return random;
    }

    void checkError() throws IOException {
        if (powerFailureCountdown == 0) {
            return;
        }
        if (powerFailureCountdown < 0) {
            throw POWER_FAILURE;
        }
        if (--powerFailureCountdown == 0) {
            --powerFailureCountdown;
            throw POWER_FAILURE;
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        InputStream in = this.newInputStream();
        FilePath copy = FilePath.get(this.getBase().toString() + ".copy");
        OutputStream out = copy.newOutputStream(false);
        IOUtils.copy(in, out);
        in.close();
        out.close();
        FileChannel base = this.getBase().open(mode);
        FileChannel readBase = copy.open(mode);
        return new FileReorderWrites(this, base, readBase);
    }

    @Override
    public String getScheme() {
        return "reorder";
    }

    public long getMaxAge() {
        return 45000L;
    }

    @Override
    public void delete() {
        super.delete();
        FilePath.get(this.getBase().toString() + ".copy").delete();
    }
}

