/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.test.utils.FileUnstable;

public class FilePathUnstable
extends FilePathWrapper {
    private static final FilePathUnstable INSTANCE = new FilePathUnstable();
    private static final IOException DISK_FULL = new IOException("Disk full");
    private static int diskFullOffCount;
    private static boolean partialWrites;
    private static Random random;

    static {
        random = new Random(1L);
    }

    public static FilePathUnstable register() {
        FilePath.register(INSTANCE);
        return INSTANCE;
    }

    public void setDiskFullCount(int count, int seed) {
        diskFullOffCount = count;
        random.setSeed(seed);
    }

    public int getDiskFullCount() {
        return diskFullOffCount;
    }

    public void setPartialWrites(boolean partialWrites) {
        FilePathUnstable.partialWrites = partialWrites;
    }

    boolean getPartialWrites() {
        return partialWrites;
    }

    ByteBuffer getRandomSubset(ByteBuffer src) {
        int len = src.remaining();
        len = Math.min(4096, Math.min(len, 1 + random.nextInt(len)));
        ByteBuffer temp = ByteBuffer.allocate(len);
        src.get(temp.array());
        return temp;
    }

    void checkError() throws IOException {
        if (diskFullOffCount == 0) {
            return;
        }
        if (--diskFullOffCount > 0) {
            return;
        }
        if (diskFullOffCount >= -1) {
            --diskFullOffCount;
            throw DISK_FULL;
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        return new FileUnstable(this, super.open(mode));
    }

    @Override
    public String getScheme() {
        return "unstable";
    }
}

