/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.test.utils.FilePathUnstable;

class FileUnstable
extends FileBase {
    private final FilePathUnstable file;
    private final FileChannel channel;
    private boolean closed;

    FileUnstable(FilePathUnstable file, FileChannel channel) {
        this.file = file;
        this.channel = channel;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
        this.closed = true;
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int read(ByteBuffer dst, long pos) throws IOException {
        return this.channel.read(dst, pos);
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        this.channel.position(pos);
        return this;
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        this.checkError();
        this.channel.truncate(newLength);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.checkError();
        this.channel.force(metaData);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkError();
        if (this.file.getPartialWrites()) {
            return this.channel.write(this.file.getRandomSubset(src));
        }
        return this.channel.write(src);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        this.checkError();
        if (this.file.getPartialWrites()) {
            return this.channel.write(this.file.getRandomSubset(src), position);
        }
        return this.channel.write(src, position);
    }

    private void checkError() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        this.file.checkError();
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(position, size, shared);
    }

    public String toString() {
        return "unstable:" + this.file.toString();
    }
}

