/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.lang.instrument.Instrumentation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.util.Profiler;
import org.h2.value.Value;

public class MemoryFootprint {
    public static void main(String ... a) {
        MemoryFootprint.print("Object", new Object());
        MemoryFootprint.print("Timestamp", new Timestamp(0L));
        MemoryFootprint.print("Date", new Date(0L));
        MemoryFootprint.print("Time", new Time(0L));
        MemoryFootprint.print("BigDecimal", new BigDecimal("0"));
        MemoryFootprint.print("BigInteger", new BigInteger("0"));
        MemoryFootprint.print("String", new String("Hello"));
        MemoryFootprint.print("Data", Data.create(10));
        MemoryFootprint.print("Row", Row.get(new Value[0], 0));
        System.out.println();
        int i = 1;
        while (i < 128) {
            System.out.println(MemoryFootprint.getArraySize(1, i) + " bytes per p1[]");
            MemoryFootprint.print("boolean[" + i + "]", new boolean[i]);
            System.out.println(MemoryFootprint.getArraySize(2, i) + " bytes per p2[]");
            MemoryFootprint.print("char[" + i + "]", new char[i]);
            MemoryFootprint.print("short[" + i + "]", new short[i]);
            System.out.println(MemoryFootprint.getArraySize(4, i) + " bytes per p4[]");
            MemoryFootprint.print("int[" + i + "]", new int[i]);
            MemoryFootprint.print("float[" + i + "]", new float[i]);
            System.out.println(MemoryFootprint.getArraySize(8, i) + " bytes per p8[]");
            MemoryFootprint.print("long[" + i + "]", new long[i]);
            MemoryFootprint.print("double[" + i + "]", new double[i]);
            System.out.println(MemoryFootprint.getArraySize(8, i) + " bytes per obj[]");
            MemoryFootprint.print("Object[" + i + "]", new Object[i]);
            System.out.println();
            i += i;
        }
    }

    private static int getArraySize(int type, int length) {
        return (24 + length * type + 7) / 8 * 8;
    }

    private static void print(String type, Object o) {
        System.out.println(MemoryFootprint.getObjectSize(o) + " bytes per " + type);
    }

    public static long getObjectSize(Object o) {
        Instrumentation inst = Profiler.getInstrumentation();
        return inst == null ? 0L : inst.getObjectSize(o);
    }
}

