/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class OutputCatcher {
    public static final String START_ERROR = "<span style=\"color:red;\">";
    private final ByteArrayOutputStream buff = new ByteArrayOutputStream();
    private final DualOutputStream out;
    private final DualOutputStream err;
    private String output;

    private OutputCatcher() {
        HtmlOutputStream html = new HtmlOutputStream(this.buff);
        this.out = new DualOutputStream(html, System.out, false);
        this.err = new DualOutputStream(html, System.err, true);
        System.setOut(new PrintStream(this.out, true));
        System.setErr(new PrintStream(this.err, true));
    }

    public void stop() {
        System.out.flush();
        System.setOut(this.out.print);
        System.err.flush();
        System.setErr(this.err.print);
        this.output = this.buff.toString();
    }

    public void writeTo(String title, String fileName) throws IOException {
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(new FileOutputStream(file));
        writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        writer.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
        writer.write("<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" /><title>\n");
        writer.print(title);
        writer.print("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\" />\n");
        writer.print("</head><body style=\"margin: 20px;\">\n");
        writer.print("<h1>" + title + "</h1><br />\n");
        writer.print(this.output);
        writer.write("\n</body></html>");
        writer.close();
    }

    public static OutputCatcher start() {
        return new OutputCatcher();
    }

    static class DualOutputStream
    extends FilterOutputStream {
        final PrintStream print;
        private final HtmlOutputStream htmlOut;
        private final boolean error;

        DualOutputStream(HtmlOutputStream out, PrintStream print, boolean error) {
            super(out);
            this.htmlOut = out;
            this.print = print;
            this.error = error;
        }

        @Override
        public void close() throws IOException {
            this.print.close();
            super.close();
        }

        @Override
        public void flush() throws IOException {
            this.print.flush();
            super.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.print.write(b);
            this.htmlOut.write(this.error, b);
        }
    }

    static class HtmlOutputStream
    extends FilterOutputStream {
        private static final byte[] START = "<span style=\"color:red;\">".getBytes();
        private static final byte[] END = "</span>".getBytes();
        private static final byte[] BR = "<br />\n".getBytes();
        private static final byte[] NBSP = "&nbsp;".getBytes();
        private static final byte[] LT = "&lt;".getBytes();
        private static final byte[] GT = "&gt;".getBytes();
        private static final byte[] AMP = "&amp;".getBytes();
        private boolean error;
        private boolean hasError;
        private boolean convertSpace;

        HtmlOutputStream(OutputStream out) {
            super(out);
        }

        boolean hasError() {
            return this.hasError;
        }

        void setError(boolean error) throws IOException {
            if (error != this.error) {
                if (error) {
                    this.hasError = true;
                    super.write(START);
                } else {
                    super.write(END);
                }
                this.error = error;
            }
        }

        void write(boolean errorStream, int b) throws IOException {
            this.setError(errorStream);
            switch (b) {
                case 10: {
                    super.write(BR);
                    this.convertSpace = true;
                    break;
                }
                case 9: {
                    super.write(NBSP);
                    super.write(NBSP);
                    break;
                }
                case 32: {
                    if (this.convertSpace) {
                        super.write(NBSP);
                        break;
                    }
                    super.write(b);
                    break;
                }
                case 60: {
                    super.write(LT);
                    break;
                }
                case 62: {
                    super.write(GT);
                    break;
                }
                case 38: {
                    super.write(AMP);
                    break;
                }
                default: {
                    if (b >= 128) {
                        super.write(("&#" + b + ";").getBytes());
                    } else {
                        super.write(b);
                    }
                    this.convertSpace = false;
                }
            }
        }
    }
}

