/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.message.DbException;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Backup
extends Tool {
    public static void main(String ... args) throws SQLException {
        new Backup().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
            } else if (arg.equals("-db")) {
                db = args[++i];
            } else if (arg.equals("-quiet")) {
                quiet = true;
            } else if (arg.equals("-file")) {
                zipFileName = args[++i];
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        try {
            this.process(zipFileName, dir, db, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        try {
            new Backup().process(zipFileName, directory, db, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    private void process(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        boolean allFiles = db != null && db.isEmpty();
        List<String> list = allFiles ? FileUtils.newDirectoryStream(directory) : FileLister.getDatabaseFiles(directory, db, true);
        if (list.isEmpty()) {
            if (!quiet) {
                this.printNoDatabaseFilesFound(directory, db);
            }
            return;
        }
        if (!quiet) {
            FileLister.tryUnlockDatabase(list, "backup");
        }
        zipFileName = FileUtils.toRealPath(zipFileName);
        FileUtils.delete(zipFileName);
        OutputStream fileOut = null;
        try {
            try {
                fileOut = FileUtils.newOutputStream(zipFileName, false);
                Throwable throwable = null;
                Object var9_11 = null;
                try (ZipOutputStream zipOut = new ZipOutputStream(fileOut);){
                    String base = "";
                    for (String fileName : list) {
                        if (!allFiles && !fileName.endsWith(".mv.db")) continue;
                        base = FileUtils.getParent(fileName);
                        break;
                    }
                    for (String fileName : list) {
                        block24: {
                            String f = FileUtils.toRealPath(fileName);
                            if (!f.startsWith(base)) {
                                throw DbException.getInternalError(f + " does not start with " + base);
                            }
                            if (f.endsWith(zipFileName) || FileUtils.isDirectory(fileName)) continue;
                            f = f.substring(base.length());
                            f = BackupCommand.correctFileName(f);
                            ZipEntry entry = new ZipEntry(f);
                            zipOut.putNextEntry(entry);
                            InputStream in = null;
                            try {
                                try {
                                    in = FileUtils.newInputStream(fileName);
                                    IOUtils.copyAndCloseInput(in, zipOut);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    IOUtils.closeSilently(in);
                                    break block24;
                                }
                            }
                            catch (Throwable throwable2) {
                                IOUtils.closeSilently(in);
                                throw throwable2;
                            }
                            IOUtils.closeSilently(in);
                        }
                        zipOut.closeEntry();
                        if (quiet) continue;
                        this.out.println("Processed: " + fileName);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, zipFileName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(fileOut);
            throw throwable;
        }
        IOUtils.closeSilently(fileOut);
    }
}

