/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Locale;
import org.h2.jdbc.JdbcConnection;
import org.h2.tools.Console;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GUIConsole
extends Console
implements ActionListener,
MouseListener,
WindowListener {
    private long lastOpenNs;
    private boolean trayIconUsed;
    private Font font;
    private Frame statusFrame;
    private TextField urlText;
    private Button startBrowser;
    private Frame createFrame;
    private TextField pathField;
    private TextField userField;
    private TextField passwordField;
    private TextField passwordConfirmationField;
    private Button createButton;
    private TextArea errorArea;
    private Object tray;
    private Object trayIcon;

    @Override
    protected String getMainClassName() {
        return Console.class.getName();
    }

    @Override
    void show() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.loadFont();
            try {
                if (!this.createTrayIcon()) {
                    this.showStatusWindow();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Image loadImage(String name) {
        byte[] imageData;
        block3: {
            try {
                imageData = Utils.getResource(name);
                if (imageData != null) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(imageData);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.statusFrame != null) {
            this.statusFrame.dispose();
            this.statusFrame = null;
        }
        if (this.trayIconUsed) {
            block9: {
                try {
                    try {
                        Utils.callMethod(this.tray, "remove", this.trayIcon);
                    }
                    catch (Exception exception) {
                        this.trayIcon = null;
                        this.tray = null;
                        this.trayIconUsed = false;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.trayIcon = null;
                    this.tray = null;
                    this.trayIconUsed = false;
                    throw throwable;
                }
                this.trayIcon = null;
                this.tray = null;
                this.trayIconUsed = false;
            }
            System.gc();
            String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if (os.contains("mac")) {
                for (Thread t : Thread.getAllStackTraces().keySet()) {
                    if (!t.getName().startsWith("AWT-")) continue;
                    t.interrupt();
                }
            }
            Thread.currentThread().interrupt();
        }
    }

    private void loadFont() {
        this.font = this.isWindows ? new Font("Dialog", 0, 11) : new Font("Dialog", 0, 12);
    }

    private boolean createTrayIcon() {
        block3: {
            try {
                boolean supported = (Boolean)Utils.callStaticMethod("java.awt.SystemTray.isSupported", new Object[0]);
                if (supported) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        PopupMenu menuConsole = new PopupMenu();
        MenuItem itemConsole = new MenuItem("H2 Console");
        itemConsole.setActionCommand("console");
        itemConsole.addActionListener(this);
        itemConsole.setFont(this.font);
        menuConsole.add(itemConsole);
        MenuItem itemCreate = new MenuItem("Create a new database...");
        itemCreate.setActionCommand("showCreate");
        itemCreate.addActionListener(this);
        itemCreate.setFont(this.font);
        menuConsole.add(itemCreate);
        MenuItem itemStatus = new MenuItem("Status");
        itemStatus.setActionCommand("status");
        itemStatus.addActionListener(this);
        itemStatus.setFont(this.font);
        menuConsole.add(itemStatus);
        MenuItem itemExit = new MenuItem("Exit");
        itemExit.setFont(this.font);
        itemExit.setActionCommand("exit");
        itemExit.addActionListener(this);
        menuConsole.add(itemExit);
        this.tray = Utils.callStaticMethod("java.awt.SystemTray.getSystemTray", new Object[0]);
        Dimension d = (Dimension)Utils.callMethod(this.tray, "getTrayIconSize", new Object[0]);
        String iconFile = d.width >= 24 && d.height >= 24 ? "/org/h2/res/h2-24.png" : (d.width >= 22 && d.height >= 22 ? "/org/h2/res/h2-64-t.png" : "/org/h2/res/h2.png");
        Image icon = GUIConsole.loadImage(iconFile);
        this.trayIcon = Utils.newInstance("java.awt.TrayIcon", icon, "H2 Database Engine", menuConsole);
        Utils.callMethod(this.trayIcon, "addMouseListener", this);
        Utils.callMethod(this.tray, "add", this.trayIcon);
        this.trayIconUsed = true;
        return true;
    }

    private void showStatusWindow() {
        if (this.statusFrame != null) {
            return;
        }
        this.statusFrame = new Frame("H2 Console");
        this.statusFrame.addWindowListener(this);
        Image image = GUIConsole.loadImage("/org/h2/res/h2.png");
        if (image != null) {
            this.statusFrame.setIconImage(image);
        }
        this.statusFrame.setResizable(false);
        this.statusFrame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        this.statusFrame.setLayout(layout);
        Panel mainPanel = new Panel(layout);
        GridBagConstraints constraintsPanel = new GridBagConstraints();
        constraintsPanel.gridx = 0;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.weighty = 1.0;
        constraintsPanel.fill = 1;
        constraintsPanel.insets = new Insets(0, 10, 0, 10);
        constraintsPanel.gridy = 0;
        GridBagConstraints constraintsButton = new GridBagConstraints();
        constraintsButton.gridx = 0;
        constraintsButton.gridwidth = 2;
        constraintsButton.insets = new Insets(10, 0, 0, 0);
        constraintsButton.gridy = 1;
        constraintsButton.anchor = 13;
        GridBagConstraints constraintsTextField = new GridBagConstraints();
        constraintsTextField.fill = 2;
        constraintsTextField.gridy = 0;
        constraintsTextField.weightx = 1.0;
        constraintsTextField.insets = new Insets(0, 5, 0, 0);
        constraintsTextField.gridx = 1;
        GridBagConstraints constraintsLabel = new GridBagConstraints();
        constraintsLabel.gridx = 0;
        constraintsLabel.gridy = 0;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        mainPanel.add((Component)label, constraintsLabel);
        this.urlText = new TextField();
        this.urlText.setEditable(false);
        this.urlText.setFont(this.font);
        this.urlText.setText(this.web.getURL());
        if (this.isWindows) {
            this.urlText.setFocusable(false);
        }
        mainPanel.add((Component)this.urlText, constraintsTextField);
        this.startBrowser = new Button("Start Browser");
        this.startBrowser.setFocusable(false);
        this.startBrowser.setActionCommand("console");
        this.startBrowser.addActionListener(this);
        this.startBrowser.setFont(this.font);
        mainPanel.add((Component)this.startBrowser, constraintsButton);
        this.statusFrame.add((Component)mainPanel, constraintsPanel);
        int width = 300;
        int height = 120;
        this.statusFrame.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.statusFrame.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        try {
            this.statusFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.statusFrame.setAlwaysOnTop(true);
            this.statusFrame.setAlwaysOnTop(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            String url = this.web.getURL();
            if (this.urlText != null) {
                this.urlText.setText(url);
            }
            long now = Utils.currentNanoTime();
            if (this.lastOpenNs == 0L || now - this.lastOpenNs > 100000000L) {
                this.lastOpenNs = now;
                this.openBrowser(url);
            }
        }
    }

    private void showCreateDatabase() {
        if (this.createFrame != null) {
            return;
        }
        this.createFrame = new Frame("H2 Console");
        this.createFrame.addWindowListener(this);
        Image image = GUIConsole.loadImage("/org/h2/res/h2.png");
        if (image != null) {
            this.createFrame.setIconImage(image);
        }
        this.createFrame.setResizable(false);
        this.createFrame.setBackground(SystemColor.control);
        GridBagLayout layout = new GridBagLayout();
        this.createFrame.setLayout(layout);
        Panel mainPanel = new Panel(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        Label urlLabel = new Label("Database path:", 0);
        urlLabel.setFont(this.font);
        mainPanel.add((Component)urlLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 5, 0, 0);
        constraints.gridx = 1;
        this.pathField = new TextField();
        this.pathField.setFont(this.font);
        this.pathField.setText("./test");
        mainPanel.add((Component)this.pathField, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        Label userLabel = new Label("Username:", 0);
        userLabel.setFont(this.font);
        mainPanel.add((Component)userLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.gridx = 1;
        this.userField = new TextField();
        this.userField.setFont(this.font);
        this.userField.setText("sa");
        mainPanel.add((Component)this.userField, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        Label passwordLabel = new Label("Password:", 0);
        passwordLabel.setFont(this.font);
        mainPanel.add((Component)passwordLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.gridx = 1;
        this.passwordField = new TextField();
        this.passwordField.setFont(this.font);
        this.passwordField.setEchoChar('*');
        mainPanel.add((Component)this.passwordField, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 3;
        Label passwordConfirmationLabel = new Label("Password confirmation:", 0);
        passwordConfirmationLabel.setFont(this.font);
        mainPanel.add((Component)passwordConfirmationLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.gridx = 1;
        this.passwordConfirmationField = new TextField();
        this.passwordConfirmationField.setFont(this.font);
        this.passwordConfirmationField.setEchoChar('*');
        mainPanel.add((Component)this.passwordConfirmationField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.gridy = 4;
        constraints.anchor = 13;
        this.createButton = new Button("Create");
        this.createButton.setFocusable(false);
        this.createButton.setActionCommand("create");
        this.createButton.addActionListener(this);
        this.createButton.setFont(this.font);
        mainPanel.add((Component)this.createButton, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        this.errorArea = new TextArea();
        this.errorArea.setFont(this.font);
        this.errorArea.setEditable(false);
        mainPanel.add((Component)this.errorArea, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 0, 10);
        constraints.gridy = 0;
        this.createFrame.add((Component)mainPanel, constraints);
        int width = 400;
        int height = 400;
        this.createFrame.setSize(width, height);
        this.createFrame.pack();
        this.createFrame.setLocationRelativeTo(null);
        try {
            this.createFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.createFrame.setAlwaysOnTop(true);
            this.createFrame.setAlwaysOnTop(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createDatabase() {
        String passwordConfirmation;
        if (this.web == null || this.createFrame == null) {
            return;
        }
        String path = this.pathField.getText();
        String user = this.userField.getText();
        String password = this.passwordField.getText();
        if (!password.equals(passwordConfirmation = this.passwordConfirmationField.getText())) {
            this.errorArea.setForeground(Color.RED);
            this.errorArea.setText("Passwords don't match");
            return;
        }
        if (password.isEmpty()) {
            this.errorArea.setForeground(Color.RED);
            this.errorArea.setText("Specify a password");
            return;
        }
        String url = "jdbc:h2:" + path;
        try {
            new JdbcConnection(url, null, user, password, false).close();
            this.errorArea.setForeground(new Color(0, 153, 0));
            this.errorArea.setText("Database was created successfully.\n\nJDBC URL for H2 Console:\n" + url);
        }
        catch (Exception ex) {
            this.errorArea.setForeground(Color.RED);
            this.errorArea.setText(ex.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("exit".equals(command)) {
            this.shutdown();
        } else if ("console".equals(command)) {
            this.startBrowser();
        } else if ("showCreate".equals(command)) {
            this.showCreateDatabase();
        } else if ("status".equals(command)) {
            this.showStatusWindow();
        } else if (this.startBrowser == e.getSource()) {
            this.startBrowser();
        } else if (this.createButton == e.getSource()) {
            this.createDatabase();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startBrowser();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.trayIconUsed) {
            Window window = e.getWindow();
            if (window == this.statusFrame) {
                this.statusFrame.dispose();
                this.statusFrame = null;
            } else if (window == this.createFrame) {
                this.createFrame.dispose();
                this.createFrame = null;
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

