/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Restore
extends Tool {
    public static void main(String ... args) throws SQLException {
        new Restore().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
            } else if (arg.equals("-file")) {
                zipFileName = args[++i];
            } else if (arg.equals("-db")) {
                db = args[++i];
            } else if (!arg.equals("-quiet")) {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        Restore.execute(zipFileName, dir, db);
    }

    private static String getOriginalDbName(String fileName, String db) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = FileUtils.newInputStream(fileName);){
            ZipEntry entry;
            ZipInputStream zipIn = new ZipInputStream(in);
            String originalDbName = null;
            boolean multiple = false;
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                zipIn.closeEntry();
                String name = Restore.getDatabaseNameFromFileName(entryName);
                if (name == null) continue;
                if (db.equals(name)) {
                    originalDbName = name;
                    break;
                }
                if (originalDbName == null) {
                    originalDbName = name;
                    continue;
                }
                multiple = true;
            }
            zipIn.close();
            if (multiple && !db.equals(originalDbName)) {
                throw new IOException("Multiple databases found, but not " + db);
            }
            return originalDbName;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getDatabaseNameFromFileName(String fileName) {
        if (fileName.endsWith(".mv.db")) {
            return fileName.substring(0, fileName.length() - ".mv.db".length());
        }
        return null;
    }

    public static void execute(String zipFileName, String directory, String db) {
        InputStream in = null;
        try {
            try {
                if (!FileUtils.exists(zipFileName)) {
                    throw new IOException("File not found: " + zipFileName);
                }
                String originalDbName = null;
                int originalDbLen = 0;
                if (db != null) {
                    originalDbName = Restore.getOriginalDbName(zipFileName, db);
                    if (originalDbName == null) {
                        throw new IOException("No database named " + db + " found");
                    }
                    if (originalDbName.startsWith(File.separator)) {
                        originalDbName = originalDbName.substring(1);
                    }
                    originalDbLen = originalDbName.length();
                }
                in = FileUtils.newInputStream(zipFileName);
                Throwable throwable = null;
                Object var7_9 = null;
                try (ZipInputStream zipIn = new ZipInputStream(in);){
                    ZipEntry entry;
                    while ((entry = zipIn.getNextEntry()) != null) {
                        Object fileName = entry.getName();
                        if (((String)(fileName = IOUtils.nameSeparatorsToNative((String)fileName))).startsWith(File.separator)) {
                            fileName = ((String)fileName).substring(1);
                        }
                        boolean copy = false;
                        if (db == null) {
                            copy = true;
                        } else if (((String)fileName).startsWith(originalDbName + ".")) {
                            fileName = db + ((String)fileName).substring(originalDbLen);
                            copy = true;
                        }
                        if (copy) {
                            OutputStream o = null;
                            try {
                                o = FileUtils.newOutputStream(directory + File.separatorChar + (String)fileName, false);
                                IOUtils.copy(zipIn, o);
                                o.close();
                            }
                            catch (Throwable throwable2) {
                                IOUtils.closeSilently(o);
                                throw throwable2;
                            }
                            IOUtils.closeSilently(o);
                        }
                        zipIn.closeEntry();
                    }
                    zipIn.closeEntry();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, zipFileName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(in);
            throw throwable;
        }
        IOUtils.closeSilently(in);
    }
}

