/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Script
extends Tool {
    public static void main(String ... args) throws SQLException {
        new Script().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        String file = "backup.sql";
        String options1 = "";
        String options2 = "";
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
            } else if (arg.equals("-user")) {
                user = args[++i];
            } else if (arg.equals("-password")) {
                password = args[++i];
            } else if (arg.equals("-script")) {
                file = args[++i];
            } else if (arg.equals("-options")) {
                StringBuilder buff1 = new StringBuilder();
                StringBuilder buff2 = new StringBuilder();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if ("SIMPLE".equals(upper) || upper.startsWith("NO") || "DROP".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else if ("BLOCKSIZE".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                        buff1.append(' ');
                        buff1.append(args[++i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        if (url == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        Script.process(url, user, password, file, options1, options2);
    }

    public static void process(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (Connection conn = JdbcUtils.getConnection(null, url, user, password);){
            Script.process(conn, fileName, options1, options2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void process(Connection conn, String fileName, String options1, String options2) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Statement stat = conn.createStatement();){
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            stat.execute(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

