/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Server
extends Tool
implements Runnable,
ShutdownHandler {
    private final Service service;
    private Server web;
    private Server tcp;
    private Server pg;
    private ShutdownHandler shutdownHandler;
    private boolean fromCommandLine;
    private boolean started;

    public Server() {
        this.service = null;
    }

    public Server(Service service, String ... args) throws SQLException {
        this.verifyArgs(args);
        this.service = service;
        try {
            service.init(args);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    public static void main(String ... args) throws SQLException {
        Server server = new Server();
        server.fromCommandLine = true;
        server.runTool(args);
    }

    private void verifyArgs(String ... args) throws SQLException {
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg != null && !"-?".equals(arg) && !"-help".equals(arg)) {
                if (arg.startsWith("-web")) {
                    if (!"-web".equals(arg) && !"-webAllowOthers".equals(arg)) {
                        if ("-webExternalNames".equals(arg)) {
                            ++i;
                        } else if (!"-webDaemon".equals(arg)) {
                            if ("-webVirtualThreads".equals(arg)) {
                                ++i;
                            } else if (!"-webSSL".equals(arg)) {
                                if ("-webPort".equals(arg)) {
                                    ++i;
                                } else if ("-webAdminPassword".equals(arg)) {
                                    if (this.fromCommandLine) {
                                        this.throwUnsupportedOption(arg);
                                    }
                                    ++i;
                                } else {
                                    this.throwUnsupportedOption(arg);
                                }
                            }
                        }
                    }
                } else if (!"-browser".equals(arg)) {
                    if (arg.startsWith("-tcp")) {
                        if (!("-tcp".equals(arg) || "-tcpAllowOthers".equals(arg) || "-tcpDaemon".equals(arg))) {
                            if ("-tcpVirtualThreads".equals(arg)) {
                                ++i;
                            } else if (!"-tcpSSL".equals(arg)) {
                                if ("-tcpPort".equals(arg)) {
                                    ++i;
                                } else if ("-tcpPassword".equals(arg)) {
                                    ++i;
                                } else if ("-tcpShutdown".equals(arg)) {
                                    ++i;
                                } else if (!"-tcpShutdownForce".equals(arg)) {
                                    this.throwUnsupportedOption(arg);
                                }
                            }
                        }
                    } else if (arg.startsWith("-pg")) {
                        if (!("-pg".equals(arg) || "-pgAllowOthers".equals(arg) || "-pgDaemon".equals(arg))) {
                            if ("-pgVirtualThreads".equals(arg)) {
                                ++i;
                            } else if ("-pgPort".equals(arg)) {
                                ++i;
                            } else {
                                this.throwUnsupportedOption(arg);
                            }
                        }
                    } else if (arg.startsWith("-ftp")) {
                        if ("-ftpPort".equals(arg)) {
                            ++i;
                        } else if ("-ftpDir".equals(arg)) {
                            ++i;
                        } else if ("-ftpRead".equals(arg)) {
                            ++i;
                        } else if ("-ftpWrite".equals(arg)) {
                            ++i;
                        } else if ("-ftpWritePassword".equals(arg)) {
                            ++i;
                        } else if (!"-ftpTask".equals(arg)) {
                            this.throwUnsupportedOption(arg);
                        }
                    } else if ("-properties".equals(arg)) {
                        ++i;
                    } else if (!("-trace".equals(arg) || "-ifExists".equals(arg) || "-ifNotExists".equals(arg))) {
                        if ("-baseDir".equals(arg)) {
                            ++i;
                        } else if ("-key".equals(arg)) {
                            i += 2;
                        } else if (!"-tool".equals(arg)) {
                            this.throwUnsupportedOption(arg);
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        block59: {
            boolean tcpStart = false;
            boolean pgStart = false;
            boolean webStart = false;
            boolean browserStart = false;
            boolean tcpShutdown = false;
            boolean tcpShutdownForce = false;
            String tcpPassword = "";
            String tcpShutdownServer = "";
            boolean startDefaultServers = true;
            int i = 0;
            while (args != null && i < args.length) {
                String arg = args[i];
                if (arg != null) {
                    if ("-?".equals(arg) || "-help".equals(arg)) {
                        this.showUsage();
                        return;
                    }
                    if (arg.startsWith("-web")) {
                        if ("-web".equals(arg)) {
                            startDefaultServers = false;
                            webStart = true;
                        } else if (!"-webAllowOthers".equals(arg)) {
                            if ("-webExternalNames".equals(arg)) {
                                ++i;
                            } else if (!"-webDaemon".equals(arg) && !"-webSSL".equals(arg)) {
                                if ("-webPort".equals(arg)) {
                                    ++i;
                                } else if ("-webAdminPassword".equals(arg)) {
                                    if (this.fromCommandLine) {
                                        this.throwUnsupportedOption(arg);
                                    }
                                    ++i;
                                } else {
                                    this.showUsageAndThrowUnsupportedOption(arg);
                                }
                            }
                        }
                    } else if ("-browser".equals(arg)) {
                        startDefaultServers = false;
                        browserStart = true;
                    } else if (arg.startsWith("-tcp")) {
                        if ("-tcp".equals(arg)) {
                            startDefaultServers = false;
                            tcpStart = true;
                        } else if (!("-tcpAllowOthers".equals(arg) || "-tcpDaemon".equals(arg) || "-tcpSSL".equals(arg))) {
                            if ("-tcpPort".equals(arg)) {
                                ++i;
                            } else if ("-tcpPassword".equals(arg)) {
                                tcpPassword = args[++i];
                            } else if ("-tcpShutdown".equals(arg)) {
                                startDefaultServers = false;
                                tcpShutdown = true;
                                tcpShutdownServer = args[++i];
                            } else if ("-tcpShutdownForce".equals(arg)) {
                                tcpShutdownForce = true;
                            } else {
                                this.showUsageAndThrowUnsupportedOption(arg);
                            }
                        }
                    } else if (arg.startsWith("-pg")) {
                        if ("-pg".equals(arg)) {
                            startDefaultServers = false;
                            pgStart = true;
                        } else if (!"-pgAllowOthers".equals(arg) && !"-pgDaemon".equals(arg)) {
                            if ("-pgPort".equals(arg)) {
                                ++i;
                            } else {
                                this.showUsageAndThrowUnsupportedOption(arg);
                            }
                        }
                    } else if ("-properties".equals(arg)) {
                        ++i;
                    } else if (!("-trace".equals(arg) || "-ifExists".equals(arg) || "-ifNotExists".equals(arg))) {
                        if ("-baseDir".equals(arg)) {
                            ++i;
                        } else if ("-key".equals(arg)) {
                            i += 2;
                        } else {
                            this.showUsageAndThrowUnsupportedOption(arg);
                        }
                    }
                }
                ++i;
            }
            this.verifyArgs(args);
            if (startDefaultServers) {
                tcpStart = true;
                pgStart = true;
                webStart = true;
                browserStart = true;
            }
            if (tcpShutdown) {
                this.out.println("Shutting down TCP Server at " + tcpShutdownServer);
                Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce, false);
            }
            try {
                if (tcpStart) {
                    this.tcp = Server.createTcpServer(args);
                    this.tcp.start();
                    this.out.println(this.tcp.getStatus());
                    this.tcp.setShutdownHandler(this);
                }
                if (pgStart) {
                    this.pg = Server.createPgServer(args);
                    this.pg.start();
                    this.out.println(this.pg.getStatus());
                }
                if (webStart) {
                    this.web = Server.createWebServer(args);
                    this.web.setShutdownHandler(this);
                    SQLException result = null;
                    try {
                        this.web.start();
                    }
                    catch (Exception e) {
                        result = DbException.toSQLException(e);
                    }
                    this.out.println(this.web.getStatus());
                    if (browserStart) {
                        try {
                            Server.openBrowser(this.web.getURL());
                        }
                        catch (Exception e) {
                            this.out.println(e.getMessage());
                        }
                    }
                    if (result != null) {
                        throw result;
                    }
                    break block59;
                }
                if (browserStart) {
                    this.out.println("The browser can only start if a web server is started (-web)");
                }
            }
            catch (SQLException e) {
                this.stopAll();
                throw e;
            }
        }
    }

    public static void shutdownTcpServer(String url, String password, boolean force, boolean all) throws SQLException {
        TcpServer.shutdown(url, password, force, all);
    }

    public String getStatus() {
        StringBuilder buff = new StringBuilder();
        if (!this.started) {
            buff.append("Not started");
        } else if (this.isRunning(false)) {
            buff.append(this.service.getType()).append(" server running at ").append(this.service.getURL()).append(" (");
            if (this.service.getAllowOthers()) {
                buff.append("others can connect");
            } else {
                buff.append("only local connections");
            }
            buff.append(')');
        } else {
            buff.append("The ").append(this.service.getType()).append(" server could not be started. Possible cause: another server is already running at ").append(this.service.getURL());
        }
        return buff.toString();
    }

    public static Server createWebServer(String ... args) throws SQLException {
        return Server.createWebServer(args, null, false);
    }

    static Server createWebServer(String[] args, String key, boolean allowSecureCreation) throws SQLException {
        WebServer service = new WebServer();
        service.setKey(key);
        service.setAllowSecureCreation(allowSecureCreation);
        Server server = new Server(service, args);
        service.setShutdownHandler(server);
        return server;
    }

    public static Server createTcpServer(String ... args) throws SQLException {
        TcpServer service = new TcpServer();
        Server server = new Server(service, args);
        service.setShutdownHandler(server);
        return server;
    }

    public static Server createPgServer(String ... args) throws SQLException {
        return new Server(new PgServer(), args);
    }

    public Server start() throws SQLException {
        try {
            this.started = true;
            this.service.start();
            String url = this.service.getURL();
            int idx = url.indexOf(63);
            if (idx >= 0) {
                url = url.substring(0, idx);
            }
            String name = this.service.getName() + " (" + url + ")";
            Thread t = new Thread((Runnable)this, name);
            t.setDaemon(this.service.isDaemon());
            t.start();
            int i = 1;
            while (i < 64) {
                Server.wait(i);
                if (this.isRunning(false)) {
                    return this;
                }
                i += i;
            }
            if (this.isRunning(true)) {
                return this;
            }
            throw DbException.get(90061, name, "timeout; please check your network configuration, specially the file /etc/hosts");
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    private static void wait(int i) {
        try {
            long sleep = (long)i * (long)i;
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        Server s = this.web;
        if (s != null && s.isRunning(false)) {
            s.stop();
            this.web = null;
        }
        if ((s = this.tcp) != null && s.isRunning(false)) {
            s.stop();
            this.tcp = null;
        }
        if ((s = this.pg) != null && s.isRunning(false)) {
            s.stop();
            this.pg = null;
        }
    }

    public boolean isRunning(boolean traceError) {
        return this.service.isRunning(traceError);
    }

    public void stop() {
        this.started = false;
        if (this.service != null) {
            this.service.stop();
        }
    }

    public String getURL() {
        return this.service.getURL();
    }

    public int getPort() {
        return this.service.getPort();
    }

    @Override
    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception e) {
            DbException.traceThrowable(e);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    @Override
    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void openBrowser(String url) throws Exception {
        String osName = StringUtils.toLowerEnglish(Utils.getProperty("os.name", "linux"));
        Runtime rt = Runtime.getRuntime();
        String browser = Utils.getProperty("h2.browser", null);
        if (browser == null) {
            try {
                browser = System.getenv("BROWSER");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (browser != null) {
            if (browser.startsWith("call:")) {
                browser = browser.substring("call:".length());
                Utils.callStaticMethod(browser, url);
                return;
            }
            if (browser.contains("%url")) {
                String[] args = StringUtils.arraySplit(browser, ',', false);
                int i = 0;
                while (true) {
                    if (i >= args.length) {
                        rt.exec(args);
                        return;
                    }
                    args[i] = StringUtils.replaceAll(args[i], "%url", url);
                    ++i;
                }
            }
            if (osName.contains("windows")) {
                rt.exec(new String[]{"cmd.exe", "/C", browser, url});
                return;
            }
            rt.exec(new String[]{browser, url});
            return;
        }
        {
            catch (Exception e) {
                throw new Exception("Failed to start a browser to open the URL " + url + ": " + e.getMessage());
            }
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                Boolean supported = (Boolean)desktopClass.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
                URI uri = new URI(url);
                if (supported.booleanValue()) {
                    Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    desktopClass.getMethod("browse", URI.class).invoke(desktop, uri);
                    return;
                }
            }
            catch (Exception desktopClass) {}
            {
                if (osName.contains("windows")) {
                    rt.exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                    return;
                }
                if (osName.contains("mac") || osName.contains("darwin")) {
                    Runtime.getRuntime().exec(new String[]{"open", url});
                    return;
                }
                String[] browsers = new String[]{"xdg-open", "chromium", "google-chrome", "firefox", "mozilla-firefox", "mozilla", "konqueror", "netscape", "opera", "midori"};
                boolean ok = false;
                String[] stringArray = browsers;
                int n = browsers.length;
                int n2 = 0;
                while (n2 < n) {
                    String b = stringArray[n2];
                    try {
                        rt.exec(new String[]{b, url});
                        ok = true;
                        break;
                    }
                    catch (Exception exception) {
                        ++n2;
                    }
                }
                if (ok) return;
                throw new Exception("Browser detection failed, and java property 'h2.browser' and environment variable BROWSER are not set to a browser executable.");
            }
        }
    }

    public static void startWebServer(Connection conn) throws SQLException {
        Server.startWebServer(conn, false);
    }

    public static void startWebServer(Connection conn, boolean ignoreProperties) throws SQLException {
        WebServer webServer = new WebServer();
        String[] args = ignoreProperties ? new String[]{"-webPort", "0", "-properties", "null"} : new String[]{"-webPort", "0"};
        Server web = new Server(webServer, args);
        web.start();
        Server server = new Server();
        server.web = web;
        webServer.setShutdownHandler(server);
        String url = webServer.addSession(conn);
        try {
            Server.openBrowser(url);
            while (!webServer.isStopped()) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

