/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.type.DataType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MemoryEstimator {
    private static final int SKIP_SUM_SHIFT = 8;
    private static final int COUNTER_MASK = 255;
    private static final int SKIP_SUM_MASK = 65535;
    private static final int INIT_BIT_SHIFT = 24;
    private static final int INIT_BIT = 0x1000000;
    private static final int WINDOW_SHIFT = 8;
    private static final int MAGNITUDE_LIMIT = 7;
    private static final int WINDOW_SIZE = 256;
    private static final int WINDOW_HALF_SIZE = 128;
    private static final int SUM_SHIFT = 32;

    private MemoryEstimator() {
    }

    public static <T> int estimateMemory(AtomicLong stats, DataType<T> dataType, T data) {
        long statsData = stats.get();
        int counter = MemoryEstimator.getCounter(statsData);
        int skipSum = MemoryEstimator.getSkipSum(statsData);
        long initialized = statsData & 0x1000000L;
        long sum = statsData >>> 32;
        int mem = 0;
        int cnt = 0;
        if (initialized == 0L || counter-- == 0) {
            cnt = 1;
            mem = data == null ? 0 : dataType.getMemory(data);
            long delta = ((long)mem << 8) - sum;
            if (initialized == 0L) {
                if (++counter == 256) {
                    initialized = 0x1000000L;
                }
                sum = (sum * (long)counter + delta + (long)(counter >> 1)) / (long)counter;
            } else {
                long absDelta = delta >= 0L ? delta : -delta;
                int magnitude = MemoryEstimator.calculateMagnitude(sum, absDelta);
                sum += (delta >> 7 - magnitude) + 1L >> 1;
                counter = (1 << magnitude) - 1 & 0xFF;
                delta = (counter << 8) - skipSum;
                skipSum = (int)((long)skipSum + (delta + 128L >> 8));
            }
        }
        long updatedStatsData = MemoryEstimator.updateStatsData(stats, statsData, counter, skipSum, initialized, sum, cnt, mem);
        return MemoryEstimator.getAverage(updatedStatsData);
    }

    public static <T> int estimateMemory(AtomicLong stats, DataType<T> dataType, T[] storage, int count) {
        long statsData = stats.get();
        int counter = MemoryEstimator.getCounter(statsData);
        int skipSum = MemoryEstimator.getSkipSum(statsData);
        long initialized = statsData & 0x1000000L;
        long sum = statsData >>> 32;
        int index = 0;
        int memSum = 0;
        if (initialized != 0L && counter >= count) {
            counter -= count;
        } else {
            int cnt = count;
            while (cnt-- > 0) {
                T data;
                int mem = (data = storage[index++]) == null ? 0 : dataType.getMemory(data);
                memSum += mem;
                long delta = ((long)mem << 8) - sum;
                if (initialized == 0L) {
                    if (++counter == 256) {
                        initialized = 0x1000000L;
                    }
                    sum = (sum * (long)counter + delta + (long)(counter >> 1)) / (long)counter;
                    continue;
                }
                cnt -= counter;
                long absDelta = delta >= 0L ? delta : -delta;
                int magnitude = MemoryEstimator.calculateMagnitude(sum, absDelta);
                sum += (delta >> 7 - magnitude) + 1L >> 1;
                delta = ((long)(counter += (1 << magnitude) - 1 & 0xFF) << 8) - (long)skipSum;
                skipSum = (int)((long)skipSum + (delta + 128L >> 8));
            }
        }
        long updatedStatsData = MemoryEstimator.updateStatsData(stats, statsData, counter, skipSum, initialized, sum, index, memSum);
        return (MemoryEstimator.getAverage(updatedStatsData) + 8) * count;
    }

    public static int samplingPct(AtomicLong stats) {
        long statsData = stats.get();
        int count = (statsData & 0x1000000L) == 0L ? MemoryEstimator.getCounter(statsData) : 256;
        int total = MemoryEstimator.getSkipSum(statsData) + count;
        return (count * 100 + (total >> 1)) / total;
    }

    private static int calculateMagnitude(long sum, long absDelta) {
        int magnitude = 0;
        while (absDelta < sum && magnitude < 7) {
            ++magnitude;
            absDelta <<= 1;
        }
        return magnitude;
    }

    private static long updateStatsData(AtomicLong stats, long statsData, int counter, int skipSum, long initialized, long sum, int itemsCount, int itemsMem) {
        return MemoryEstimator.updateStatsData(stats, statsData, MemoryEstimator.constructStatsData(sum, initialized, skipSum, counter), itemsCount, itemsMem);
    }

    private static long constructStatsData(long sum, long initialized, int skipSum, int counter) {
        return sum << 32 | initialized | (long)skipSum << 8 | (long)counter;
    }

    private static long updateStatsData(AtomicLong stats, long statsData, long updatedStatsData, int itemsCount, int itemsMem) {
        while (!stats.compareAndSet(statsData, updatedStatsData)) {
            statsData = stats.get();
            long sum = statsData >>> 32;
            if (itemsCount > 0) {
                sum += (long)itemsMem - (sum * (long)itemsCount + 128L >> 8);
            }
            updatedStatsData = sum << 32 | statsData & 0x100FFFFL;
        }
        return updatedStatsData;
    }

    private static int getCounter(long statsData) {
        return (int)(statsData & 0xFFL);
    }

    private static int getSkipSum(long statsData) {
        return (int)(statsData >> 8 & 0xFFFFL);
    }

    private static int getAverage(long updatedStatsData) {
        return (int)(updatedStatsData >>> 40);
    }
}

