/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.h2.engine.SysProperties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MemoryUnmapper {
    private static final boolean ENABLED;
    private static final Object UNSAFE;
    private static final Method INVOKE_CLEANER;

    static {
        boolean enabled = SysProperties.NIO_CLEANER_HACK;
        Object unsafe = null;
        Method invokeCleaner = null;
        if (enabled) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = field.get(null);
                invokeCleaner = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            }
            catch (ReflectiveOperationException e) {
                unsafe = null;
            }
            catch (Throwable e) {
                enabled = false;
                unsafe = null;
            }
        }
        ENABLED = enabled;
        UNSAFE = unsafe;
        INVOKE_CLEANER = invokeCleaner;
    }

    public static boolean unmap(ByteBuffer buffer) {
        block5: {
            if (!ENABLED) {
                return false;
            }
            try {
                if (INVOKE_CLEANER == null) break block5;
                INVOKE_CLEANER.invoke(UNSAFE, buffer);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        Method cleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
        cleanerMethod.setAccessible(true);
        Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
        if (cleaner != null) {
            Method clearMethod = cleaner.getClass().getMethod("clean", new Class[0]);
            clearMethod.invoke(cleaner, new Object[0]);
        }
        return true;
    }

    private MemoryUnmapper() {
    }
}

