/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SourceCompiler {
    static final JavaCompiler JAVA_COMPILER;
    private static final Class<?> JAVAC_SUN;
    private static final String COMPILE_DIR;
    final HashMap<String, String> sources = new HashMap();
    final HashMap<String, Class<?>> compiled = new HashMap();
    final Map<String, CompiledScript> compiledScripts = new HashMap<String, CompiledScript>();
    boolean useJavaSystemCompiler = SysProperties.JAVA_SYSTEM_COMPILER;

    static {
        Class<?> clazz;
        JavaCompiler c;
        COMPILE_DIR = Utils.getProperty("java.io.tmpdir", ".");
        try {
            c = ToolProvider.getSystemJavaCompiler();
        }
        catch (Exception e) {
            c = null;
        }
        JAVA_COMPILER = c;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception e) {
            clazz = null;
        }
        JAVAC_SUN = clazz;
    }

    public void setSource(String className, String source) {
        this.sources.put(className, source);
        this.compiled.clear();
    }

    public void setJavaSystemCompiler(boolean enabled) {
        this.useJavaSystemCompiler = enabled;
    }

    public Class<?> getClass(String packageAndClassName) throws ClassNotFoundException {
        Class<?> compiledClass = this.compiled.get(packageAndClassName);
        if (compiledClass != null) {
            return compiledClass;
        }
        String source = this.sources.get(packageAndClassName);
        if (SourceCompiler.isGroovySource(source)) {
            Class<?> clazz = GroovyCompiler.parseClass(source, packageAndClassName);
            this.compiled.put(packageAndClassName, clazz);
            return clazz;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                Class<?> classInstance = SourceCompiler.this.compiled.get(name);
                if (classInstance == null) {
                    byte[] data;
                    String className;
                    String source = SourceCompiler.this.sources.get(name);
                    String packageName = null;
                    int idx = name.lastIndexOf(46);
                    if (idx >= 0) {
                        packageName = name.substring(0, idx);
                        className = name.substring(idx + 1);
                    } else {
                        className = name;
                    }
                    String s = SourceCompiler.getCompleteSourceCode(packageName, className, source);
                    classInstance = JAVA_COMPILER != null && SourceCompiler.this.useJavaSystemCompiler ? SourceCompiler.this.javaxToolsJavac(packageName, className, s) : ((data = SourceCompiler.this.javacCompile(packageName, className, s)) == null ? this.findSystemClass(name) : this.defineClass(name, data, 0, data.length));
                    SourceCompiler.this.compiled.put(name, classInstance);
                }
                return classInstance;
            }
        };
        return classLoader.loadClass(packageAndClassName);
    }

    private static boolean isGroovySource(String source) {
        return source.startsWith("//groovy") || source.startsWith("@groovy");
    }

    private static boolean isJavascriptSource(String source) {
        return source.startsWith("//javascript");
    }

    private static boolean isRubySource(String source) {
        return source.startsWith("#ruby");
    }

    public static boolean isJavaxScriptSource(String source) {
        return SourceCompiler.isJavascriptSource(source) || SourceCompiler.isRubySource(source);
    }

    public CompiledScript getCompiledScript(String packageAndClassName) throws ScriptException {
        CompiledScript compiledScript = this.compiledScripts.get(packageAndClassName);
        if (compiledScript == null) {
            String lang;
            String source = this.sources.get(packageAndClassName);
            if (SourceCompiler.isJavascriptSource(source)) {
                lang = "javascript";
            } else if (SourceCompiler.isRubySource(source)) {
                lang = "ruby";
            } else {
                throw new IllegalStateException("Unknown language for " + source);
            }
            ScriptEngine jsEngine = new ScriptEngineManager().getEngineByName(lang);
            if (jsEngine.getClass().getName().equals("com.oracle.truffle.js.scriptengine.GraalJSScriptEngine")) {
                Bindings bindings = jsEngine.getBindings(100);
                bindings.put("polyglot.js.allowHostAccess", (Object)true);
                bindings.put("polyglot.js.allowHostClassLookup", s -> true);
            }
            compiledScript = ((Compilable)((Object)jsEngine)).compile(source);
            this.compiledScripts.put(packageAndClassName, compiledScript);
        }
        return compiledScript;
    }

    public Method getMethod(String className) throws ClassNotFoundException {
        Method[] methods;
        Class<?> clazz = this.getClass(className);
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method m = methodArray[n2];
            int modifiers = m.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && !(name = m.getName()).startsWith("_") && !m.getName().equals("main")) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    byte[] javacCompile(String packageName, String className, String source) {
        Path dir = Paths.get(COMPILE_DIR, new String[0]);
        if (packageName != null) {
            dir = dir.resolve(packageName.replace('.', '/'));
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
        }
        Path javaFile = dir.resolve(className + ".java");
        Path classFile = dir.resolve(className + ".class");
        try {
            Files.write(javaFile, source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.deleteIfExists(classFile);
            if (JAVAC_SUN != null) {
                SourceCompiler.javacSun(javaFile);
            } else {
                SourceCompiler.javacProcess(javaFile);
            }
            byte[] byArray = Files.readAllBytes(classFile);
            return byArray;
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
        finally {
            try {
                Files.deleteIfExists(javaFile);
            }
            catch (IOException iOException) {}
            try {
                Files.deleteIfExists(classFile);
            }
            catch (IOException iOException) {}
        }
    }

    static String getCompleteSourceCode(String packageName, String className, String source) {
        if (source.startsWith("package ")) {
            return source;
        }
        StringBuilder buff = new StringBuilder();
        if (packageName != null) {
            buff.append("package ").append(packageName).append(";\n");
        }
        int endImport = source.indexOf("@CODE");
        String importCode = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
        if (endImport >= 0) {
            importCode = source.substring(0, endImport);
            source = source.substring("@CODE".length() + endImport);
        }
        buff.append(importCode);
        buff.append("public class ").append(className).append(" {\n    public static ").append(source).append("\n}\n");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> javaxToolsJavac(String packageName, String className, String source) {
        String fullClassName = packageName + "." + className;
        StringWriter writer = new StringWriter();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ClassFileManager fileManager = new ClassFileManager(JAVA_COMPILER.getStandardFileManager(null, null, null));){
                boolean ok;
                ArrayList<StringJavaFileObject> compilationUnits = new ArrayList<StringJavaFileObject>();
                compilationUnits.add(new StringJavaFileObject(fullClassName, source));
                JavaCompiler javaCompiler = JAVA_COMPILER;
                synchronized (javaCompiler) {
                    ok = JAVA_COMPILER.getTask(writer, fileManager, null, null, null, compilationUnits).call();
                }
                String output = writer.toString();
                SourceCompiler.handleSyntaxError(output, ok ? 0 : 1);
                return fileManager.getClassLoader(null).loadClass(fullClassName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw DbException.convert(e);
        }
    }

    private static void javacProcess(Path javaFile) {
        SourceCompiler.exec("javac", "-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", javaFile.toAbsolutePath().toString());
    }

    private static int exec(String ... args) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.environment().remove("JAVA_TOOL_OPTIONS");
            builder.command(args);
            Process p = builder.start();
            SourceCompiler.copyInThread(p.getInputStream(), buff);
            SourceCompiler.copyInThread(p.getErrorStream(), buff);
            p.waitFor();
            String output = buff.toString(StandardCharsets.UTF_8);
            SourceCompiler.handleSyntaxError(output, p.exitValue());
            return p.exitValue();
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Task(){

            @Override
            public void call() throws IOException {
                IOUtils.copy(in, out);
            }
        }.execute();
    }

    private static synchronized void javacSun(Path javaFile) {
        PrintStream old = System.err;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            try {
                System.setErr(new PrintStream((OutputStream)buff, false, "UTF-8"));
                Method compile = JAVAC_SUN.getMethod("compile", String[].class);
                Object javac = JAVAC_SUN.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Integer status = (Integer)compile.invoke(javac, new Object[]{new String[]{"-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", javaFile.toAbsolutePath().toString()}});
                String output = buff.toString(StandardCharsets.UTF_8);
                SourceCompiler.handleSyntaxError(output, status);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
        }
        finally {
            System.setErr(old);
        }
    }

    private static void handleSyntaxError(String output, int exitStatus) {
        if (exitStatus == 0) {
            return;
        }
        boolean syntaxError = false;
        BufferedReader reader = new BufferedReader(new StringReader(output));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith("warning") || line.endsWith("warnings") || line.startsWith("Note:") || line.startsWith("warning:")) continue;
                syntaxError = true;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (syntaxError) {
            output = StringUtils.replaceAll(output, COMPILE_DIR, "");
            throw DbException.get(42000, output);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        Map<String, JavaClassObject> classObjectsByName = new HashMap<String, JavaClassObject>();
        private SecureClassLoader classLoader = new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                byte[] bytes = classObjectsByName.get(name).getBytes();
                return super.defineClass(name, bytes, 0, bytes.length);
            }
        };

        public ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            JavaClassObject classObject = new JavaClassObject(className, kind);
            this.classObjectsByName.put(className, classObject);
            return classObject;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class GroovyCompiler {
        private static final Object LOADER;
        private static final Throwable INIT_FAIL_EXCEPTION;

        static {
            Object loader = null;
            Exception initFailException = null;
            try {
                Class<?> importCustomizerClass = Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Object importCustomizer = Utils.newInstance("org.codehaus.groovy.control.customizers.ImportCustomizer", new Object[0]);
                String[] importsArray = new String[]{"java.sql.Connection", "java.sql.Types", "java.sql.ResultSet", "groovy.sql.Sql", "org.h2.tools.SimpleResultSet"};
                Utils.callMethod(importCustomizer, "addImports", new Object[]{importsArray});
                Object importCustomizerArray = Array.newInstance(importCustomizerClass, 1);
                Array.set(importCustomizerArray, 0, importCustomizer);
                Object configuration = Utils.newInstance("org.codehaus.groovy.control.CompilerConfiguration", new Object[0]);
                Utils.callMethod(configuration, "addCompilationCustomizers", importCustomizerArray);
                ClassLoader parent = GroovyCompiler.class.getClassLoader();
                loader = Utils.newInstance("groovy.lang.GroovyClassLoader", parent, configuration);
            }
            catch (Exception ex) {
                initFailException = ex;
            }
            LOADER = loader;
            INIT_FAIL_EXCEPTION = initFailException;
        }

        private GroovyCompiler() {
        }

        public static Class<?> parseClass(String source, String packageAndClassName) {
            if (LOADER == null) {
                throw new RuntimeException("Compile fail: no Groovy jar in the classpath", INIT_FAIL_EXCEPTION);
            }
            try {
                Object codeSource = Utils.newInstance("groovy.lang.GroovyCodeSource", source, packageAndClassName + ".groovy", "UTF-8");
                Utils.callMethod(codeSource, "setCachable", false);
                return (Class)Utils.callMethod(LOADER, "parseClass", codeSource);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class JavaClassObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        public JavaClassObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.out.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.out;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class StringJavaFileObject
    extends SimpleJavaFileObject {
        private final String sourceCode;

        public StringJavaFileObject(String className, String sourceCode) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = sourceCode;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.sourceCode;
        }
    }
}

