/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneRules;
import java.util.Locale;
import org.h2.util.DateTimeUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TimeZoneProvider {
    public static final TimeZoneProvider UTC = new Simple(0);
    public static TimeZoneProvider[] CACHE;
    private static final int CACHE_SIZE = 32;

    public static TimeZoneProvider ofOffset(int offset) {
        if (offset == 0) {
            return UTC;
        }
        if (offset < -64800 || offset > 64800) {
            throw new IllegalArgumentException("Time zone offset " + offset + " seconds is out of range");
        }
        return new Simple(offset);
    }

    public static TimeZoneProvider ofId(String id) throws RuntimeException {
        TimeZoneProvider provider;
        int length = id.length();
        if (length == 1 && id.charAt(0) == 'Z') {
            return UTC;
        }
        int index = 0;
        if (id.startsWith("GMT") || id.startsWith("UTC")) {
            if (length == 3) {
                return UTC;
            }
            index = 3;
        }
        if (length > index) {
            boolean negative = false;
            char c = id.charAt(index);
            if (length > index + 1) {
                if (c == '+') {
                    c = id.charAt(++index);
                } else if (c == '-') {
                    negative = true;
                    c = id.charAt(++index);
                }
            }
            if (index != 3 && c >= '0' && c <= '9') {
                int hour = c - 48;
                if (++index < length && (c = id.charAt(index)) >= '0' && c <= '9') {
                    hour = hour * 10 + c - 48;
                    ++index;
                }
                if (index == length) {
                    int offset = hour * 3600;
                    return TimeZoneProvider.ofOffset(negative ? -offset : offset);
                }
                if (id.charAt(index) == ':' && ++index < length && (c = id.charAt(index)) >= '0' && c <= '9') {
                    int minute = c - 48;
                    if (++index < length && (c = id.charAt(index)) >= '0' && c <= '9') {
                        minute = minute * 10 + c - 48;
                        ++index;
                    }
                    if (index == length) {
                        int offset = (hour * 60 + minute) * 60;
                        return TimeZoneProvider.ofOffset(negative ? -offset : offset);
                    }
                    if (id.charAt(index) == ':' && ++index < length && (c = id.charAt(index)) >= '0' && c <= '9') {
                        int second = c - 48;
                        if (++index < length && (c = id.charAt(index)) >= '0' && c <= '9') {
                            second = second * 10 + c - 48;
                            ++index;
                        }
                        if (index == length) {
                            int offset = (hour * 60 + minute) * 60 + second;
                            return TimeZoneProvider.ofOffset(negative ? -offset : offset);
                        }
                    }
                }
            }
            if (index > 0) {
                throw new IllegalArgumentException(id);
            }
        }
        int hash = id.hashCode() & 0x1F;
        TimeZoneProvider[] cache = CACHE;
        if (cache != null && (provider = cache[hash]) != null && provider.getId().equals(id)) {
            return provider;
        }
        WithTimeZone provider2 = new WithTimeZone(ZoneId.of(id, ZoneId.SHORT_IDS));
        if (cache == null) {
            CACHE = cache = new TimeZoneProvider[32];
        }
        cache[hash] = provider2;
        return provider2;
    }

    public static TimeZoneProvider getDefault() {
        ZoneOffset offset;
        ZoneId zoneId = ZoneId.systemDefault();
        if (zoneId instanceof ZoneOffset) {
            offset = (ZoneOffset)zoneId;
        } else {
            ZoneRules rules = zoneId.getRules();
            if (!rules.isFixedOffset()) {
                return new WithTimeZone(zoneId);
            }
            offset = rules.getOffset(Instant.EPOCH);
        }
        return TimeZoneProvider.ofOffset(offset.getTotalSeconds());
    }

    public abstract int getTimeZoneOffsetUTC(long var1);

    public abstract int getTimeZoneOffsetLocal(long var1, long var3);

    public abstract long getEpochSecondsFromLocal(long var1, long var3);

    public abstract String getId();

    public abstract String getShortId(long var1);

    public boolean hasFixedOffset() {
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Simple
    extends TimeZoneProvider {
        private final int offset;
        private volatile String id;

        Simple(int offset) {
            this.offset = offset;
        }

        public int hashCode() {
            return this.offset + 129607;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != Simple.class) {
                return false;
            }
            return this.offset == ((Simple)obj).offset;
        }

        @Override
        public int getTimeZoneOffsetUTC(long epochSeconds) {
            return this.offset;
        }

        @Override
        public int getTimeZoneOffsetLocal(long dateValue, long timeNanos) {
            return this.offset;
        }

        @Override
        public long getEpochSecondsFromLocal(long dateValue, long timeNanos) {
            return DateTimeUtils.getEpochSeconds(dateValue, timeNanos, this.offset);
        }

        @Override
        public String getId() {
            String id = this.id;
            if (id == null) {
                this.id = id = DateTimeUtils.timeZoneNameFromOffsetSeconds(this.offset);
            }
            return id;
        }

        @Override
        public String getShortId(long epochSeconds) {
            return this.getId();
        }

        @Override
        public boolean hasFixedOffset() {
            return true;
        }

        public String toString() {
            return "TimeZoneProvider " + this.getId();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class WithTimeZone
    extends TimeZoneProvider {
        static final long SECONDS_PER_PERIOD = 12622780800L;
        static final long SECONDS_PER_YEAR = 31556952L;
        private static volatile DateTimeFormatter TIME_ZONE_FORMATTER;
        private final ZoneId zoneId;

        WithTimeZone(ZoneId timeZone) {
            this.zoneId = timeZone;
        }

        public int hashCode() {
            return this.zoneId.hashCode() + 951689;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != WithTimeZone.class) {
                return false;
            }
            return this.zoneId.equals(((WithTimeZone)obj).zoneId);
        }

        @Override
        public int getTimeZoneOffsetUTC(long epochSeconds) {
            if (epochSeconds > 31556889832715999L) {
                epochSeconds -= 12622780800L;
            } else if (epochSeconds < -31557014135532000L) {
                epochSeconds += 12622780800L;
            }
            return this.zoneId.getRules().getOffset(Instant.ofEpochSecond(epochSeconds)).getTotalSeconds();
        }

        @Override
        public int getTimeZoneOffsetLocal(long dateValue, long timeNanos) {
            int second = (int)(timeNanos / 1000000000L);
            int minute = second / 60;
            second -= minute * 60;
            int hour = minute / 60;
            return ZonedDateTime.of(LocalDateTime.of(WithTimeZone.yearForCalendar(DateTimeUtils.yearFromDateValue(dateValue)), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), hour, minute -= hour * 60, second), this.zoneId).getOffset().getTotalSeconds();
        }

        @Override
        public long getEpochSecondsFromLocal(long dateValue, long timeNanos) {
            int second = (int)(timeNanos / 1000000000L);
            int minute = second / 60;
            second -= minute * 60;
            int hour = minute / 60;
            int year = DateTimeUtils.yearFromDateValue(dateValue);
            int yearForCalendar = WithTimeZone.yearForCalendar(year);
            long epoch = ZonedDateTime.of(LocalDateTime.of(yearForCalendar, DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue), hour, minute -= hour * 60, second), this.zoneId).toOffsetDateTime().toEpochSecond();
            return epoch + (long)(year - yearForCalendar) * 31556952L;
        }

        @Override
        public String getId() {
            return this.zoneId.getId();
        }

        @Override
        public String getShortId(long epochSeconds) {
            DateTimeFormatter timeZoneFormatter = TIME_ZONE_FORMATTER;
            if (timeZoneFormatter == null) {
                TIME_ZONE_FORMATTER = timeZoneFormatter = DateTimeFormatter.ofPattern("z", Locale.ENGLISH);
            }
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds), this.zoneId).format(timeZoneFormatter);
        }

        private static int yearForCalendar(int year) {
            if (year > 999999999) {
                year -= 400;
            } else if (year < -999999999) {
                year += 400;
            }
            return year;
        }

        public String toString() {
            return "TimeZoneProvider " + this.zoneId.getId();
        }
    }
}

