/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.math.BigDecimal;
import org.h2.util.StringUtils;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONTextSource;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JSONStringSource
extends JSONTextSource {
    private final String string;
    private final int length;
    private int index;

    public static <R> R parse(String string, JSONTarget<R> target) {
        new JSONStringSource(string, target).parse();
        return target.getResult();
    }

    public static byte[] normalize(String string) {
        return JSONStringSource.parse(string, new JSONByteArrayTarget());
    }

    JSONStringSource(String string, JSONTarget<?> target) {
        super(target);
        this.string = string;
        this.length = string.length();
        if (this.length == 0) {
            throw new IllegalArgumentException();
        }
        if (string.charAt(this.index) == '\ufeff') {
            ++this.index;
        }
    }

    @Override
    int nextCharAfterWhitespace() {
        int index = this.index;
        while (index < this.length) {
            char ch = this.string.charAt(index++);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    this.index = index;
                    return ch;
                }
            }
        }
        return -1;
    }

    @Override
    void readKeyword1(String keyword) {
        int l = keyword.length() - 1;
        if (!this.string.regionMatches(this.index, keyword, 1, l)) {
            throw new IllegalArgumentException();
        }
        this.index += l;
    }

    @Override
    void parseNumber(boolean positive) {
        int start;
        int index;
        block6: {
            char ch;
            block7: {
                index = this.index;
                start = index - 1;
                if ((index = this.skipInt(index, positive)) >= this.length) break block6;
                ch = this.string.charAt(index);
                if (ch != '.') break block7;
                if ((index = this.skipInt(index + 1, false)) >= this.length) break block6;
                ch = this.string.charAt(index);
            }
            if (ch == 'E' || ch == 'e') {
                if (++index >= this.length) {
                    throw new IllegalArgumentException();
                }
                ch = this.string.charAt(index);
                if (ch == '+' || ch == '-') {
                    ++index;
                }
                index = this.skipInt(index, false);
            }
        }
        this.target.valueNumber(new BigDecimal(this.string.substring(start, index)));
        this.index = index;
    }

    private int skipInt(int index, boolean hasInt) {
        while (index < this.length) {
            char ch = this.string.charAt(index);
            if (ch < '0' || ch > '9') break;
            hasInt = true;
            ++index;
        }
        if (!hasInt) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    @Override
    int nextChar() {
        if (this.index >= this.length) {
            throw new IllegalArgumentException();
        }
        return this.string.charAt(this.index++);
    }

    @Override
    char readHex() {
        if (this.index + 3 >= this.length) {
            throw new IllegalArgumentException();
        }
        try {
            return (char)Integer.parseInt(this.string.substring(this.index, this.index += 4), 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        return StringUtils.addAsterisk(this.string, this.index);
    }
}

