/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import org.h2.util.json.JSONTarget;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class JSONTextSource {
    final JSONTarget<?> target;
    private final StringBuilder builder;

    JSONTextSource(JSONTarget<?> target) {
        this.target = target;
        this.builder = new StringBuilder();
    }

    final void parse() {
        int ch;
        boolean comma = false;
        while ((ch = this.nextCharAfterWhitespace()) >= 0) {
            if (ch == 125 || ch == 93) {
                if (comma) {
                    throw new IllegalArgumentException();
                }
                if (ch == 125) {
                    this.target.endObject();
                    continue;
                }
                this.target.endArray();
                continue;
            }
            if (ch == 44) {
                if (comma || !this.target.isValueSeparatorExpected()) {
                    throw new IllegalArgumentException();
                }
                comma = true;
                continue;
            }
            if (comma != this.target.isValueSeparatorExpected()) {
                throw new IllegalArgumentException();
            }
            comma = false;
            switch (ch) {
                case 102: {
                    this.readKeyword1("false");
                    this.target.valueFalse();
                    break;
                }
                case 110: {
                    this.readKeyword1("null");
                    this.target.valueNull();
                    break;
                }
                case 116: {
                    this.readKeyword1("true");
                    this.target.valueTrue();
                    break;
                }
                case 123: {
                    this.target.startObject();
                    break;
                }
                case 91: {
                    this.target.startArray();
                    break;
                }
                case 34: {
                    String s = this.readString();
                    if (this.target.isPropertyExpected()) {
                        if (this.nextCharAfterWhitespace() != 58) {
                            throw new IllegalArgumentException();
                        }
                        this.target.member(s);
                        break;
                    }
                    this.target.valueString(s);
                    break;
                }
                case 45: {
                    this.parseNumber(false);
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseNumber(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    abstract int nextCharAfterWhitespace();

    abstract void readKeyword1(String var1);

    abstract void parseNumber(boolean var1);

    abstract int nextChar();

    abstract char readHex();

    private String readString() {
        this.builder.setLength(0);
        boolean inSurrogate = false;
        block13: while (true) {
            int ch = this.nextChar();
            switch (ch) {
                case 34: {
                    if (inSurrogate) {
                        throw new IllegalArgumentException();
                    }
                    return this.builder.toString();
                }
                case 92: {
                    ch = this.nextChar();
                    switch (ch) {
                        case 34: 
                        case 47: 
                        case 92: {
                            this.appendNonSurrogate((char)ch, inSurrogate);
                            continue block13;
                        }
                        case 98: {
                            this.appendNonSurrogate('\b', inSurrogate);
                            continue block13;
                        }
                        case 102: {
                            this.appendNonSurrogate('\f', inSurrogate);
                            continue block13;
                        }
                        case 110: {
                            this.appendNonSurrogate('\n', inSurrogate);
                            continue block13;
                        }
                        case 114: {
                            this.appendNonSurrogate('\r', inSurrogate);
                            continue block13;
                        }
                        case 116: {
                            this.appendNonSurrogate('\t', inSurrogate);
                            continue block13;
                        }
                        case 117: {
                            inSurrogate = this.appendChar(this.readHex(), inSurrogate);
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            if (Character.isBmpCodePoint(ch)) {
                inSurrogate = this.appendChar((char)ch, inSurrogate);
                continue;
            }
            if (inSurrogate) {
                throw new IllegalArgumentException();
            }
            this.builder.appendCodePoint(ch);
            inSurrogate = false;
        }
    }

    private void appendNonSurrogate(char ch, boolean inSurrogate) {
        if (inSurrogate) {
            throw new IllegalArgumentException();
        }
        this.builder.append(ch);
    }

    private boolean appendChar(char ch, boolean inSurrogate) {
        if (inSurrogate != Character.isLowSurrogate(ch)) {
            throw new IllegalArgumentException();
        }
        if (inSurrogate) {
            inSurrogate = false;
        } else if (Character.isHighSurrogate(ch)) {
            inSurrogate = true;
        }
        this.builder.append(ch);
        return inSurrogate;
    }
}

