/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.io.ByteArrayOutputStream;
import org.h2.message.DbException;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONStringTarget;
import org.h2.util.json.JSONValidationTargetWithUniqueKeys;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JsonConstructorUtils {
    public static final int JSON_ABSENT_ON_NULL = 1;
    public static final int JSON_WITH_UNIQUE_KEYS = 2;

    private JsonConstructorUtils() {
    }

    public static void jsonObjectAppend(ByteArrayOutputStream baos, String key, Value value) {
        if (baos.size() > 1) {
            baos.write(44);
        }
        JSONByteArrayTarget.encodeString(baos, key).write(58);
        byte[] b = value.convertToJson(TypeInfo.TYPE_JSON, 0, null).getBytesNoCopy();
        baos.write(b, 0, b.length);
    }

    public static Value jsonObjectFinish(ByteArrayOutputStream baos, int flags) {
        baos.write(125);
        byte[] result = baos.toByteArray();
        if ((flags & 2) != 0) {
            try {
                JSONBytesSource.parse(result, new JSONValidationTargetWithUniqueKeys());
            }
            catch (RuntimeException ex) {
                String s = JSONBytesSource.parse(result, new JSONStringTarget());
                throw DbException.getInvalidValueException("JSON WITH UNIQUE KEYS", s.length() < 128 ? result : (byte[])(s.substring(0, 128) + "..."));
            }
        }
        return ValueJson.getInternal(result);
    }

    public static void jsonArrayAppend(ByteArrayOutputStream baos, Value value, int flags) {
        if (value == ValueNull.INSTANCE || value == ValueJson.NULL) {
            if ((flags & 1) != 0) {
                return;
            }
            value = ValueJson.NULL;
        }
        if (baos.size() > 1) {
            baos.write(44);
        }
        byte[] b = value.convertTo(TypeInfo.TYPE_JSON).getBytesNoCopy();
        baos.write(b, 0, b.length);
    }
}

