/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.util.Bits;
import org.h2.util.DateTimeUtils;
import org.h2.util.HasSQL;
import org.h2.util.IntervalUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.geometry.GeoJsonUtils;
import org.h2.util.json.JsonConstructorUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueEnum;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;
import org.h2.value.VersionedValue;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataInMemory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Value
extends VersionedValue<Value>
implements HasSQL,
Typed {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int CHAR = 1;
    public static final int VARCHAR = 2;
    public static final int CLOB = 3;
    public static final int VARCHAR_IGNORECASE = 4;
    public static final int BINARY = 5;
    public static final int VARBINARY = 6;
    public static final int BLOB = 7;
    public static final int BOOLEAN = 8;
    public static final int TINYINT = 9;
    public static final int SMALLINT = 10;
    public static final int INTEGER = 11;
    public static final int BIGINT = 12;
    public static final int NUMERIC = 13;
    public static final int REAL = 14;
    public static final int DOUBLE = 15;
    public static final int DECFLOAT = 16;
    public static final int DATE = 17;
    public static final int TIME = 18;
    public static final int TIME_TZ = 19;
    public static final int TIMESTAMP = 20;
    public static final int TIMESTAMP_TZ = 21;
    public static final int INTERVAL_YEAR = 22;
    public static final int INTERVAL_MONTH = 23;
    public static final int INTERVAL_DAY = 24;
    public static final int INTERVAL_HOUR = 25;
    public static final int INTERVAL_MINUTE = 26;
    public static final int INTERVAL_SECOND = 27;
    public static final int INTERVAL_YEAR_TO_MONTH = 28;
    public static final int INTERVAL_DAY_TO_HOUR = 29;
    public static final int INTERVAL_DAY_TO_MINUTE = 30;
    public static final int INTERVAL_DAY_TO_SECOND = 31;
    public static final int INTERVAL_HOUR_TO_MINUTE = 32;
    public static final int INTERVAL_HOUR_TO_SECOND = 33;
    public static final int INTERVAL_MINUTE_TO_SECOND = 34;
    public static final int JAVA_OBJECT = 35;
    public static final int ENUM = 36;
    public static final int GEOMETRY = 37;
    public static final int JSON = 38;
    public static final int UUID = 39;
    public static final int ARRAY = 40;
    public static final int ROW = 41;
    public static final int TYPE_COUNT = 42;
    static final int GROUP_NULL = 0;
    static final int GROUP_CHARACTER_STRING = 1;
    static final int GROUP_BINARY_STRING = 2;
    static final int GROUP_BOOLEAN = 3;
    static final int GROUP_NUMERIC = 4;
    static final int GROUP_DATETIME = 5;
    static final int GROUP_INTERVAL_YM = 6;
    static final int GROUP_INTERVAL_DT = 7;
    static final int GROUP_OTHER = 8;
    static final int GROUP_COLLECTION = 9;
    static final byte[] GROUPS;
    private static final String[] NAMES;
    public static final Value[] EMPTY_VALUES;
    private static SoftReference<Value[]> softCache;
    public static final BigDecimal MAX_LONG_DECIMAL;
    public static final BigDecimal MIN_LONG_DECIMAL;
    public static final int CONVERT_TO = 0;
    public static final int CAST_TO = 1;
    public static final int ASSIGN_TO = 2;

    static {
        byte[] byArray = new byte[42];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 2;
        byArray[8] = 3;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 4;
        byArray[17] = 5;
        byArray[18] = 5;
        byArray[19] = 5;
        byArray[20] = 5;
        byArray[21] = 5;
        byArray[22] = 6;
        byArray[23] = 6;
        byArray[24] = 7;
        byArray[25] = 7;
        byArray[26] = 7;
        byArray[27] = 7;
        byArray[28] = 6;
        byArray[29] = 7;
        byArray[30] = 7;
        byArray[31] = 7;
        byArray[32] = 7;
        byArray[33] = 7;
        byArray[34] = 7;
        byArray[35] = 8;
        byArray[36] = 8;
        byArray[37] = 8;
        byArray[38] = 8;
        byArray[39] = 8;
        byArray[40] = 9;
        byArray[41] = 9;
        GROUPS = byArray;
        NAMES = new String[]{"UNKNOWN", "NULL", "CHARACTER", "CHARACTER VARYING", "CHARACTER LARGE OBJECT", "VARCHAR_IGNORECASE", "BINARY", "BINARY VARYING", "BINARY LARGE OBJECT", "BOOLEAN", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "NUMERIC", "REAL", "DOUBLE PRECISION", "DECFLOAT", "DATE", "TIME", "TIME WITH TIME ZONE", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "INTERVAL YEAR", "INTERVAL MONTH", "INTERVAL DAY", "INTERVAL HOUR", "INTERVAL MINUTE", "INTERVAL SECOND", "INTERVAL YEAR TO MONTH", "INTERVAL DAY TO HOUR", "INTERVAL DAY TO MINUTE", "INTERVAL DAY TO SECOND", "INTERVAL HOUR TO MINUTE", "INTERVAL HOUR TO SECOND", "INTERVAL MINUTE TO SECOND", "JAVA_OBJECT", "ENUM", "GEOMETRY", "JSON", "UUID", "ARRAY", "ROW"};
        EMPTY_VALUES = new Value[0];
        MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
        MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    }

    public static String getTypeName(int valueType) {
        return NAMES[valueType + 1];
    }

    static void rangeCheck(long zeroBasedOffset, long length, long dataSize) {
        if ((zeroBasedOffset | length) < 0L || length > dataSize - zeroBasedOffset) {
            if (zeroBasedOffset < 0L || zeroBasedOffset > dataSize) {
                throw DbException.getInvalidValueException("offset", zeroBasedOffset + 1L);
            }
            throw DbException.getInvalidValueException("length", length);
        }
    }

    @Override
    public abstract TypeInfo getType();

    public abstract int getValueType();

    public int getMemory() {
        return 24;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static int getHigherOrder(int t1, int t2) {
        if (t1 == t2) {
            if (t1 == -1) {
                throw DbException.get(50004, "?, ?");
            }
            return t1;
        }
        if (t1 < t2) {
            int t = t1;
            t1 = t2;
            t2 = t;
        }
        if (t1 == -1) {
            if (t2 == 0) {
                throw DbException.get(50004, "?, NULL");
            }
            return t2;
        }
        if (t2 == -1) {
            if (t1 == 0) {
                throw DbException.get(50004, "NULL, ?");
            }
            return t1;
        }
        if (t2 == 0) {
            return t1;
        }
        return Value.getHigherOrderKnown(t1, t2);
    }

    private static int getHigherOrderNonNull(int t1, int t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 < t2) {
            int t = t1;
            t1 = t2;
            t2 = t;
        }
        return Value.getHigherOrderKnown(t1, t2);
    }

    static int getHigherOrderKnown(int t1, int t2) {
        byte g1 = GROUPS[t1];
        byte g2 = GROUPS[t2];
        switch (g1) {
            case 3: {
                if (g2 != 2) break;
                throw Value.getDataTypeCombinationException(8, t2);
            }
            case 4: {
                return Value.getHigherNumeric(t1, t2, g2);
            }
            case 5: {
                return Value.getHigherDateTime(t1, t2, g2);
            }
            case 6: {
                return Value.getHigherIntervalYearMonth(t1, t2, g2);
            }
            case 7: {
                return Value.getHigherIntervalDayTime(t1, t2, g2);
            }
            case 8: {
                return Value.getHigherOther(t1, t2, g2);
            }
        }
        return t1;
    }

    private static int getHigherNumeric(int t1, int t2, int g2) {
        if (g2 == 4) {
            switch (t1) {
                case 14: {
                    switch (t2) {
                        case 11: {
                            return 15;
                        }
                        case 12: 
                        case 13: {
                            return 16;
                        }
                    }
                    break;
                }
                case 15: {
                    switch (t2) {
                        case 12: 
                        case 13: {
                            return 16;
                        }
                    }
                }
            }
        } else if (g2 == 2) {
            throw Value.getDataTypeCombinationException(t1, t2);
        }
        return t1;
    }

    private static int getHigherDateTime(int t1, int t2, int g2) {
        if (g2 == 1) {
            return t1;
        }
        if (g2 != 5) {
            throw Value.getDataTypeCombinationException(t1, t2);
        }
        switch (t1) {
            case 18: {
                if (t2 != 17) break;
                return 20;
            }
            case 19: {
                if (t2 != 17) break;
                return 21;
            }
            case 20: {
                if (t2 != 19) break;
                return 21;
            }
        }
        return t1;
    }

    private static int getHigherIntervalYearMonth(int t1, int t2, int g2) {
        switch (g2) {
            case 6: {
                if (t1 == 23 && t2 == 22) {
                    return 28;
                }
            }
            case 1: 
            case 4: {
                return t1;
            }
        }
        throw Value.getDataTypeCombinationException(t1, t2);
    }

    private static int getHigherIntervalDayTime(int t1, int t2, int g2) {
        switch (g2) {
            case 7: {
                break;
            }
            case 1: 
            case 4: {
                return t1;
            }
            default: {
                throw Value.getDataTypeCombinationException(t1, t2);
            }
        }
        switch (t1) {
            case 25: {
                return 29;
            }
            case 26: {
                if (t2 == 24) {
                    return 30;
                }
                return 32;
            }
            case 27: {
                if (t2 == 24) {
                    return 31;
                }
                if (t2 == 25) {
                    return 33;
                }
                return 34;
            }
            case 29: {
                if (t2 == 26) {
                    return 30;
                }
                if (t2 != 27) break;
                return 31;
            }
            case 30: {
                if (t2 != 27) break;
                return 31;
            }
            case 32: {
                switch (t2) {
                    case 24: 
                    case 29: 
                    case 30: {
                        return 30;
                    }
                    case 27: {
                        return 33;
                    }
                    case 31: {
                        return 31;
                    }
                }
                break;
            }
            case 33: {
                switch (t2) {
                    case 24: 
                    case 29: 
                    case 30: 
                    case 31: {
                        return 31;
                    }
                }
                break;
            }
            case 34: {
                switch (t2) {
                    case 24: 
                    case 29: 
                    case 30: 
                    case 31: {
                        return 31;
                    }
                    case 25: 
                    case 32: 
                    case 33: {
                        return 33;
                    }
                }
            }
        }
        return t1;
    }

    private static int getHigherOther(int t1, int t2, int g2) {
        block0 : switch (t1) {
            case 35: {
                if (g2 == 2) break;
                throw Value.getDataTypeCombinationException(t1, t2);
            }
            case 36: {
                if (g2 == 1 || g2 == 4 && t2 <= 11) break;
                throw Value.getDataTypeCombinationException(t1, t2);
            }
            case 37: {
                if (g2 == 1 || g2 == 2) break;
                throw Value.getDataTypeCombinationException(t1, t2);
            }
            case 38: {
                switch (g2) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        throw Value.getDataTypeCombinationException(t1, t2);
                    }
                }
                break;
            }
            case 39: {
                switch (g2) {
                    case 1: 
                    case 2: {
                        break block0;
                    }
                    case 8: {
                        if (t2 == 35) break block0;
                    }
                    default: {
                        throw Value.getDataTypeCombinationException(t1, t2);
                    }
                }
            }
        }
        return t1;
    }

    private static DbException getDataTypeCombinationException(int t1, int t2) {
        return DbException.get(22018, Value.getTypeName(t1) + ", " + Value.getTypeName(t2));
    }

    static Value cache(Value v) {
        if (SysProperties.OBJECT_CACHE) {
            int index;
            Value cached;
            Value[] cache;
            int hash = v.hashCode();
            if (softCache == null || (cache = softCache.get()) == null) {
                cache = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(cache);
            }
            if ((cached = cache[index = hash & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && cached.getValueType() == v.getValueType() && v.equals(cached)) {
                return cached;
            }
            cache[index] = v;
        }
        return v;
    }

    public static void clearCache() {
        softCache = null;
    }

    public abstract String getString();

    public Reader getReader() {
        return new StringReader(this.getString());
    }

    public Reader getReader(long oneBasedOffset, long length) {
        String string = this.getString();
        long zeroBasedOffset = oneBasedOffset - 1L;
        Value.rangeCheck(zeroBasedOffset, length, string.length());
        int offset = (int)zeroBasedOffset;
        return new StringReader(string.substring(offset, offset + (int)length));
    }

    public byte[] getBytes() {
        throw this.getDataConversionError(6);
    }

    public byte[] getBytesNoCopy() {
        return this.getBytes();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public InputStream getInputStream(long oneBasedOffset, long length) {
        byte[] bytes = this.getBytesNoCopy();
        long zeroBasedOffset = oneBasedOffset - 1L;
        Value.rangeCheck(zeroBasedOffset, length, bytes.length);
        return new ByteArrayInputStream(bytes, (int)zeroBasedOffset, (int)length);
    }

    public boolean getBoolean() {
        return this.convertToBoolean().getBoolean();
    }

    public byte getByte() {
        return this.convertToTinyint(null).getByte();
    }

    public short getShort() {
        return this.convertToSmallint(null).getShort();
    }

    public int getInt() {
        return this.convertToInt(null).getInt();
    }

    public long getLong() {
        return this.convertToBigint(null).getLong();
    }

    public BigDecimal getBigDecimal() {
        throw this.getDataConversionError(13);
    }

    public float getFloat() {
        throw this.getDataConversionError(14);
    }

    public double getDouble() {
        throw this.getDataConversionError(15);
    }

    public Value add(Value v) {
        throw this.getUnsupportedExceptionForOperation("+");
    }

    public int getSignum() {
        throw this.getUnsupportedExceptionForOperation("SIGNUM");
    }

    public Value negate() {
        throw this.getUnsupportedExceptionForOperation("NEG");
    }

    public Value subtract(Value v) {
        throw this.getUnsupportedExceptionForOperation("-");
    }

    public Value divide(Value v, TypeInfo quotientType) {
        throw this.getUnsupportedExceptionForOperation("/");
    }

    public Value multiply(Value v) {
        throw this.getUnsupportedExceptionForOperation("*");
    }

    public Value modulus(Value v) {
        throw this.getUnsupportedExceptionForOperation("%");
    }

    public final Value convertTo(int targetType) {
        return this.convertTo(targetType, null);
    }

    public final Value convertTo(TypeInfo targetType) {
        return this.convertTo(targetType, null, 0, null);
    }

    public final Value convertTo(int targetType, CastDataProvider provider) {
        switch (targetType) {
            case 40: {
                return this.convertToAnyArray(provider);
            }
            case 41: {
                return this.convertToAnyRow();
            }
        }
        return this.convertTo(TypeInfo.getTypeInfo(targetType), provider, 0, null);
    }

    public final Value convertTo(TypeInfo targetType, CastDataProvider provider) {
        return this.convertTo(targetType, provider, 0, null);
    }

    public final Value convertTo(TypeInfo targetType, CastDataProvider provider, Object column) {
        return this.convertTo(targetType, provider, 0, column);
    }

    public final ValueJson convertToAnyJson() {
        return this != ValueNull.INSTANCE ? this.convertToJson(TypeInfo.TYPE_JSON, 0, null) : ValueJson.NULL;
    }

    public final ValueArray convertToAnyArray(CastDataProvider provider) {
        if (this.getValueType() == 40) {
            return (ValueArray)this;
        }
        return ValueArray.get(this.getType(), new Value[]{this}, provider);
    }

    public final ValueRow convertToAnyRow() {
        if (this.getValueType() == 41) {
            return (ValueRow)this;
        }
        return ValueRow.get(new Value[]{this});
    }

    public final Value castTo(TypeInfo targetType, CastDataProvider provider) {
        return this.convertTo(targetType, provider, 1, null);
    }

    public final Value convertForAssignTo(TypeInfo targetType, CastDataProvider provider, Object column) {
        return this.convertTo(targetType, provider, 2, column);
    }

    private Value convertTo(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        int targetValueType;
        int valueType = this.getValueType();
        if (valueType == 0 || valueType == (targetValueType = targetType.getValueType()) && conversionMode == 0 && targetType.getExtTypeInfo() == null && valueType != 1) {
            return this;
        }
        switch (targetValueType) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 1: {
                return this.convertToChar(targetType, provider, conversionMode, column);
            }
            case 2: {
                return this.convertToVarchar(targetType, provider, conversionMode, column);
            }
            case 3: {
                return this.convertToClob(targetType, conversionMode, column);
            }
            case 4: {
                return this.convertToVarcharIgnoreCase(targetType, conversionMode, column);
            }
            case 5: {
                return this.convertToBinary(targetType, conversionMode, column);
            }
            case 6: {
                return this.convertToVarbinary(targetType, conversionMode, column);
            }
            case 7: {
                return this.convertToBlob(targetType, conversionMode, column);
            }
            case 8: {
                return this.convertToBoolean();
            }
            case 9: {
                return this.convertToTinyint(column);
            }
            case 10: {
                return this.convertToSmallint(column);
            }
            case 11: {
                return this.convertToInt(column);
            }
            case 12: {
                return this.convertToBigint(column);
            }
            case 13: {
                return this.convertToNumeric(targetType, provider, conversionMode, column);
            }
            case 14: {
                return this.convertToReal();
            }
            case 15: {
                return this.convertToDouble();
            }
            case 16: {
                return this.convertToDecfloat(targetType, conversionMode);
            }
            case 17: {
                return this.convertToDate(provider);
            }
            case 18: {
                return this.convertToTime(targetType, provider, conversionMode);
            }
            case 19: {
                return this.convertToTimeTimeZone(targetType, provider, conversionMode);
            }
            case 20: {
                return this.convertToTimestamp(targetType, provider, conversionMode);
            }
            case 21: {
                return this.convertToTimestampTimeZone(targetType, provider, conversionMode);
            }
            case 22: 
            case 23: 
            case 28: {
                return this.convertToIntervalYearMonth(targetType, conversionMode, column);
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return this.convertToIntervalDayTime(targetType, conversionMode, column);
            }
            case 35: {
                return this.convertToJavaObject(targetType, conversionMode, column);
            }
            case 36: {
                return this.convertToEnum((ExtTypeInfoEnum)targetType.getExtTypeInfo(), provider);
            }
            case 37: {
                return this.convertToGeometry((ExtTypeInfoGeometry)targetType.getExtTypeInfo());
            }
            case 38: {
                return this.convertToJson(targetType, conversionMode, column);
            }
            case 39: {
                return this.convertToUuid();
            }
            case 40: {
                return this.convertToArray(targetType, provider, conversionMode, column);
            }
            case 41: {
                return this.convertToRow(targetType, provider, conversionMode, column);
            }
        }
        throw this.getDataConversionError(targetValueType);
    }

    public ValueChar convertToChar() {
        return this.convertToChar(TypeInfo.getTypeInfo(1), null, 0, null);
    }

    private ValueChar convertToChar(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        int length;
        int valueType = this.getValueType();
        switch (valueType) {
            case 7: 
            case 35: {
                throw this.getDataConversionError(targetType.getValueType());
            }
        }
        String s = this.getString();
        int newLength = length = s.length();
        if (conversionMode == 0) {
            while (newLength > 0 && s.charAt(newLength - 1) == ' ') {
                --newLength;
            }
        } else {
            int p = MathUtils.convertLongToInt(targetType.getPrecision());
            if (provider == null || provider.getMode().charPadding == Mode.CharPadding.ALWAYS) {
                if (newLength != p) {
                    if (newLength < p) {
                        return ValueChar.get(StringUtils.pad(s, p, null, true));
                    }
                    if (conversionMode == 1) {
                        newLength = p;
                    } else {
                        do {
                            if (s.charAt(--newLength) == ' ') continue;
                            throw this.getValueTooLongException(targetType, column);
                        } while (newLength > p);
                    }
                }
            } else {
                if (conversionMode == 1 && newLength > p) {
                    newLength = p;
                }
                while (newLength > 0 && s.charAt(newLength - 1) == ' ') {
                    --newLength;
                }
                if (conversionMode == 2 && newLength > p) {
                    throw this.getValueTooLongException(targetType, column);
                }
            }
        }
        if (length != newLength) {
            s = s.substring(0, newLength);
        } else if (valueType == 1) {
            return (ValueChar)this;
        }
        return ValueChar.get(s);
    }

    private Value convertToVarchar(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        int valueType = this.getValueType();
        switch (valueType) {
            case 7: 
            case 35: {
                throw this.getDataConversionError(targetType.getValueType());
            }
        }
        if (conversionMode != 0) {
            String s = this.getString();
            int p = MathUtils.convertLongToInt(targetType.getPrecision());
            if (s.length() > p) {
                if (conversionMode != 1) {
                    throw this.getValueTooLongException(targetType, column);
                }
                return ValueVarchar.get(s.substring(0, p), provider);
            }
        }
        return valueType == 2 ? this : ValueVarchar.get(this.getString(), provider);
    }

    private ValueClob convertToClob(TypeInfo targetType, int conversionMode, Object column) {
        ValueClob v;
        switch (this.getValueType()) {
            case 3: {
                v = (ValueClob)this;
                break;
            }
            case 35: {
                throw this.getDataConversionError(targetType.getValueType());
            }
            case 7: {
                LobData data = ((ValueBlob)this).lobData;
                if (data instanceof LobDataInMemory) {
                    byte[] small = ((LobDataInMemory)data).getSmall();
                    byte[] bytes = new String(small, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8);
                    if (Arrays.equals(bytes, small)) {
                        bytes = small;
                    }
                    v = ValueClob.createSmall(bytes);
                    break;
                }
                if (data instanceof LobDataDatabase) {
                    v = data.getDataHandler().getLobStorage().createClob(this.getReader(), -1L);
                    break;
                }
            }
            default: {
                v = ValueClob.createSmall(this.getString());
            }
        }
        if (conversionMode != 0) {
            if (conversionMode == 1) {
                v = v.convertPrecision(targetType.getPrecision());
            } else if (v.charLength() > targetType.getPrecision()) {
                throw v.getValueTooLongException(targetType, column);
            }
        }
        return v;
    }

    private Value convertToVarcharIgnoreCase(TypeInfo targetType, int conversionMode, Object column) {
        int valueType = this.getValueType();
        switch (valueType) {
            case 7: 
            case 35: {
                throw this.getDataConversionError(targetType.getValueType());
            }
        }
        if (conversionMode != 0) {
            String s = this.getString();
            int p = MathUtils.convertLongToInt(targetType.getPrecision());
            if (s.length() > p) {
                if (conversionMode != 1) {
                    throw this.getValueTooLongException(targetType, column);
                }
                return ValueVarcharIgnoreCase.get(s.substring(0, p));
            }
        }
        return valueType == 4 ? this : ValueVarcharIgnoreCase.get(this.getString());
    }

    private ValueBinary convertToBinary(TypeInfo targetType, int conversionMode, Object column) {
        int p;
        byte[] value;
        int length;
        ValueBinary v;
        if (this.getValueType() == 5) {
            v = (ValueBinary)this;
        } else {
            try {
                v = ValueBinary.getNoCopy(this.getBytesNoCopy());
            }
            catch (DbException e) {
                if (e.getErrorCode() == 22018) {
                    throw this.getDataConversionError(5);
                }
                throw e;
            }
        }
        if (conversionMode != 0 && (length = (value = v.getBytesNoCopy()).length) != (p = MathUtils.convertLongToInt(targetType.getPrecision()))) {
            if (conversionMode == 2 && length > p) {
                throw v.getValueTooLongException(targetType, column);
            }
            v = ValueBinary.getNoCopy(Arrays.copyOf(value, p));
        }
        return v;
    }

    private ValueVarbinary convertToVarbinary(TypeInfo targetType, int conversionMode, Object column) {
        ValueVarbinary v = this.getValueType() == 6 ? (ValueVarbinary)this : ValueVarbinary.getNoCopy(this.getBytesNoCopy());
        if (conversionMode != 0) {
            byte[] value = v.getBytesNoCopy();
            int length = value.length;
            int p = MathUtils.convertLongToInt(targetType.getPrecision());
            if (conversionMode == 1) {
                if (length > p) {
                    v = ValueVarbinary.getNoCopy(Arrays.copyOf(value, p));
                }
            } else if (length > p) {
                throw v.getValueTooLongException(targetType, column);
            }
        }
        return v;
    }

    private ValueBlob convertToBlob(TypeInfo targetType, int conversionMode, Object column) {
        ValueBlob v;
        switch (this.getValueType()) {
            case 7: {
                v = (ValueBlob)this;
                break;
            }
            case 3: {
                DataHandler handler = ((ValueLob)this).lobData.getDataHandler();
                if (handler != null) {
                    v = handler.getLobStorage().createBlob(this.getInputStream(), -1L);
                    break;
                }
            }
            default: {
                try {
                    v = ValueBlob.createSmall(this.getBytesNoCopy());
                    break;
                }
                catch (DbException e) {
                    if (e.getErrorCode() == 22018) {
                        throw this.getDataConversionError(7);
                    }
                    throw e;
                }
            }
        }
        if (conversionMode != 0) {
            if (conversionMode == 1) {
                v = v.convertPrecision(targetType.getPrecision());
            } else if (v.octetLength() > targetType.getPrecision()) {
                throw v.getValueTooLongException(targetType, column);
            }
        }
        return v;
    }

    public final ValueBoolean convertToBoolean() {
        switch (this.getValueType()) {
            case 8: {
                return (ValueBoolean)this;
            }
            case 1: 
            case 2: 
            case 4: {
                return ValueBoolean.get(this.getBoolean());
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return ValueBoolean.get(this.getSignum() != 0);
            }
            default: {
                throw this.getDataConversionError(8);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueTinyint convertToTinyint(Object column) {
        switch (this.getValueType()) {
            case 9: {
                return (ValueTinyint)this;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return ValueTinyint.get(this.getByte());
            }
            case 10: 
            case 11: 
            case 36: {
                return ValueTinyint.get(Value.convertToByte(this.getInt(), column));
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return ValueTinyint.get(Value.convertToByte(this.getLong(), column));
            }
            case 13: 
            case 16: {
                return ValueTinyint.get(Value.convertToByte(Value.convertToLong(this.getBigDecimal(), column), column));
            }
            case 14: 
            case 15: {
                return ValueTinyint.get(Value.convertToByte(Value.convertToLong(this.getDouble(), column), column));
            }
            case 5: 
            case 6: {
                byte[] bytes = this.getBytesNoCopy();
                if (bytes.length == 1) {
                    return ValueTinyint.get(bytes[0]);
                }
            }
            default: {
                throw this.getDataConversionError(9);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueSmallint convertToSmallint(Object column) {
        switch (this.getValueType()) {
            case 10: {
                return (ValueSmallint)this;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                return ValueSmallint.get(this.getShort());
            }
            case 11: 
            case 36: {
                return ValueSmallint.get(Value.convertToShort(this.getInt(), column));
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return ValueSmallint.get(Value.convertToShort(this.getLong(), column));
            }
            case 13: 
            case 16: {
                return ValueSmallint.get(Value.convertToShort(Value.convertToLong(this.getBigDecimal(), column), column));
            }
            case 14: 
            case 15: {
                return ValueSmallint.get(Value.convertToShort(Value.convertToLong(this.getDouble(), column), column));
            }
            case 5: 
            case 6: {
                byte[] bytes = this.getBytesNoCopy();
                if (bytes.length == 2) {
                    return ValueSmallint.get((short)((bytes[0] << 8) + (bytes[1] & 0xFF)));
                }
            }
            default: {
                throw this.getDataConversionError(10);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueInteger convertToInt(Object column) {
        switch (this.getValueType()) {
            case 11: {
                return (ValueInteger)this;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 36: {
                return ValueInteger.get(this.getInt());
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return ValueInteger.get(Value.convertToInt(this.getLong(), column));
            }
            case 13: 
            case 16: {
                return ValueInteger.get(Value.convertToInt(Value.convertToLong(this.getBigDecimal(), column), column));
            }
            case 14: 
            case 15: {
                return ValueInteger.get(Value.convertToInt(Value.convertToLong(this.getDouble(), column), column));
            }
            case 5: 
            case 6: {
                byte[] bytes = this.getBytesNoCopy();
                if (bytes.length == 4) {
                    return ValueInteger.get(Bits.INT_VH_BE.get(bytes, 0));
                }
            }
            default: {
                throw this.getDataConversionError(11);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueBigint convertToBigint(Object column) {
        switch (this.getValueType()) {
            case 12: {
                return (ValueBigint)this;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                return ValueBigint.get(this.getLong());
            }
            case 13: 
            case 16: {
                return ValueBigint.get(Value.convertToLong(this.getBigDecimal(), column));
            }
            case 14: 
            case 15: {
                return ValueBigint.get(Value.convertToLong(this.getDouble(), column));
            }
            case 5: 
            case 6: {
                byte[] bytes = this.getBytesNoCopy();
                if (bytes.length == 8) {
                    return ValueBigint.get(Bits.LONG_VH_BE.get(bytes, 0));
                }
            }
            default: {
                throw this.getDataConversionError(12);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    private ValueNumeric convertToNumeric(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        ValueNumeric v;
        switch (this.getValueType()) {
            case 13: {
                v = (ValueNumeric)this;
                break;
            }
            case 8: {
                v = this.getBoolean() ? ValueNumeric.ONE : ValueNumeric.ZERO;
                break;
            }
            default: {
                BigDecimal value = this.getBigDecimal();
                int targetScale = targetType.getScale();
                int scale = value.scale();
                if (scale < 0 || scale > 100000 || conversionMode != 0 && scale != targetScale && (scale >= targetScale || !provider.getMode().convertOnlyToSmallerScale)) {
                    value = ValueNumeric.setScale(value, targetScale);
                }
                if (conversionMode != 0 && (long)value.precision() > targetType.getPrecision() - (long)targetScale + (long)value.scale()) {
                    throw this.getValueTooLongException(targetType, column);
                }
                return ValueNumeric.get(value);
            }
            case 0: {
                throw DbException.getInternalError();
            }
        }
        if (conversionMode != 0) {
            BigDecimal bd;
            int targetScale = targetType.getScale();
            BigDecimal value = v.getBigDecimal();
            int scale = value.scale();
            if (!(scale == targetScale || scale < targetScale && provider.getMode().convertOnlyToSmallerScale)) {
                v = ValueNumeric.get(ValueNumeric.setScale(value, targetScale));
            }
            if ((long)(bd = v.getBigDecimal()).precision() > targetType.getPrecision() - (long)targetScale + (long)bd.scale()) {
                throw v.getValueTooLongException(targetType, column);
            }
        }
        return v;
    }

    public final ValueReal convertToReal() {
        switch (this.getValueType()) {
            case 14: {
                return (ValueReal)this;
            }
            case 8: {
                return this.getBoolean() ? ValueReal.ONE : ValueReal.ZERO;
            }
            default: {
                return ValueReal.get(this.getFloat());
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueDouble convertToDouble() {
        switch (this.getValueType()) {
            case 15: {
                return (ValueDouble)this;
            }
            case 8: {
                return this.getBoolean() ? ValueDouble.ONE : ValueDouble.ZERO;
            }
            default: {
                return ValueDouble.get(this.getDouble());
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    private ValueDecfloat convertToDecfloat(TypeInfo targetType, int conversionMode) {
        int targetPrecision;
        BigDecimal bd;
        int precision;
        ValueDecfloat v;
        switch (this.getValueType()) {
            case 16: {
                v = (ValueDecfloat)this;
                if (v.value != null) break;
                return v;
            }
            case 1: 
            case 2: 
            case 4: {
                String s = this.getString().trim();
                try {
                    v = ValueDecfloat.get(new BigDecimal(s));
                    break;
                }
                catch (NumberFormatException e) {
                    switch (s) {
                        case "-Infinity": {
                            return ValueDecfloat.NEGATIVE_INFINITY;
                        }
                        case "+Infinity": 
                        case "Infinity": {
                            return ValueDecfloat.POSITIVE_INFINITY;
                        }
                        case "NaN": 
                        case "+NaN": 
                        case "-NaN": {
                            return ValueDecfloat.NAN;
                        }
                    }
                    throw this.getDataConversionError(16);
                }
            }
            case 8: {
                v = this.getBoolean() ? ValueDecfloat.ONE : ValueDecfloat.ZERO;
                break;
            }
            case 14: {
                float value = this.getFloat();
                if (Float.isFinite(value)) {
                    v = ValueDecfloat.get(new BigDecimal(Float.toString(value)));
                    break;
                }
                if (value == Float.POSITIVE_INFINITY) {
                    return ValueDecfloat.POSITIVE_INFINITY;
                }
                if (value == Float.NEGATIVE_INFINITY) {
                    return ValueDecfloat.NEGATIVE_INFINITY;
                }
                return ValueDecfloat.NAN;
            }
            case 15: {
                double value = this.getDouble();
                if (Double.isFinite(value)) {
                    v = ValueDecfloat.get(new BigDecimal(Double.toString(value)));
                    break;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return ValueDecfloat.POSITIVE_INFINITY;
                }
                if (value == Double.NEGATIVE_INFINITY) {
                    return ValueDecfloat.NEGATIVE_INFINITY;
                }
                return ValueDecfloat.NAN;
            }
            default: {
                try {
                    v = ValueDecfloat.get(this.getBigDecimal());
                    break;
                }
                catch (DbException e) {
                    if (e.getErrorCode() == 22018) {
                        throw this.getDataConversionError(16);
                    }
                    throw e;
                }
            }
            case 0: {
                throw DbException.getInternalError();
            }
        }
        if (conversionMode != 0 && (precision = (bd = v.value).precision()) > (targetPrecision = (int)targetType.getPrecision())) {
            v = ValueDecfloat.get(bd.setScale(bd.scale() - precision + targetPrecision, RoundingMode.HALF_UP));
        }
        return v;
    }

    public final ValueDate convertToDate(CastDataProvider provider) {
        switch (this.getValueType()) {
            case 17: {
                return (ValueDate)this;
            }
            case 20: {
                return ValueDate.fromDateValue(((ValueTimestamp)this).getDateValue());
            }
            case 21: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)this;
                long timeNanos = ts.getTimeNanos();
                long epochSeconds = DateTimeUtils.getEpochSeconds(ts.getDateValue(), timeNanos, ts.getTimeZoneOffsetSeconds());
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromLocalSeconds(epochSeconds + (long)provider.currentTimeZone().getTimeZoneOffsetUTC(epochSeconds)));
            }
            case 1: 
            case 2: 
            case 4: {
                return ValueDate.parse(this.getString().trim());
            }
            default: {
                throw this.getDataConversionError(17);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    private ValueTime convertToTime(TypeInfo targetType, CastDataProvider provider, int conversionMode) {
        long n;
        long n2;
        int targetScale;
        ValueTime v;
        switch (this.getValueType()) {
            case 18: {
                v = (ValueTime)this;
                break;
            }
            case 19: {
                v = ValueTime.fromNanos(this.getLocalTimeNanos(provider));
                break;
            }
            case 20: {
                v = ValueTime.fromNanos(((ValueTimestamp)this).getTimeNanos());
                break;
            }
            case 21: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)this;
                long timeNanos = ts.getTimeNanos();
                long epochSeconds = DateTimeUtils.getEpochSeconds(ts.getDateValue(), timeNanos, ts.getTimeZoneOffsetSeconds());
                v = ValueTime.fromNanos(DateTimeUtils.nanosFromLocalSeconds(epochSeconds + (long)provider.currentTimeZone().getTimeZoneOffsetUTC(epochSeconds)) + timeNanos % 1000000000L);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                v = ValueTime.parse(this.getString().trim(), provider);
                break;
            }
            default: {
                throw this.getDataConversionError(18);
            }
        }
        if (conversionMode != 0 && (targetScale = targetType.getScale()) < 9 && (n2 = DateTimeUtils.convertScale(n = v.getNanos(), targetScale, 86400000000000L)) != n) {
            v = ValueTime.fromNanos(n2);
        }
        return v;
    }

    private ValueTimeTimeZone convertToTimeTimeZone(TypeInfo targetType, CastDataProvider provider, int conversionMode) {
        long n;
        long n2;
        int targetScale;
        ValueTimeTimeZone v;
        switch (this.getValueType()) {
            case 19: {
                v = (ValueTimeTimeZone)this;
                break;
            }
            case 18: {
                v = ValueTimeTimeZone.fromNanos(((ValueTime)this).getNanos(), provider.currentTimestamp().getTimeZoneOffsetSeconds());
                break;
            }
            case 20: {
                Value ts = (ValueTimestamp)this;
                long timeNanos = ((ValueTimestamp)ts).getTimeNanos();
                v = ValueTimeTimeZone.fromNanos(timeNanos, provider.currentTimeZone().getTimeZoneOffsetLocal(((ValueTimestamp)ts).getDateValue(), timeNanos));
                break;
            }
            case 21: {
                Value ts = (ValueTimestampTimeZone)this;
                v = ValueTimeTimeZone.fromNanos(((ValueTimestampTimeZone)ts).getTimeNanos(), ((ValueTimestampTimeZone)ts).getTimeZoneOffsetSeconds());
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                v = ValueTimeTimeZone.parse(this.getString().trim(), provider);
                break;
            }
            default: {
                throw this.getDataConversionError(19);
            }
        }
        if (conversionMode != 0 && (targetScale = targetType.getScale()) < 9 && (n2 = DateTimeUtils.convertScale(n = v.getNanos(), targetScale, 86400000000000L)) != n) {
            v = ValueTimeTimeZone.fromNanos(n2, v.getTimeZoneOffsetSeconds());
        }
        return v;
    }

    private ValueTimestamp convertToTimestamp(TypeInfo targetType, CastDataProvider provider, int conversionMode) {
        int targetScale;
        ValueTimestamp v;
        switch (this.getValueType()) {
            case 20: {
                v = (ValueTimestamp)this;
                break;
            }
            case 18: {
                v = ValueTimestamp.fromDateValueAndNanos(provider.currentTimestamp().getDateValue(), ((ValueTime)this).getNanos());
                break;
            }
            case 19: {
                v = ValueTimestamp.fromDateValueAndNanos(provider.currentTimestamp().getDateValue(), this.getLocalTimeNanos(provider));
                break;
            }
            case 17: {
                return ValueTimestamp.fromDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
            }
            case 21: {
                ValueTimestampTimeZone ts = (ValueTimestampTimeZone)this;
                long timeNanos = ts.getTimeNanos();
                long epochSeconds = DateTimeUtils.getEpochSeconds(ts.getDateValue(), timeNanos, ts.getTimeZoneOffsetSeconds());
                epochSeconds += (long)provider.currentTimeZone().getTimeZoneOffsetUTC(epochSeconds);
                v = ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromLocalSeconds(epochSeconds), DateTimeUtils.nanosFromLocalSeconds(epochSeconds) + timeNanos % 1000000000L);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                v = ValueTimestamp.parse(this.getString().trim(), provider);
                break;
            }
            default: {
                throw this.getDataConversionError(20);
            }
        }
        if (conversionMode != 0 && (targetScale = targetType.getScale()) < 9) {
            long dv = v.getDateValue();
            long n = v.getTimeNanos();
            long n2 = DateTimeUtils.convertScale(n, targetScale, dv == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
            if (n2 != n) {
                if (n2 >= 86400000000000L) {
                    n2 -= 86400000000000L;
                    dv = DateTimeUtils.incrementDateValue(dv);
                }
                v = ValueTimestamp.fromDateValueAndNanos(dv, n2);
            }
        }
        return v;
    }

    private long getLocalTimeNanos(CastDataProvider provider) {
        ValueTimeTimeZone ts = (ValueTimeTimeZone)this;
        int localOffset = provider.currentTimestamp().getTimeZoneOffsetSeconds();
        return DateTimeUtils.normalizeNanosOfDay(ts.getNanos() + (long)(localOffset - ts.getTimeZoneOffsetSeconds()) * 1000000000L);
    }

    private ValueTimestampTimeZone convertToTimestampTimeZone(TypeInfo targetType, CastDataProvider provider, int conversionMode) {
        int targetScale;
        ValueTimestampTimeZone v;
        switch (this.getValueType()) {
            case 21: {
                v = (ValueTimestampTimeZone)this;
                break;
            }
            case 18: {
                long dateValue = provider.currentTimestamp().getDateValue();
                long timeNanos = ((ValueTime)this).getNanos();
                v = ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, provider.currentTimeZone().getTimeZoneOffsetLocal(dateValue, timeNanos));
                break;
            }
            case 19: {
                ValueTimeTimeZone t = (ValueTimeTimeZone)this;
                v = ValueTimestampTimeZone.fromDateValueAndNanos(provider.currentTimestamp().getDateValue(), t.getNanos(), t.getTimeZoneOffsetSeconds());
                break;
            }
            case 17: {
                long dateValue = ((ValueDate)this).getDateValue();
                return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, 0L, provider.currentTimeZone().getTimeZoneOffsetLocal(dateValue, 0L));
            }
            case 20: {
                ValueTimestamp ts = (ValueTimestamp)this;
                long dateValue = ts.getDateValue();
                long timeNanos = ts.getTimeNanos();
                v = ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, provider.currentTimeZone().getTimeZoneOffsetLocal(dateValue, timeNanos));
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                v = ValueTimestampTimeZone.parse(this.getString().trim(), provider);
                break;
            }
            default: {
                throw this.getDataConversionError(21);
            }
        }
        if (conversionMode != 0 && (targetScale = targetType.getScale()) < 9) {
            long dv = v.getDateValue();
            long n = v.getTimeNanos();
            long n2 = DateTimeUtils.convertScale(n, targetScale, dv == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
            if (n2 != n) {
                if (n2 >= 86400000000000L) {
                    n2 -= 86400000000000L;
                    dv = DateTimeUtils.incrementDateValue(dv);
                }
                v = ValueTimestampTimeZone.fromDateValueAndNanos(dv, n2, v.getTimeZoneOffsetSeconds());
            }
        }
        return v;
    }

    private ValueInterval convertToIntervalYearMonth(TypeInfo targetType, int conversionMode, Object column) {
        ValueInterval v = this.convertToIntervalYearMonth(targetType.getValueType(), column);
        if (conversionMode != 0 && !v.checkPrecision(targetType.getPrecision())) {
            throw v.getValueTooLongException(targetType, column);
        }
        return v;
    }

    private ValueInterval convertToIntervalYearMonth(int targetType, Object column) {
        long leading;
        switch (this.getValueType()) {
            case 9: 
            case 10: 
            case 11: {
                leading = this.getInt();
                break;
            }
            case 12: {
                leading = this.getLong();
                break;
            }
            case 14: 
            case 15: {
                if (targetType == 28) {
                    return IntervalUtils.intervalFromAbsolute(IntervalQualifier.YEAR_TO_MONTH, this.getBigDecimal().multiply(BigDecimal.valueOf(12L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
                }
                leading = Value.convertToLong(this.getDouble(), column);
                break;
            }
            case 13: 
            case 16: {
                if (targetType == 28) {
                    return IntervalUtils.intervalFromAbsolute(IntervalQualifier.YEAR_TO_MONTH, this.getBigDecimal().multiply(BigDecimal.valueOf(12L)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
                }
                leading = Value.convertToLong(this.getBigDecimal(), column);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                String s = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(targetType - 22), s).convertTo(targetType);
                }
                catch (Exception e) {
                    throw DbException.get(22007, e, "INTERVAL", s);
                }
            }
            case 22: 
            case 23: 
            case 28: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(targetType - 22), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
            default: {
                throw this.getDataConversionError(targetType);
            }
        }
        boolean negative = false;
        if (leading < 0L) {
            negative = true;
            leading = -leading;
        }
        return ValueInterval.from(IntervalQualifier.valueOf(targetType - 22), negative, leading, 0L);
    }

    private ValueInterval convertToIntervalDayTime(TypeInfo targetType, int conversionMode, Object column) {
        ValueInterval v = this.convertToIntervalDayTime(targetType.getValueType(), column);
        if (conversionMode != 0) {
            v = v.setPrecisionAndScale(targetType, column);
        }
        return v;
    }

    private ValueInterval convertToIntervalDayTime(int targetType, Object column) {
        long leading;
        switch (this.getValueType()) {
            case 9: 
            case 10: 
            case 11: {
                leading = this.getInt();
                break;
            }
            case 12: {
                leading = this.getLong();
                break;
            }
            case 14: 
            case 15: {
                if (targetType > 26) {
                    return this.convertToIntervalDayTime(this.getBigDecimal(), targetType);
                }
                leading = Value.convertToLong(this.getDouble(), column);
                break;
            }
            case 13: 
            case 16: {
                if (targetType > 26) {
                    return this.convertToIntervalDayTime(this.getBigDecimal(), targetType);
                }
                leading = Value.convertToLong(this.getBigDecimal(), column);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                String s = this.getString();
                try {
                    return (ValueInterval)IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(targetType - 22), s).convertTo(targetType);
                }
                catch (Exception e) {
                    throw DbException.get(22007, e, "INTERVAL", s);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(targetType - 22), IntervalUtils.intervalToAbsolute((ValueInterval)this));
            }
            default: {
                throw this.getDataConversionError(targetType);
            }
        }
        boolean negative = false;
        if (leading < 0L) {
            negative = true;
            leading = -leading;
        }
        return ValueInterval.from(IntervalQualifier.valueOf(targetType - 22), negative, leading, 0L);
    }

    private ValueInterval convertToIntervalDayTime(BigDecimal bigDecimal, int targetType) {
        long multiplier;
        switch (targetType) {
            case 27: {
                multiplier = 1000000000L;
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                multiplier = 86400000000000L;
                break;
            }
            case 32: 
            case 33: {
                multiplier = 3600000000000L;
                break;
            }
            case 34: {
                multiplier = 60000000000L;
                break;
            }
            default: {
                throw this.getDataConversionError(targetType);
            }
        }
        return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(targetType - 22), bigDecimal.multiply(BigDecimal.valueOf(multiplier)).setScale(0, RoundingMode.HALF_UP).toBigInteger());
    }

    public final ValueJavaObject convertToJavaObject(TypeInfo targetType, int conversionMode, Object column) {
        ValueJavaObject v;
        switch (this.getValueType()) {
            case 35: {
                v = (ValueJavaObject)this;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                v = ValueJavaObject.getNoCopy(this.getBytesNoCopy());
                break;
            }
            default: {
                throw this.getDataConversionError(35);
            }
            case 0: {
                throw DbException.getInternalError();
            }
        }
        if (conversionMode != 0 && (long)v.getBytesNoCopy().length > targetType.getPrecision()) {
            throw v.getValueTooLongException(targetType, column);
        }
        return v;
    }

    public final ValueEnum convertToEnum(ExtTypeInfoEnum extTypeInfo, CastDataProvider provider) {
        switch (this.getValueType()) {
            case 36: {
                ValueEnum v = (ValueEnum)this;
                if (extTypeInfo.equals(v.getEnumerators())) {
                    return v;
                }
                return extTypeInfo.getValue(v.getString(), provider);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                return extTypeInfo.getValue(this.getInt(), provider);
            }
            case 1: 
            case 2: 
            case 4: {
                return extTypeInfo.getValue(this.getString(), provider);
            }
            default: {
                throw this.getDataConversionError(36);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    public final ValueGeometry convertToGeometry(ExtTypeInfoGeometry extTypeInfo) {
        ValueGeometry result;
        switch (this.getValueType()) {
            case 37: {
                result = (ValueGeometry)this;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                result = ValueGeometry.getFromEWKB(this.getBytesNoCopy());
                break;
            }
            case 38: {
                Integer s;
                int srid = 0;
                if (extTypeInfo != null && (s = extTypeInfo.getSrid()) != null) {
                    srid = s;
                }
                try {
                    result = ValueGeometry.get(GeoJsonUtils.geoJsonToEwkb(this.getBytesNoCopy(), srid));
                    break;
                }
                catch (RuntimeException ex) {
                    throw DbException.get(22018, this.getTraceSQL());
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                result = ValueGeometry.get(this.getString());
                break;
            }
            default: {
                throw this.getDataConversionError(37);
            }
            case 0: {
                throw DbException.getInternalError();
            }
        }
        if (extTypeInfo != null) {
            int type = extTypeInfo.getType();
            Integer srid = extTypeInfo.getSrid();
            if (type != 0 && result.getTypeAndDimensionSystem() != type || srid != null && result.getSRID() != srid.intValue()) {
                StringBuilder builder = ExtTypeInfoGeometry.toSQL(new StringBuilder(), result.getTypeAndDimensionSystem(), result.getSRID()).append(" -> ");
                extTypeInfo.getSQL(builder, 3);
                throw DbException.get(22018, builder.toString());
            }
        }
        return result;
    }

    public ValueJson convertToJson(TypeInfo targetType, int conversionMode, Object column) {
        ValueJson v;
        switch (this.getValueType()) {
            case 38: {
                v = (ValueJson)this;
                break;
            }
            case 8: {
                v = ValueJson.get(this.getBoolean());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                v = ValueJson.get(this.getInt());
                break;
            }
            case 12: {
                v = ValueJson.get(this.getLong());
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                v = ValueJson.get(this.getBigDecimal());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                v = ValueJson.fromJson(this.getBytesNoCopy());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 18: 
            case 19: 
            case 36: 
            case 39: {
                v = ValueJson.get(this.getString());
                break;
            }
            case 20: {
                v = ValueJson.get(((ValueTimestamp)this).getISOString());
                break;
            }
            case 21: {
                v = ValueJson.get(((ValueTimestampTimeZone)this).getISOString());
                break;
            }
            case 37: {
                ValueGeometry vg = (ValueGeometry)this;
                v = ValueJson.getInternal(GeoJsonUtils.ewkbToGeoJson(vg.getBytesNoCopy(), vg.getDimensionSystem()));
                break;
            }
            case 40: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(91);
                Value[] valueArray = ((ValueArray)this).getList();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value e = valueArray[n2];
                    JsonConstructorUtils.jsonArrayAppend(baos, e, 0);
                    ++n2;
                }
                baos.write(93);
                v = ValueJson.getInternal(baos.toByteArray());
                break;
            }
            default: {
                throw this.getDataConversionError(38);
            }
        }
        if (conversionMode != 0 && (long)v.getBytesNoCopy().length > targetType.getPrecision()) {
            throw v.getValueTooLongException(targetType, column);
        }
        return v;
    }

    public final ValueUuid convertToUuid() {
        switch (this.getValueType()) {
            case 39: {
                return (ValueUuid)this;
            }
            case 5: 
            case 6: {
                return ValueUuid.get(this.getBytesNoCopy());
            }
            case 35: {
                return JdbcUtils.deserializeUuid(this.getBytesNoCopy());
            }
            case 1: 
            case 2: 
            case 4: {
                return ValueUuid.get(this.getString());
            }
            default: {
                throw this.getDataConversionError(39);
            }
            case 0: 
        }
        throw DbException.getInternalError();
    }

    private ValueArray convertToArray(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        Value[] values;
        ValueArray v;
        TypeInfo componentType = (TypeInfo)targetType.getExtTypeInfo();
        int valueType = this.getValueType();
        if (valueType == 40) {
            v = (ValueArray)this;
        } else {
            Value[] a;
            switch (valueType) {
                case 7: {
                    a = new Value[]{ValueVarbinary.get(this.getBytesNoCopy())};
                    break;
                }
                case 3: {
                    a = new Value[]{ValueVarchar.get(this.getString())};
                    break;
                }
                default: {
                    a = new Value[]{this};
                }
            }
            v = ValueArray.get(a, provider);
        }
        if (componentType != null) {
            values = v.getList();
            int length = values.length;
            int i = 0;
            while (i < length) {
                Value v1 = values[i];
                Value v2 = v1.convertTo(componentType, provider, conversionMode, column);
                if (v1 != v2) {
                    Value[] newValues = new Value[length];
                    System.arraycopy(values, 0, newValues, 0, i);
                    newValues[i] = v2;
                    while (++i < length) {
                        newValues[i] = values[i].convertTo(componentType, provider, conversionMode, column);
                    }
                    v = ValueArray.get(componentType, newValues, provider);
                    break;
                }
                ++i;
            }
        }
        if (conversionMode != 0) {
            values = v.getList();
            int cardinality = values.length;
            if (conversionMode == 1) {
                int p = MathUtils.convertLongToInt(targetType.getPrecision());
                if (cardinality > p) {
                    v = ValueArray.get(v.getComponentType(), Arrays.copyOf(values, p), provider);
                }
            } else if ((long)cardinality > targetType.getPrecision()) {
                throw v.getValueTooLongException(targetType, column);
            }
        }
        return v;
    }

    private Value convertToRow(TypeInfo targetType, CastDataProvider provider, int conversionMode, Object column) {
        ValueRow v = this.getValueType() == 41 ? (ValueRow)this : ValueRow.get(new Value[]{this});
        ExtTypeInfoRow ext = (ExtTypeInfoRow)targetType.getExtTypeInfo();
        if (ext != null) {
            Set<Map.Entry<String, TypeInfo>> fields;
            Value[] values = v.getList();
            int length = values.length;
            if (length != (fields = ext.getFields()).size()) {
                throw this.getDataConversionError(targetType);
            }
            Iterator<Map.Entry<String, TypeInfo>> iter = fields.iterator();
            int i = 0;
            while (i < length) {
                Value v1 = values[i];
                TypeInfo componentType = iter.next().getValue();
                Value v2 = v1.convertTo(componentType, provider, conversionMode, column);
                if (v1 != v2) {
                    Value[] newValues = new Value[length];
                    System.arraycopy(values, 0, newValues, 0, i);
                    newValues[i] = v2;
                    while (++i < length) {
                        newValues[i] = values[i].convertTo(componentType, provider, conversionMode, column);
                    }
                    v = ValueRow.get(targetType, newValues);
                    break;
                }
                ++i;
            }
        }
        return v;
    }

    final DbException getDataConversionError(int targetType) {
        throw DbException.get(22018, Value.getTypeName(this.getValueType()) + " to " + Value.getTypeName(targetType));
    }

    final DbException getDataConversionError(TypeInfo targetType) {
        throw DbException.get(22018, Value.getTypeName(this.getValueType()) + " to " + targetType.getTraceSQL());
    }

    final DbException getValueTooLongException(TypeInfo targetType, Object column) {
        StringBuilder builder = new StringBuilder();
        if (column != null) {
            builder.append(column).append(' ');
        }
        targetType.getSQL(builder, 3);
        return DbException.getValueTooLongException(builder.toString(), this.getTraceSQL(), this.getType().getPrecision());
    }

    public abstract int compareTypeSafe(Value var1, CompareMode var2, CastDataProvider var3);

    public final int compareTo(Value v, CastDataProvider provider, CompareMode compareMode) {
        if (this == v) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return -1;
        }
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        return Value.compareToNotNullable(this, v, provider, compareMode);
    }

    private static int compareToNotNullable(Value l, Value r, CastDataProvider provider, CompareMode compareMode) {
        int rightType;
        int leftType = l.getValueType();
        if (leftType != (rightType = r.getValueType()) || leftType == 36) {
            int dataType = Value.getHigherOrderNonNull(leftType, rightType);
            if (DataType.isNumericType(dataType)) {
                return Value.compareNumeric(l, r, leftType, rightType, dataType);
            }
            if (dataType == 36) {
                ExtTypeInfoEnum enumerators = ExtTypeInfoEnum.getEnumeratorsForBinaryOperation(l, r);
                return Integer.compare(l.convertToEnum(enumerators, provider).getInt(), r.convertToEnum(enumerators, provider).getInt());
            }
            if (dataType <= 7) {
                if (dataType <= 3) {
                    if (leftType == 1 || rightType == 1) {
                        dataType = 1;
                    }
                } else if (dataType >= 5 && (leftType == 5 || rightType == 5)) {
                    dataType = 5;
                }
            }
            l = l.convertTo(dataType, provider);
            r = r.convertTo(dataType, provider);
        }
        return l.compareTypeSafe(r, compareMode, provider);
    }

    private static int compareNumeric(Value l, Value r, int leftType, int rightType, int dataType) {
        if (DataType.isNumericType(leftType) && DataType.isNumericType(rightType)) {
            switch (dataType) {
                case 9: 
                case 10: 
                case 11: {
                    return Integer.compare(l.getInt(), r.getInt());
                }
                case 12: {
                    return Long.compare(l.getLong(), r.getLong());
                }
                case 13: {
                    return l.getBigDecimal().compareTo(r.getBigDecimal());
                }
                case 14: {
                    return Float.compare(l.getFloat(), r.getFloat());
                }
                case 15: {
                    return Double.compare(l.getDouble(), r.getDouble());
                }
            }
        }
        return l.convertToDecfloat(null, 0).compareTypeSafe(r.convertToDecfloat(null, 0), null, null);
    }

    public int compareWithNull(Value v, boolean forEquality, CastDataProvider provider, CompareMode compareMode) {
        if (this == ValueNull.INSTANCE || v == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        return Value.compareToNotNullable(this, v, provider, compareMode);
    }

    public boolean containsNull() {
        return false;
    }

    public Value getValueWithFirstNull(Value v) {
        return this == ValueNull.INSTANCE ? (v == ValueNull.INSTANCE ? null : ValueNull.INSTANCE) : (v == ValueNull.INSTANCE ? ValueNull.INSTANCE : this.getValueWithFirstNullImpl(v));
    }

    Value getValueWithFirstNullImpl(Value v) {
        return this;
    }

    private static byte convertToByte(long x, Object column) {
        if (x > 127L || x < -128L) {
            throw DbException.get(22004, Long.toString(x), Value.getColumnName(column));
        }
        return (byte)x;
    }

    private static short convertToShort(long x, Object column) {
        if (x > 32767L || x < -32768L) {
            throw DbException.get(22004, Long.toString(x), Value.getColumnName(column));
        }
        return (short)x;
    }

    public static int convertToInt(long x, Object column) {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw DbException.get(22004, Long.toString(x), Value.getColumnName(column));
        }
        return (int)x;
    }

    private static long convertToLong(double x, Object column) {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw DbException.get(22004, Double.toString(x), Value.getColumnName(column));
        }
        return Math.round(x);
    }

    private static long convertToLong(BigDecimal x, Object column) {
        if (x.compareTo(MAX_LONG_DECIMAL) > 0 || x.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw DbException.get(22004, x.toString(), Value.getColumnName(column));
        }
        return x.setScale(0, RoundingMode.HALF_UP).longValue();
    }

    private static String getColumnName(Object column) {
        return column == null ? "" : column.toString();
    }

    public String toString() {
        return this.getTraceSQL();
    }

    protected final DbException getUnsupportedExceptionForOperation(String op) {
        return DbException.getUnsupportedException(Value.getTypeName(this.getValueType()) + " " + op);
    }

    public long charLength() {
        return this.getString().length();
    }

    public long octetLength() {
        return this.getBytesNoCopy().length;
    }

    public final boolean isTrue() {
        return this != ValueNull.INSTANCE ? this.getBoolean() : false;
    }

    public final boolean isFalse() {
        return this != ValueNull.INSTANCE && !this.getBoolean();
    }
}

