/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeReader;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataFetchOnDemand;
import org.h2.value.lob.LobDataFile;
import org.h2.value.lob.LobDataInMemory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueClob
extends ValueLob {
    public static ValueClob createSmall(byte[] data) {
        return new ValueClob(new LobDataInMemory(data), data.length, new String(data, StandardCharsets.UTF_8).length());
    }

    public static ValueClob createSmall(byte[] data, long charLength) {
        return new ValueClob(new LobDataInMemory(data), data.length, charLength);
    }

    public static ValueClob createSmall(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return new ValueClob(new LobDataInMemory(bytes), bytes.length, string.length());
    }

    public static ValueClob createTempClob(Reader in, long length, DataHandler handler) {
        if (length >= 0L) {
            try {
                in = new RangeReader(in, 0L, length);
            }
            catch (IOException e) {
                throw DbException.convert(e);
            }
        }
        BufferedReader reader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in, 4096);
        try {
            char[] buff;
            int len;
            long remaining = Long.MAX_VALUE;
            if (length >= 0L && length < remaining) {
                remaining = length;
            }
            if ((len = ValueLob.getBufferSize(handler, remaining)) >= Integer.MAX_VALUE) {
                String data = IOUtils.readStringAndClose(reader, -1);
                buff = data.toCharArray();
                len = buff.length;
            } else {
                buff = new char[len];
                reader.mark(len);
                len = IOUtils.readFully(reader, buff, len);
            }
            if (len <= handler.getMaxLengthInplaceLob()) {
                return ValueClob.createSmall(new String(buff, 0, len));
            }
            reader.reset();
            return ValueClob.createTemporary(handler, reader, remaining);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private static ValueClob createTemporary(DataHandler handler, Reader in, long remaining) throws IOException {
        String fileName = ValueLob.createTempLobFileName(handler);
        FileStore tempFile = handler.openFile(fileName, "rw", false);
        tempFile.autoDelete();
        long octetLength = 0L;
        long charLength = 0L;
        Throwable throwable = null;
        Object var11_9 = null;
        try (FileStoreOutputStream out = new FileStoreOutputStream(tempFile, null);){
            char[] buff = new char[4096];
            while (true) {
                int len = ValueLob.getBufferSize(handler, remaining);
                if ((len = IOUtils.readFully(in, buff, len)) == 0) {
                    break;
                }
                byte[] data = new String(buff, 0, len).getBytes(StandardCharsets.UTF_8);
                out.write(data);
                octetLength += (long)data.length;
                charLength += (long)len;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new ValueClob(new LobDataFile(handler, fileName, tempFile), octetLength, charLength);
    }

    public ValueClob(LobData lobData, long octetLength, long charLength) {
        super(lobData, octetLength, charLength);
    }

    @Override
    public int getValueType() {
        return 3;
    }

    @Override
    public String getString() {
        if (this.charLength > 1000000000L) {
            throw this.getStringTooLong(this.charLength);
        }
        if (this.lobData instanceof LobDataInMemory) {
            return new String(((LobDataInMemory)this.lobData).getSmall(), StandardCharsets.UTF_8);
        }
        return this.readString((int)this.charLength);
    }

    @Override
    byte[] getBytesInternal() {
        long p = this.octetLength;
        if (p >= 0L) {
            if (p > 1000000000L) {
                throw this.getBinaryTooLong(p);
            }
            return this.readBytes((int)p);
        }
        if (this.octetLength > 1000000000L) {
            throw this.getBinaryTooLong(this.octetLength());
        }
        byte[] b = this.readBytes(Integer.MAX_VALUE);
        this.octetLength = p = (long)b.length;
        if (p > 1000000000L) {
            throw this.getBinaryTooLong(p);
        }
        return b;
    }

    @Override
    public InputStream getInputStream() {
        return this.lobData.getInputStream(-1L);
    }

    @Override
    public InputStream getInputStream(long oneBasedOffset, long length) {
        return ValueClob.rangeInputStream(this.lobData.getInputStream(-1L), oneBasedOffset, length, -1L);
    }

    @Override
    public Reader getReader(long oneBasedOffset, long length) {
        return ValueClob.rangeReader(this.getReader(), oneBasedOffset, length, this.charLength);
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        if (v == this) {
            return 0;
        }
        ValueClob v2 = (ValueClob)v;
        LobData lobData = this.lobData;
        LobData lobData2 = v2.lobData;
        if (lobData.getClass() == lobData2.getClass()) {
            if (lobData instanceof LobDataInMemory) {
                return Integer.signum(this.getString().compareTo(v2.getString()));
            }
            if (lobData instanceof LobDataDatabase ? ((LobDataDatabase)lobData).getLobId() == ((LobDataDatabase)lobData2).getLobId() : lobData instanceof LobDataFetchOnDemand && ((LobDataFetchOnDemand)lobData).getLobId() == ((LobDataFetchOnDemand)lobData2).getLobId()) {
                return 0;
            }
        }
        return ValueClob.compare(this, v2);
    }

    /*
     * Exception decompiling
     */
    private static int compare(ValueClob v1, ValueClob v2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (!((sqlFlags & 2) == 0 || this.lobData instanceof LobDataInMemory && this.charLength <= SysProperties.MAX_TRACE_DATA_LENGTH)) {
            builder.append("SPACE(").append(this.charLength);
            this.formatLobDataComment(builder);
        } else if ((sqlFlags & 6) == 0) {
            StringUtils.quoteStringSQL(builder.append("CAST("), this.getString()).append(" AS CHARACTER LARGE OBJECT(").append(this.charLength).append("))");
        } else {
            StringUtils.quoteStringSQL(builder, this.getString());
        }
        return builder;
    }

    ValueClob convertPrecision(long precision) {
        ValueClob lob;
        if (this.charLength <= precision) {
            return this;
        }
        DataHandler handler = this.lobData.getDataHandler();
        if (handler != null) {
            lob = ValueClob.createTempClob(this.getReader(), precision, handler);
        } else {
            try {
                lob = ValueClob.createSmall(IOUtils.readStringAndClose(this.getReader(), MathUtils.convertLongToInt(precision)));
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        return lob;
    }

    @Override
    public ValueLob copy(DataHandler database, int tableId) {
        if (this.lobData instanceof LobDataInMemory) {
            byte[] small = ((LobDataInMemory)this.lobData).getSmall();
            if (small.length > database.getMaxLengthInplaceLob()) {
                LobStorageInterface s = database.getLobStorage();
                ValueClob v = s.createClob(this.getReader(), this.charLength);
                ValueLob v2 = v.copy(database, tableId);
                v.remove();
                return v2;
            }
            return this;
        }
        if (this.lobData instanceof LobDataDatabase) {
            return database.getLobStorage().copyLob(this, tableId);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long charLength() {
        return this.charLength;
    }

    @Override
    public long octetLength() {
        long p = this.octetLength;
        if (p < 0L) {
            if (this.lobData instanceof LobDataInMemory) {
                p = ((LobDataInMemory)this.lobData).getSmall().length;
            } else {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (InputStream is = this.getInputStream();){
                        p = 0L;
                        while (true) {
                            p += is.skip(Long.MAX_VALUE);
                            if (is.read() < 0) {
                                break;
                            }
                            ++p;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw DbException.convertIOException(e, null);
                }
            }
            this.octetLength = p;
        }
        return p;
    }
}

