/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueDate
extends Value {
    public static final int PRECISION = 10;
    private final long dateValue;

    private ValueDate(long dateValue) {
        if (dateValue < -511999999967L || dateValue > 512000000415L) {
            throw new IllegalArgumentException("dateValue out of range " + dateValue);
        }
        this.dateValue = dateValue;
    }

    public static ValueDate fromDateValue(long dateValue) {
        return (ValueDate)Value.cache(new ValueDate(dateValue));
    }

    public static ValueDate parse(String s) {
        try {
            return ValueDate.fromDateValue(DateTimeUtils.parseDateValue(s, 0, s.length()));
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "DATE", s);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_DATE;
    }

    @Override
    public int getValueType() {
        return 17;
    }

    @Override
    public String getString() {
        return DateTimeUtils.appendDate(new StringBuilder(10), this.dateValue).toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return DateTimeUtils.appendDate(builder.append("DATE '"), this.dateValue).append('\'');
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Long.compare(this.dateValue, ((ValueDate)o).dateValue);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ValueDate && this.dateValue == ((ValueDate)other).dateValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32);
    }
}

