/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.h2.api.Interval;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueInterval
extends Value {
    public static final int DEFAULT_PRECISION = 2;
    public static final int MAXIMUM_PRECISION = 18;
    public static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private static final long[] MULTIPLIERS = new long[]{1000000000L, 12L, 24L, 1440L, 86400000000000L, 60L, 3600000000000L, 60000000000L};
    private final int valueType;
    private final boolean negative;
    private final long leading;
    private final long remaining;

    public static ValueInterval from(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        negative = IntervalUtils.validateInterval(qualifier, negative, leading, remaining);
        return (ValueInterval)Value.cache(new ValueInterval(qualifier.ordinal() + 22, negative, leading, remaining));
    }

    public static int getDisplaySize(int type, int precision, int scale) {
        switch (type) {
            case 22: 
            case 25: {
                return 17 + precision;
            }
            case 23: {
                return 18 + precision;
            }
            case 24: {
                return 16 + precision;
            }
            case 26: {
                return 19 + precision;
            }
            case 27: {
                return scale > 0 ? 20 + precision + scale : 19 + precision;
            }
            case 28: {
                return 29 + precision;
            }
            case 29: {
                return 27 + precision;
            }
            case 30: {
                return 32 + precision;
            }
            case 31: {
                return scale > 0 ? 36 + precision + scale : 35 + precision;
            }
            case 32: {
                return 30 + precision;
            }
            case 33: {
                return scale > 0 ? 34 + precision + scale : 33 + precision;
            }
            case 34: {
                return scale > 0 ? 33 + precision + scale : 32 + precision;
            }
        }
        throw DbException.getUnsupportedException(Integer.toString(type));
    }

    private ValueInterval(int type, boolean negative, long leading, long remaining) {
        this.valueType = type;
        this.negative = negative;
        this.leading = leading;
        this.remaining = remaining;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return IntervalUtils.appendInterval(builder, this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.getTypeInfo(this.valueType);
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public int getMemory() {
        return 48;
    }

    boolean checkPrecision(long prec) {
        if (prec < 18L) {
            long l = this.leading;
            long p = 1L;
            long precision = 0L;
            while (l >= p) {
                if (++precision > prec) {
                    return false;
                }
                p *= 10L;
            }
        }
        return true;
    }

    ValueInterval setPrecisionAndScale(TypeInfo targetType, Object column) {
        ValueInterval v;
        block10: {
            int targetScale = targetType.getScale();
            v = this;
            if (targetScale < 9) {
                long range;
                switch (this.valueType) {
                    case 27: {
                        range = 1000000000L;
                        break;
                    }
                    case 31: {
                        range = 86400000000000L;
                        break;
                    }
                    case 33: {
                        range = 3600000000000L;
                        break;
                    }
                    case 34: {
                        range = 60000000000L;
                        break;
                    }
                    default: {
                        break block10;
                    }
                }
                long l = this.leading;
                long r = DateTimeUtils.convertScale(this.remaining, targetScale, l == 999999999999999999L ? range : Long.MAX_VALUE);
                if (r != this.remaining) {
                    if (r >= range) {
                        ++l;
                        r -= range;
                    }
                    v = ValueInterval.from(v.getQualifier(), v.isNegative(), l, r);
                }
            }
        }
        if (!v.checkPrecision(targetType.getPrecision())) {
            throw v.getValueTooLongException(targetType, column);
        }
        return v;
    }

    @Override
    public String getString() {
        return IntervalUtils.appendInterval(new StringBuilder(), this.getQualifier(), this.negative, this.leading, this.remaining).toString();
    }

    @Override
    public long getLong() {
        long l = this.leading;
        if (this.valueType >= 27 && this.remaining != 0L && this.remaining >= MULTIPLIERS[this.valueType - 27] >> 1) {
            ++l;
        }
        return this.negative ? -l : l;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.valueType < 27 || this.remaining == 0L) {
            return BigDecimal.valueOf(this.negative ? -this.leading : this.leading);
        }
        BigDecimal m = BigDecimal.valueOf(MULTIPLIERS[this.valueType - 27]);
        BigDecimal bd = BigDecimal.valueOf(this.leading).add(BigDecimal.valueOf(this.remaining).divide(m, m.precision(), RoundingMode.HALF_DOWN)).stripTrailingZeros();
        return this.negative ? bd.negate() : bd;
    }

    @Override
    public float getFloat() {
        if (this.valueType < 27 || this.remaining == 0L) {
            return this.negative ? -this.leading : this.leading;
        }
        return this.getBigDecimal().floatValue();
    }

    @Override
    public double getDouble() {
        if (this.valueType < 27 || this.remaining == 0L) {
            return this.negative ? -this.leading : this.leading;
        }
        return this.getBigDecimal().doubleValue();
    }

    public Interval getInterval() {
        return new Interval(this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    public IntervalQualifier getQualifier() {
        return IntervalQualifier.valueOf(this.valueType - 22);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.valueType;
        result = 31 * result + (this.negative ? 1231 : 1237);
        result = 31 * result + (int)(this.leading ^ this.leading >>> 32);
        result = 31 * result + (int)(this.remaining ^ this.remaining >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueInterval)) {
            return false;
        }
        ValueInterval other = (ValueInterval)obj;
        return this.valueType == other.valueType && this.negative == other.negative && this.leading == other.leading && this.remaining == other.remaining;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        ValueInterval other = (ValueInterval)v;
        if (this.negative != other.negative) {
            return this.negative ? -1 : 1;
        }
        int cmp = Long.compare(this.leading, other.leading);
        if (cmp == 0) {
            cmp = Long.compare(this.remaining, other.remaining);
        }
        return this.negative ? -cmp : cmp;
    }

    @Override
    public int getSignum() {
        return this.negative ? -1 : (this.leading == 0L && this.remaining == 0L ? 0 : 1);
    }

    @Override
    public Value add(Value v) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).add(IntervalUtils.intervalToAbsolute((ValueInterval)v)));
    }

    @Override
    public Value subtract(Value v) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).subtract(IntervalUtils.intervalToAbsolute((ValueInterval)v)));
    }

    @Override
    public Value negate() {
        if (this.leading == 0L && this.remaining == 0L) {
            return this;
        }
        return Value.cache(new ValueInterval(this.valueType, !this.negative, this.leading, this.remaining));
    }
}

