/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.util.json.JSONBoolean;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONItemType;
import org.h2.util.json.JSONNull;
import org.h2.util.json.JSONNumber;
import org.h2.util.json.JSONStringSource;
import org.h2.util.json.JSONStringTarget;
import org.h2.util.json.JSONValue;
import org.h2.util.json.JSONValueTarget;
import org.h2.value.TypeInfo;
import org.h2.value.ValueBytesBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueJson
extends ValueBytesBase {
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] TRUE_BYTES = "true".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] FALSE_BYTES = "false".getBytes(StandardCharsets.ISO_8859_1);
    public static final ValueJson NULL = new ValueJson(NULL_BYTES);
    public static final ValueJson TRUE = new ValueJson(TRUE_BYTES);
    public static final ValueJson FALSE = new ValueJson(FALSE_BYTES);
    public static final ValueJson ZERO = new ValueJson(new byte[]{48});
    private volatile SoftReference<JSONValue> decompositionRef;

    private ValueJson(byte[] value) {
        super(value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        String s = JSONBytesSource.parse(this.value, new JSONStringTarget(true));
        return builder.append("JSON '").append(s).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JSON;
    }

    @Override
    public int getValueType() {
        return 38;
    }

    @Override
    public String getString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public JSONItemType getItemType() {
        switch (this.value[0]) {
            case 91: {
                return JSONItemType.ARRAY;
            }
            case 123: {
                return JSONItemType.OBJECT;
            }
        }
        return JSONItemType.SCALAR;
    }

    public JSONValue getDecomposition() {
        JSONValue decomposition;
        SoftReference<JSONValue> decompositionRef = this.decompositionRef;
        if (decompositionRef == null || (decomposition = decompositionRef.get()) == null) {
            decomposition = JSONBytesSource.parse(this.value, new JSONValueTarget());
            this.decompositionRef = new SoftReference<JSONValue>(decomposition);
        }
        return decomposition;
    }

    public static ValueJson fromJson(String s) {
        byte[] bytes;
        try {
            bytes = JSONStringSource.normalize(s);
        }
        catch (RuntimeException ex) {
            if (s.length() > 80) {
                s = new StringBuilder(83).append(s, 0, 80).append("...").toString();
            }
            throw DbException.get(22018, s);
        }
        return ValueJson.getInternal(bytes);
    }

    public static ValueJson fromJson(byte[] bytes) {
        try {
            bytes = JSONBytesSource.normalize(bytes);
        }
        catch (RuntimeException ex) {
            StringBuilder builder = new StringBuilder().append("X'");
            if (bytes.length > 40) {
                StringUtils.convertBytesToHex(builder, bytes, 40).append("...");
            } else {
                StringUtils.convertBytesToHex(builder, bytes);
            }
            throw DbException.get(22018, builder.append('\'').toString());
        }
        return ValueJson.getInternal(bytes);
    }

    public static ValueJson fromJson(JSONValue value) {
        if (value instanceof JSONNull) {
            return NULL;
        }
        if (value instanceof JSONBoolean) {
            return ((JSONBoolean)value).getBoolean() ? TRUE : FALSE;
        }
        if (value instanceof JSONNumber && ((JSONNumber)value).getBigDecimal().equals(BigDecimal.ZERO)) {
            return ZERO;
        }
        JSONByteArrayTarget target = new JSONByteArrayTarget();
        value.addTo(target);
        ValueJson v = new ValueJson(target.getResult());
        v.decompositionRef = new SoftReference<JSONValue>(value);
        return v;
    }

    public static ValueJson get(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static ValueJson get(int number) {
        return number != 0 ? ValueJson.getNumber(Integer.toString(number)) : ZERO;
    }

    public static ValueJson get(long number) {
        return number != 0L ? ValueJson.getNumber(Long.toString(number)) : ZERO;
    }

    public static ValueJson get(BigDecimal number) {
        if (number.signum() == 0 && number.scale() == 0) {
            return ZERO;
        }
        String s = number.toString();
        int index = s.indexOf(69);
        if (index >= 0 && s.charAt(++index) == '+') {
            int length = s.length();
            s = new StringBuilder(length - 1).append(s, 0, index).append(s, index + 1, length).toString();
        }
        return ValueJson.getNumber(s);
    }

    public static ValueJson get(String string) {
        return new ValueJson(JSONByteArrayTarget.encodeString(new ByteArrayOutputStream(string.length() + 2), string).toByteArray());
    }

    public static ValueJson getInternal(byte[] bytes) {
        int l = bytes.length;
        switch (l) {
            case 1: {
                if (bytes[0] != 48) break;
                return ZERO;
            }
            case 4: {
                if (Arrays.equals(TRUE_BYTES, bytes)) {
                    return TRUE;
                }
                if (!Arrays.equals(NULL_BYTES, bytes)) break;
                return NULL;
            }
            case 5: {
                if (!Arrays.equals(FALSE_BYTES, bytes)) break;
                return FALSE;
            }
        }
        return new ValueJson(bytes);
    }

    private static ValueJson getNumber(String s) {
        return new ValueJson(s.getBytes(StandardCharsets.ISO_8859_1));
    }

    @Override
    public int getMemory() {
        return this.value.length + 96;
    }
}

