/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeInputStream;
import org.h2.store.RangeReader;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataFetchOnDemand;
import org.h2.value.lob.LobDataInMemory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ValueLob
extends Value {
    static final int BLOCK_COMPARISON_SIZE = 512;
    private TypeInfo type;
    final LobData lobData;
    long octetLength;
    long charLength;
    private int hash;

    private static void rangeCheckUnknown(long zeroBasedOffset, long length) {
        if (zeroBasedOffset < 0L) {
            throw DbException.getInvalidValueException("offset", zeroBasedOffset + 1L);
        }
        if (length < 0L) {
            throw DbException.getInvalidValueException("length", length);
        }
    }

    protected static InputStream rangeInputStream(InputStream inputStream, long oneBasedOffset, long length, long dataSize) {
        if (dataSize > 0L) {
            ValueLob.rangeCheck(oneBasedOffset - 1L, length, dataSize);
        } else {
            ValueLob.rangeCheckUnknown(oneBasedOffset - 1L, length);
        }
        try {
            return new RangeInputStream(inputStream, oneBasedOffset - 1L, length);
        }
        catch (IOException e) {
            throw DbException.getInvalidValueException("offset", oneBasedOffset);
        }
    }

    static Reader rangeReader(Reader reader, long oneBasedOffset, long length, long dataSize) {
        if (dataSize > 0L) {
            ValueLob.rangeCheck(oneBasedOffset - 1L, length, dataSize);
        } else {
            ValueLob.rangeCheckUnknown(oneBasedOffset - 1L, length);
        }
        try {
            return new RangeReader(reader, oneBasedOffset - 1L, length);
        }
        catch (IOException e) {
            throw DbException.getInvalidValueException("offset", oneBasedOffset);
        }
    }

    ValueLob(LobData lobData, long octetLength, long charLength) {
        this.lobData = lobData;
        this.octetLength = octetLength;
        this.charLength = charLength;
    }

    static String createTempLobFileName(DataHandler handler) throws IOException {
        String path = handler.getDatabasePath();
        if (path.isEmpty()) {
            path = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(path, ".temp.db", true);
    }

    static int getBufferSize(DataHandler handler, long remaining) {
        if (remaining < 0L || remaining > Integer.MAX_VALUE) {
            remaining = Integer.MAX_VALUE;
        }
        int inplace = handler.getMaxLengthInplaceLob();
        long m = 4096L;
        if (m < remaining && m <= (long)inplace) {
            m = Math.min(remaining, (long)inplace + 1L);
            m = MathUtils.roundUpLong(m, 4096L);
        }
        m = Math.min(remaining, m);
        if ((m = (long)MathUtils.convertLongToInt(m)) < 0L) {
            m = Integer.MAX_VALUE;
        }
        return (int)m;
    }

    public boolean isLinkedToTable() {
        return this.lobData.isLinkedToTable();
    }

    public void remove() {
        this.lobData.remove(this);
    }

    public abstract ValueLob copy(DataHandler var1, int var2);

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int valueType;
            this.type = type = new TypeInfo(valueType, (valueType = this.getValueType()) == 3 ? this.charLength : this.octetLength, 0, null);
        }
        return type;
    }

    DbException getStringTooLong(long precision) {
        return DbException.getValueTooLongException("CHARACTER VARYING", this.readString(81), precision);
    }

    String readString(int len) {
        try {
            return IOUtils.readStringAndClose(this.getReader(), len);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public Reader getReader() {
        return IOUtils.getReader(this.getInputStream());
    }

    @Override
    public byte[] getBytes() {
        if (this.lobData instanceof LobDataInMemory) {
            return Utils.cloneByteArray(this.getSmall());
        }
        return this.getBytesInternal();
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.lobData instanceof LobDataInMemory) {
            return this.getSmall();
        }
        return this.getBytesInternal();
    }

    private byte[] getSmall() {
        byte[] small = ((LobDataInMemory)this.lobData).getSmall();
        int p = small.length;
        if (p > 1000000000) {
            throw DbException.getValueTooLongException("BINARY VARYING", StringUtils.convertBytesToHex(small, 41), p);
        }
        return small;
    }

    abstract byte[] getBytesInternal();

    DbException getBinaryTooLong(long precision) {
        return DbException.getValueTooLongException("BINARY VARYING", StringUtils.convertBytesToHex(this.readBytes(41)), precision);
    }

    byte[] readBytes(int len) {
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), len);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            long length;
            int valueType = this.getValueType();
            long l = length = valueType == 3 ? this.charLength : this.octetLength;
            if (length > 4096L) {
                return (int)(length ^ length >>> 32);
            }
            this.hash = Utils.getByteArrayHash(this.getBytesNoCopy());
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueLob)) {
            return false;
        }
        ValueLob otherLob = (ValueLob)other;
        if (this.hashCode() != otherLob.hashCode()) {
            return false;
        }
        return this.compareTypeSafe((Value)other, null, null) == 0;
    }

    @Override
    public int getMemory() {
        return this.lobData.getMemory();
    }

    public LobData getLobData() {
        return this.lobData;
    }

    public ValueLob copyToResult() {
        LobStorageInterface s;
        if (this.lobData instanceof LobDataDatabase && !(s = this.lobData.getDataHandler().getLobStorage()).isReadOnly()) {
            return s.copyLob(this, -3);
        }
        return this;
    }

    final void formatLobDataComment(StringBuilder builder) {
        if (this.lobData instanceof LobDataDatabase) {
            LobDataDatabase lobDb = (LobDataDatabase)this.lobData;
            builder.append(" /* table: ").append(lobDb.getTableId()).append(" id: ").append(lobDb.getLobId()).append(" */)");
        } else if (this.lobData instanceof LobDataFetchOnDemand) {
            LobDataFetchOnDemand lobDemand = (LobDataFetchOnDemand)this.lobData;
            builder.append(" /* table: ").append(lobDemand.getTableId()).append(" id: ").append(lobDemand.getLobId()).append(" */)");
        } else {
            builder.append(" /* ").append(this.lobData.toString().replaceAll("\\*/", "\\\\*\\\\/")).append(" */");
        }
    }
}

