/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.result.SimpleResult;
import org.h2.value.CompareMode;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueRow
extends ValueCollectionBase {
    public static final ValueRow EMPTY = ValueRow.get(Value.EMPTY_VALUES);
    private TypeInfo type;

    private ValueRow(TypeInfo type, Value[] list) {
        super(list);
        int degree = list.length;
        if (degree > 16384) {
            throw DbException.get(54011, "16384");
        }
        if (type != null) {
            if (type.getValueType() != 41 || ((ExtTypeInfoRow)type.getExtTypeInfo()).getFields().size() != degree) {
                throw DbException.getInternalError();
            }
            this.type = type;
        }
    }

    public static ValueRow get(Value[] list) {
        return new ValueRow(null, list);
    }

    public static ValueRow get(ExtTypeInfoRow extTypeInfo, Value[] list) {
        return new ValueRow(new TypeInfo(41, -1L, -1, extTypeInfo), list);
    }

    public static ValueRow get(TypeInfo typeInfo, Value[] list) {
        return new ValueRow(typeInfo, list);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(this.values));
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 41;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder("ROW (");
        int i = 0;
        while (i < this.values.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.values[i].getString());
            ++i;
        }
        return builder.append(')').toString();
    }

    public SimpleResult getResult() {
        SimpleResult result = new SimpleResult();
        int i = 0;
        int l = this.values.length;
        while (i < l) {
            Value v = this.values[i++];
            result.addColumn("C" + i, v.getType());
        }
        result.addRow(this.values);
        return result;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueRow v = (ValueRow)o;
        if (this.values == v.values) {
            return 0;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            throw DbException.get(21002);
        }
        int i = 0;
        while (i < len) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int comp = v1.compareTo(v2, provider, mode);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append("ROW (");
        int length = this.values.length;
        int i = 0;
        while (i < length) {
            if (i > 0) {
                builder.append(", ");
            }
            this.values[i].getSQL(builder, sqlFlags);
            ++i;
        }
        return builder.append(')');
    }

    public ValueRow cloneWithOrder(int[] newOrder) {
        int length = this.values.length;
        if (newOrder.length != this.values.length) {
            throw DbException.getInternalError("Length of the new orders is different than values count.");
        }
        Value[] newValues = new Value[length];
        int i = 0;
        while (i < length) {
            newValues[i] = this.values[newOrder[i]];
            ++i;
        }
        ExtTypeInfoRow typeInfoRow = (ExtTypeInfoRow)this.type.getExtTypeInfo();
        Map.Entry<K, V>[] fields = typeInfoRow.getFields().toArray(ValueRow.createEntriesArray(length));
        LinkedHashMap<String, TypeInfo> newFields = new LinkedHashMap<String, TypeInfo>(length);
        int i2 = 0;
        while (i2 < length) {
            Map.Entry field = fields[newOrder[i2]];
            newFields.put((String)field.getKey(), (TypeInfo)field.getValue());
            ++i2;
        }
        ExtTypeInfoRow newTypeInfoRow = new ExtTypeInfoRow(newFields);
        TypeInfo newType = new TypeInfo(this.type.getValueType(), this.type.getDeclaredPrecision(), this.type.getDeclaredScale(), newTypeInfoRow);
        return new ValueRow(newType, newValues);
    }

    private static <K, V> Map.Entry<K, V>[] createEntriesArray(int length) {
        return new Map.Entry[length];
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueRow)) {
            return false;
        }
        ValueRow v = (ValueRow)other;
        if (this.values == v.values) {
            return true;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!this.values[i].equals(v.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

