/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ValueStringBase
extends Value {
    String value;
    private TypeInfo type;

    ValueStringBase(String v) {
        int length = v.length();
        if (length > 1000000000) {
            throw DbException.getValueTooLongException(ValueStringBase.getTypeName(this.getValueType()), v, length);
        }
        this.value = v;
    }

    @Override
    public final TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int length = this.value.length();
            this.type = type = new TypeInfo(this.getValueType(), length, 0, null);
        }
        return type;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        return mode.compareString(this.value, ((ValueStringBase)v).value, false);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    @Override
    public final String getString() {
        return this.value;
    }

    @Override
    public final byte[] getBytes() {
        return this.value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public final boolean getBoolean() {
        String s = this.value.trim();
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n")) {
            return false;
        }
        try {
            return new BigDecimal(s).signum() != 0;
        }
        catch (NumberFormatException e) {
            throw this.getDataConversionError(8);
        }
    }

    @Override
    public final byte getByte() {
        try {
            return Byte.parseByte(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final short getShort() {
        try {
            return Short.parseShort(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final int getInt() {
        try {
            return Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final long getLong() {
        try {
            return Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final BigDecimal getBigDecimal() {
        try {
            return new BigDecimal(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final float getFloat() {
        try {
            return Float.parseFloat(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final double getDouble() {
        try {
            return Double.parseDouble(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw DbException.get(22018, e, this.value);
        }
    }

    @Override
    public final int getMemory() {
        return this.value.length() * 2 + 94;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.value.equals(((ValueStringBase)other).value);
    }
}

