/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.h2.api.Interval;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Format;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSQLXML;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.JSR310Utils;
import org.h2.util.JdbcUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueToObjectConverter
extends TraceObject {
    public static final Class<?> GEOMETRY_CLASS;
    private static final String GEOMETRY_CLASS_NAME = "org.locationtech.jts.geom.Geometry";

    static {
        Class g;
        try {
            g = JdbcUtils.loadUserClass(GEOMETRY_CLASS_NAME);
        }
        catch (Exception e) {
            g = null;
        }
        GEOMETRY_CLASS = g;
    }

    public static Value objectToValue(Session session, Object x, int type) {
        Value v;
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (type == 35) {
            return ValueJavaObject.getNoCopy(JdbcUtils.serialize(x, session.getJavaObjectSerializer()));
        }
        if (x instanceof Value) {
            v = (Value)x;
            if (v instanceof ValueLob) {
                session.addTemporaryLob((ValueLob)v);
            }
        } else {
            Class<?> clazz = x.getClass();
            if (clazz == String.class) {
                v = ValueVarchar.get((String)x, session);
            } else if (clazz == Long.class) {
                v = ValueBigint.get((Long)x);
            } else if (clazz == Integer.class) {
                v = ValueInteger.get((Integer)x);
            } else if (clazz == Boolean.class) {
                v = ValueBoolean.get((Boolean)x);
            } else if (clazz == Byte.class) {
                v = ValueTinyint.get((Byte)x);
            } else if (clazz == Short.class) {
                v = ValueSmallint.get((Short)x);
            } else if (clazz == Float.class) {
                v = ValueReal.get(((Float)x).floatValue());
            } else if (clazz == Double.class) {
                v = ValueDouble.get((Double)x);
            } else if (clazz == byte[].class) {
                v = ValueVarbinary.get((byte[])x);
            } else if (clazz == UUID.class) {
                v = ValueUuid.get((UUID)x);
            } else if (clazz == Character.class) {
                v = ValueChar.get(((Character)x).toString());
            } else if (clazz == LocalDate.class) {
                v = JSR310Utils.localDateToValue((LocalDate)x);
            } else if (clazz == LocalTime.class) {
                v = JSR310Utils.localTimeToValue((LocalTime)x);
            } else if (clazz == LocalDateTime.class) {
                v = JSR310Utils.localDateTimeToValue((LocalDateTime)x);
            } else if (clazz == Instant.class) {
                v = JSR310Utils.instantToValue((Instant)x);
            } else if (clazz == OffsetTime.class) {
                v = JSR310Utils.offsetTimeToValue((OffsetTime)x);
            } else if (clazz == OffsetDateTime.class) {
                v = JSR310Utils.offsetDateTimeToValue((OffsetDateTime)x);
            } else if (clazz == ZonedDateTime.class) {
                v = JSR310Utils.zonedDateTimeToValue((ZonedDateTime)x);
            } else if (clazz == Interval.class) {
                Interval i = (Interval)x;
                v = ValueInterval.from(i.getQualifier(), i.isNegative(), i.getLeading(), i.getRemaining());
            } else {
                v = clazz == Period.class ? JSR310Utils.periodToValue((Period)x) : (clazz == Duration.class ? JSR310Utils.durationToValue((Duration)x) : (x instanceof Object[] ? ValueToObjectConverter.arrayToValue(session, x) : (GEOMETRY_CLASS != null && GEOMETRY_CLASS.isAssignableFrom(clazz) ? ValueGeometry.getFromGeometry(x) : (x instanceof BigInteger ? ValueNumeric.get((BigInteger)x) : (x instanceof BigDecimal ? ValueNumeric.getAnyScale((BigDecimal)x) : ValueToObjectConverter.otherToValue(session, x))))));
            }
        }
        if (type == 38) {
            v = Format.applyJSON(v);
        }
        return v;
    }

    private static Value otherToValue(Session session, Object x) {
        ValueLob lob;
        if (x instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)x;
            try {
                return ValueToObjectConverter.arrayToValue(session, array.getArray());
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        if (x instanceof ResultSet) {
            return ValueToObjectConverter.resultSetToValue(session, (ResultSet)x);
        }
        if (x instanceof Reader) {
            Reader r = (Reader)x;
            if (!(r instanceof BufferedReader)) {
                r = new BufferedReader(r);
            }
            lob = session.getDataHandler().getLobStorage().createClob(r, -1L);
        } else if (x instanceof Clob) {
            try {
                Clob clob = (Clob)x;
                BufferedReader r = new BufferedReader(clob.getCharacterStream());
                lob = session.getDataHandler().getLobStorage().createClob(r, clob.length());
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        } else if (x instanceof InputStream) {
            lob = session.getDataHandler().getLobStorage().createBlob((InputStream)x, -1L);
        } else if (x instanceof Blob) {
            try {
                Blob blob = (Blob)x;
                lob = session.getDataHandler().getLobStorage().createBlob(blob.getBinaryStream(), blob.length());
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        } else if (x instanceof SQLXML) {
            try {
                lob = session.getDataHandler().getLobStorage().createClob(new BufferedReader(((SQLXML)x).getCharacterStream()), -1L);
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        } else {
            Value v = LegacyDateTimeUtils.legacyObjectToValue(session, x);
            if (v != null) {
                return v;
            }
            return ValueJavaObject.getNoCopy(JdbcUtils.serialize(x, session.getJavaObjectSerializer()));
        }
        return session.addTemporaryLob(lob);
    }

    private static Value arrayToValue(Session session, Object x) {
        Object[] o = (Object[])x;
        int len = o.length;
        Value[] v = new Value[len];
        int i = 0;
        while (i < len) {
            v[i] = ValueToObjectConverter.objectToValue(session, o[i], -1);
            ++i;
        }
        return ValueArray.get(v, session);
    }

    static Value resultSetToValue(Session session, ResultSet rs) {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            LinkedHashMap<String, TypeInfo> columns = ValueToObjectConverter.readResultSetMeta(session, meta, columnCount);
            if (!rs.next()) {
                throw DbException.get(22018, "Empty ResultSet to ROW value");
            }
            Value[] list = new Value[columnCount];
            Iterator<Map.Entry<String, TypeInfo>> iterator = columns.entrySet().iterator();
            int j = 0;
            while (j < columnCount) {
                list[j] = ValueToObjectConverter.objectToValue(session, rs.getObject(j + 1), iterator.next().getValue().getValueType());
                ++j;
            }
            if (rs.next()) {
                throw DbException.get(22018, "Multi-row ResultSet to ROW value");
            }
            return ValueRow.get(new ExtTypeInfoRow(columns), list);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    private static LinkedHashMap<String, TypeInfo> readResultSetMeta(Session session, ResultSetMetaData meta, int columnCount) throws SQLException {
        LinkedHashMap<String, TypeInfo> columns = new LinkedHashMap<String, TypeInfo>();
        int i = 0;
        while (i < columnCount) {
            String alias = meta.getColumnLabel(i + 1);
            String columnTypeName = meta.getColumnTypeName(i + 1);
            int columnType = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1), columnTypeName);
            int precision = meta.getPrecision(i + 1);
            int scale = meta.getScale(i + 1);
            TypeInfo typeInfo = columnType == 40 && columnTypeName.endsWith(" ARRAY") ? TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.getTypeInfo(DataType.getTypeByName((String)columnTypeName.substring((int)0, (int)(columnTypeName.length() - 6)), (Mode)session.getMode()).type)) : TypeInfo.getTypeInfo(columnType, precision, scale, null);
            columns.put(alias, typeInfo);
            ++i;
        }
        return columns;
    }

    public static <T> T valueToObject(Class<T> type, Value value, JdbcConnection conn) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        if (type == BigDecimal.class) {
            return (T)value.getBigDecimal();
        }
        if (type == BigInteger.class) {
            return (T)value.getBigDecimal().toBigInteger();
        }
        if (type == String.class) {
            return (T)value.getString();
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value.getBoolean());
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value.getByte());
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value.getShort());
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value.getInt());
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value.getLong());
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value.getFloat());
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value.getDouble());
        }
        if (type == UUID.class) {
            return (T)value.convertToUuid().getUuid();
        }
        if (type == byte[].class) {
            return (T)value.getBytes();
        }
        if (type == Character.class) {
            String s = value.getString();
            return (T)Character.valueOf(s.isEmpty() ? (char)' ' : s.charAt(0));
        }
        if (type == Interval.class) {
            if (!(value instanceof ValueInterval)) {
                value = value.convertTo(TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND);
            }
            ValueInterval v = (ValueInterval)value;
            return (T)new Interval(v.getQualifier(), false, v.getLeading(), v.getRemaining());
        }
        if (type == LocalDate.class) {
            return (T)JSR310Utils.valueToLocalDate(value, conn);
        }
        if (type == LocalTime.class) {
            return (T)JSR310Utils.valueToLocalTime(value, conn);
        }
        if (type == LocalDateTime.class) {
            return (T)JSR310Utils.valueToLocalDateTime(value, conn);
        }
        if (type == OffsetTime.class) {
            return (T)JSR310Utils.valueToOffsetTime(value, conn);
        }
        if (type == OffsetDateTime.class) {
            return (T)JSR310Utils.valueToOffsetDateTime(value, conn);
        }
        if (type == ZonedDateTime.class) {
            return (T)JSR310Utils.valueToZonedDateTime(value, conn);
        }
        if (type == Instant.class) {
            return (T)JSR310Utils.valueToInstant(value, conn);
        }
        if (type == Period.class) {
            return (T)JSR310Utils.valueToPeriod(value);
        }
        if (type == Duration.class) {
            return (T)JSR310Utils.valueToDuration(value);
        }
        if (type.isArray()) {
            return (T)ValueToObjectConverter.valueToArray(type, value, conn);
        }
        if (GEOMETRY_CLASS != null && GEOMETRY_CLASS.isAssignableFrom(type)) {
            return (T)value.convertToGeometry(null).getGeometry();
        }
        return (T)ValueToObjectConverter.valueToOther(type, value, conn);
    }

    private static Object valueToArray(Class<?> type, Value value, JdbcConnection conn) {
        Value[] array = ((ValueArray)value).getList();
        Class<?> componentType = type.getComponentType();
        int length = array.length;
        Object[] objArray = (Object[])Array.newInstance(componentType, length);
        int i = 0;
        while (i < length) {
            objArray[i] = ValueToObjectConverter.valueToObject(componentType, array[i], conn);
            ++i;
        }
        return objArray;
    }

    private static Object valueToOther(Class<?> type, Value value, JdbcConnection conn) {
        if (type == Object.class) {
            return JdbcUtils.deserialize(value.convertToJavaObject(TypeInfo.TYPE_JAVA_OBJECT, 0, null).getBytesNoCopy(), conn.getJavaObjectSerializer());
        }
        if (type == InputStream.class) {
            return value.getInputStream();
        }
        if (type == Reader.class) {
            return value.getReader();
        }
        if (type == java.sql.Array.class) {
            return new JdbcArray(conn, value, ValueToObjectConverter.getNextId(16));
        }
        if (type == Blob.class) {
            return new JdbcBlob(conn, value, JdbcLob.State.WITH_VALUE, ValueToObjectConverter.getNextId(9));
        }
        if (type == Clob.class) {
            return new JdbcClob(conn, value, JdbcLob.State.WITH_VALUE, ValueToObjectConverter.getNextId(10));
        }
        if (type == SQLXML.class) {
            return new JdbcSQLXML(conn, value, JdbcLob.State.WITH_VALUE, ValueToObjectConverter.getNextId(17));
        }
        if (type == ResultSet.class) {
            return new JdbcResultSet(conn, null, null, (ResultInterface)value.convertToAnyRow().getResult(), ValueToObjectConverter.getNextId(4), true, false, false);
        }
        Object obj = LegacyDateTimeUtils.valueToLegacyType(type, value, conn);
        if (obj != null) {
            return obj;
        }
        if (value.getValueType() == 35 && type.isAssignableFrom((obj = JdbcUtils.deserialize(value.getBytesNoCopy(), conn.getJavaObjectSerializer())).getClass())) {
            return obj;
        }
        throw DbException.getUnsupportedException("converting to class " + type.getName());
    }

    public static Class<?> getDefaultClass(int type, boolean forJdbc) {
        switch (type) {
            case 0: {
                return Void.class;
            }
            case 1: 
            case 2: 
            case 4: 
            case 36: {
                return String.class;
            }
            case 3: {
                return Clob.class;
            }
            case 5: 
            case 6: 
            case 38: {
                return byte[].class;
            }
            case 7: {
                return Blob.class;
            }
            case 8: {
                return Boolean.class;
            }
            case 9: {
                if (forJdbc) {
                    return Integer.class;
                }
                return Byte.class;
            }
            case 10: {
                if (forJdbc) {
                    return Integer.class;
                }
                return Short.class;
            }
            case 11: {
                return Integer.class;
            }
            case 12: {
                return Long.class;
            }
            case 13: 
            case 16: {
                return BigDecimal.class;
            }
            case 14: {
                return Float.class;
            }
            case 15: {
                return Double.class;
            }
            case 17: {
                return forJdbc ? Date.class : LocalDate.class;
            }
            case 18: {
                return forJdbc ? Time.class : LocalTime.class;
            }
            case 19: {
                return OffsetTime.class;
            }
            case 20: {
                return forJdbc ? Timestamp.class : LocalDateTime.class;
            }
            case 21: {
                return OffsetDateTime.class;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return Interval.class;
            }
            case 35: {
                return forJdbc ? Object.class : byte[].class;
            }
            case 37: {
                Class<?> clazz = GEOMETRY_CLASS;
                return clazz != null ? clazz : String.class;
            }
            case 39: {
                return UUID.class;
            }
            case 40: {
                if (forJdbc) {
                    return java.sql.Array.class;
                }
                return Object[].class;
            }
            case 41: {
                if (forJdbc) {
                    return ResultSet.class;
                }
                return Object[].class;
            }
        }
        throw DbException.getUnsupportedException("data type " + type);
    }

    public static Object valueToDefaultObject(Value value, JdbcConnection conn, boolean forJdbc) {
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 4: 
            case 36: {
                return value.getString();
            }
            case 3: {
                return new JdbcClob(conn, value, JdbcLob.State.WITH_VALUE, ValueToObjectConverter.getNextId(10));
            }
            case 5: 
            case 6: 
            case 38: {
                return value.getBytes();
            }
            case 7: {
                return new JdbcBlob(conn, value, JdbcLob.State.WITH_VALUE, ValueToObjectConverter.getNextId(9));
            }
            case 8: {
                return value.getBoolean();
            }
            case 9: {
                if (forJdbc) {
                    return value.getInt();
                }
                return value.getByte();
            }
            case 10: {
                if (forJdbc) {
                    return value.getInt();
                }
                return value.getShort();
            }
            case 11: {
                return value.getInt();
            }
            case 12: {
                return value.getLong();
            }
            case 13: 
            case 16: {
                return value.getBigDecimal();
            }
            case 14: {
                return Float.valueOf(value.getFloat());
            }
            case 15: {
                return value.getDouble();
            }
            case 17: {
                return forJdbc ? LegacyDateTimeUtils.toDate(conn, null, value) : JSR310Utils.valueToLocalDate(value, null);
            }
            case 18: {
                return forJdbc ? LegacyDateTimeUtils.toTime(conn, null, value) : JSR310Utils.valueToLocalTime(value, null);
            }
            case 19: {
                return JSR310Utils.valueToOffsetTime(value, null);
            }
            case 20: {
                return forJdbc ? LegacyDateTimeUtils.toTimestamp(conn, null, value) : JSR310Utils.valueToLocalDateTime(value, null);
            }
            case 21: {
                return JSR310Utils.valueToOffsetDateTime(value, null);
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return ((ValueInterval)value).getInterval();
            }
            case 35: {
                return forJdbc ? (Object)JdbcUtils.deserialize(value.getBytesNoCopy(), conn.getJavaObjectSerializer()) : value.getBytes();
            }
            case 37: {
                return GEOMETRY_CLASS != null ? ((ValueGeometry)value).getGeometry() : value.getString();
            }
            case 39: {
                return ((ValueUuid)value).getUuid();
            }
            case 40: {
                if (forJdbc) {
                    return new JdbcArray(conn, value, ValueToObjectConverter.getNextId(16));
                }
                return ValueToObjectConverter.valueToDefaultArray(value, conn, forJdbc);
            }
            case 41: {
                if (forJdbc) {
                    return new JdbcResultSet(conn, null, null, (ResultInterface)((ValueRow)value).getResult(), ValueToObjectConverter.getNextId(4), true, false, false);
                }
                return ValueToObjectConverter.valueToDefaultArray(value, conn, forJdbc);
            }
        }
        throw DbException.getUnsupportedException("data type " + value.getValueType());
    }

    public static Object valueToDefaultArray(Value value, JdbcConnection conn, boolean forJdbc) {
        Value[] values = ((ValueCollectionBase)value).getList();
        int len = values.length;
        Object[] list = new Object[len];
        int i = 0;
        while (i < len) {
            list[i] = ValueToObjectConverter.valueToDefaultObject(values[i], conn, forJdbc);
            ++i;
        }
        return list;
    }

    public static Value readValue(Session session, JdbcResultSet rs, int columnIndex) {
        Value value = rs.getInternal(columnIndex);
        switch (value.getValueType()) {
            case 3: {
                value = session.addTemporaryLob(session.getDataHandler().getLobStorage().createClob(new BufferedReader(value.getReader()), -1L));
                break;
            }
            case 7: {
                value = session.addTemporaryLob(session.getDataHandler().getLobStorage().createBlob(value.getInputStream(), -1L));
            }
        }
        return value;
    }

    private ValueToObjectConverter() {
    }
}

