/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IntervalUtils;
import org.h2.util.JSR310Utils;
import org.h2.util.JdbcUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueToObjectConverter2
extends TraceObject {
    public static TypeInfo classToType(Class<?> clazz) {
        if (clazz == null) {
            return TypeInfo.TYPE_NULL;
        }
        if (clazz.isPrimitive()) {
            clazz = Utils.getNonPrimitiveClass(clazz);
        }
        if (clazz == Void.class) {
            return TypeInfo.TYPE_NULL;
        }
        if (clazz == String.class || clazz == Character.class) {
            return TypeInfo.TYPE_VARCHAR;
        }
        if (clazz == byte[].class) {
            return TypeInfo.TYPE_VARBINARY;
        }
        if (clazz == Boolean.class) {
            return TypeInfo.TYPE_BOOLEAN;
        }
        if (clazz == Byte.class) {
            return TypeInfo.TYPE_TINYINT;
        }
        if (clazz == Short.class) {
            return TypeInfo.TYPE_SMALLINT;
        }
        if (clazz == Integer.class) {
            return TypeInfo.TYPE_INTEGER;
        }
        if (clazz == Long.class) {
            return TypeInfo.TYPE_BIGINT;
        }
        if (clazz == Float.class) {
            return TypeInfo.TYPE_REAL;
        }
        if (clazz == Double.class) {
            return TypeInfo.TYPE_DOUBLE;
        }
        if (clazz == LocalDate.class) {
            return TypeInfo.TYPE_DATE;
        }
        if (clazz == LocalTime.class) {
            return TypeInfo.TYPE_TIME;
        }
        if (clazz == OffsetTime.class) {
            return TypeInfo.TYPE_TIME_TZ;
        }
        if (clazz == LocalDateTime.class) {
            return TypeInfo.TYPE_TIMESTAMP;
        }
        if (clazz == OffsetDateTime.class || clazz == ZonedDateTime.class || clazz == Instant.class) {
            return TypeInfo.TYPE_TIMESTAMP_TZ;
        }
        if (clazz == Period.class) {
            return TypeInfo.TYPE_INTERVAL_YEAR_TO_MONTH;
        }
        if (clazz == Duration.class) {
            return TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND;
        }
        if (UUID.class == clazz) {
            return TypeInfo.TYPE_UUID;
        }
        if (clazz.isArray()) {
            return TypeInfo.getTypeInfo(40, Integer.MAX_VALUE, 0, ValueToObjectConverter2.classToType(clazz.getComponentType()));
        }
        if (Clob.class.isAssignableFrom(clazz) || Reader.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_CLOB;
        }
        if (Blob.class.isAssignableFrom(clazz) || InputStream.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_BLOB;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
        }
        if (ValueToObjectConverter.GEOMETRY_CLASS != null && ValueToObjectConverter.GEOMETRY_CLASS.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_GEOMETRY;
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_ARRAY_UNKNOWN;
        }
        if (ResultSet.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_ROW_EMPTY;
        }
        TypeInfo typeInfo = LegacyDateTimeUtils.legacyClassToType(clazz);
        if (typeInfo != null) {
            return typeInfo;
        }
        return TypeInfo.TYPE_JAVA_OBJECT;
    }

    public static Value readValue(Session session, ResultSet resultSet, int n, int n2) {
        Value value;
        if (resultSet instanceof JdbcResultSet) {
            value = ValueToObjectConverter.readValue(session, (JdbcResultSet)resultSet, n);
        } else {
            try {
                value = ValueToObjectConverter2.readValueOther(session, resultSet, n, n2);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        return value;
    }

    private static Value readValueOther(Session session, ResultSet resultSet, int n, int n2) throws SQLException {
        return switch (n2) {
            case 0 -> ValueNull.INSTANCE;
            case 1 -> {
                String var5_5 = resultSet.getString(n);
                yield var5_5 == null ? ValueNull.INSTANCE : ValueChar.get(var5_5);
            }
            case 2 -> {
                String var5_6 = resultSet.getString(n);
                yield var5_6 == null ? ValueNull.INSTANCE : ValueVarchar.get(var5_6, session);
            }
            case 3 -> {
                if (session == null) {
                    String var5_7 = resultSet.getString(n);
                    yield var5_7 == null ? ValueNull.INSTANCE : ValueClob.createSmall(var5_7);
                }
                Reader var5_8 = resultSet.getCharacterStream(n);
                yield var5_8 == null ? ValueNull.INSTANCE : session.addTemporaryLob(session.getDataHandler().getLobStorage().createClob(new BufferedReader(var5_8), -1L));
            }
            case 4 -> {
                String var5_9 = resultSet.getString(n);
                yield var5_9 == null ? ValueNull.INSTANCE : ValueVarcharIgnoreCase.get(var5_9);
            }
            case 5 -> {
                byte[] var5_10 = resultSet.getBytes(n);
                yield var5_10 == null ? ValueNull.INSTANCE : ValueBinary.getNoCopy(var5_10);
            }
            case 6 -> {
                byte[] var5_11 = resultSet.getBytes(n);
                yield var5_11 == null ? ValueNull.INSTANCE : ValueVarbinary.getNoCopy(var5_11);
            }
            case 7 -> {
                if (session == null) {
                    byte[] var5_12 = resultSet.getBytes(n);
                    yield var5_12 == null ? ValueNull.INSTANCE : ValueBlob.createSmall(var5_12);
                }
                InputStream var5_13 = resultSet.getBinaryStream(n);
                yield var5_13 == null ? ValueNull.INSTANCE : session.addTemporaryLob(session.getDataHandler().getLobStorage().createBlob(var5_13, -1L));
            }
            case 8 -> {
                boolean var5_14 = resultSet.getBoolean(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(var5_14);
            }
            case 9 -> {
                byte var5_15 = resultSet.getByte(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueTinyint.get(var5_15);
            }
            case 10 -> {
                short var5_16 = resultSet.getShort(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueSmallint.get(var5_16);
            }
            case 11 -> {
                int var5_17 = resultSet.getInt(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueInteger.get(var5_17);
            }
            case 12 -> {
                long var5_18 = resultSet.getLong(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueBigint.get(var5_18);
            }
            case 13 -> {
                BigDecimal var5_19 = resultSet.getBigDecimal(n);
                yield var5_19 == null ? ValueNull.INSTANCE : ValueNumeric.getAnyScale(var5_19);
            }
            case 14 -> {
                float var5_20 = resultSet.getFloat(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueReal.get(var5_20);
            }
            case 15 -> {
                double var5_21 = resultSet.getDouble(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(var5_21);
            }
            case 16 -> {
                BigDecimal var5_22 = resultSet.getBigDecimal(n);
                yield var5_22 == null ? ValueNull.INSTANCE : ValueDecfloat.get(var5_22);
            }
            case 17 -> {
                try {
                    LocalDate var5_23 = resultSet.getObject(n, LocalDate.class);
                    yield var5_23 == null ? ValueNull.INSTANCE : JSR310Utils.localDateToValue(var5_23);
                }
                catch (SQLException var5_24) {
                    Date var6_41 = resultSet.getDate(n);
                    yield var6_41 == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromDate(session, null, var6_41);
                }
            }
            case 18 -> {
                try {
                    LocalTime var5_25 = resultSet.getObject(n, LocalTime.class);
                    yield var5_25 == null ? ValueNull.INSTANCE : JSR310Utils.localTimeToValue(var5_25);
                }
                catch (SQLException var5_26) {
                    Time var6_42 = resultSet.getTime(n);
                    yield var6_42 == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTime(session, null, var6_42);
                }
            }
            case 19 -> {
                try {
                    OffsetTime var5_27 = resultSet.getObject(n, OffsetTime.class);
                    yield var5_27 == null ? ValueNull.INSTANCE : JSR310Utils.offsetTimeToValue(var5_27);
                }
                catch (SQLException var5_28) {
                    Object var6_43 = resultSet.getObject(n);
                    if (var6_43 == null) {
                        yield ValueNull.INSTANCE;
                    }
                    yield ValueTimeTimeZone.parse(var6_43.toString(), session);
                }
            }
            case 20 -> {
                try {
                    LocalDateTime var5_29 = resultSet.getObject(n, LocalDateTime.class);
                    yield var5_29 == null ? ValueNull.INSTANCE : JSR310Utils.localDateTimeToValue(var5_29);
                }
                catch (SQLException var5_30) {
                    Timestamp var6_44 = resultSet.getTimestamp(n);
                    yield var6_44 == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTimestamp((CastDataProvider)session, null, var6_44);
                }
            }
            case 21 -> {
                try {
                    OffsetDateTime var5_31 = resultSet.getObject(n, OffsetDateTime.class);
                    yield var5_31 == null ? ValueNull.INSTANCE : JSR310Utils.offsetDateTimeToValue(var5_31);
                }
                catch (SQLException var5_32) {
                    Object var6_45 = resultSet.getObject(n);
                    if (var6_45 == null) {
                        yield ValueNull.INSTANCE;
                    }
                    if (var6_45 instanceof ZonedDateTime) {
                        yield JSR310Utils.zonedDateTimeToValue((ZonedDateTime)var6_45);
                    }
                    yield ValueTimestampTimeZone.parse(var6_45.toString(), session);
                }
            }
            case 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 -> {
                String var5_33 = resultSet.getString(n);
                yield var5_33 == null ? ValueNull.INSTANCE : IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(n2 - 22), var5_33);
            }
            case 35 -> {
                byte[] var5_34;
                try {
                    var5_34 = resultSet.getBytes(n);
                }
                catch (SQLException var6_46) {
                    try {
                        Object var7_50 = resultSet.getObject(n);
                        var5_34 = var7_50 != null ? JdbcUtils.serialize(var7_50, session.getJavaObjectSerializer()) : null;
                    }
                    catch (Exception var7_51) {
                        throw DbException.convert(var7_51);
                    }
                }
                yield var5_34 == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(var5_34);
            }
            case 36 -> {
                int var5_35 = resultSet.getInt(n);
                yield resultSet.wasNull() ? ValueNull.INSTANCE : ValueInteger.get(var5_35);
            }
            case 37 -> {
                Object var5_36 = resultSet.getObject(n);
                yield var5_36 == null ? ValueNull.INSTANCE : ValueGeometry.getFromGeometry(var5_36);
            }
            case 38 -> {
                Object var5_37 = resultSet.getObject(n);
                if (var5_37 == null) {
                    yield ValueNull.INSTANCE;
                }
                Class<?> var6_47 = var5_37.getClass();
                if (var6_47 == byte[].class) {
                    yield ValueJson.fromJson((byte[])var5_37);
                }
                if (var6_47 == String.class) {
                    yield ValueJson.fromJson((String)var5_37);
                }
                yield ValueJson.fromJson(var5_37.toString());
            }
            case 39 -> {
                Object var5_38 = resultSet.getObject(n);
                if (var5_38 == null) {
                    yield ValueNull.INSTANCE;
                }
                if (var5_38 instanceof UUID) {
                    yield ValueUuid.get((UUID)var5_38);
                }
                if (var5_38 instanceof byte[]) {
                    yield ValueUuid.get((byte[])var5_38);
                }
                yield ValueUuid.get((String)var5_38);
            }
            case 40 -> {
                Array var5_39 = resultSet.getArray(n);
                if (var5_39 == null) {
                    yield ValueNull.INSTANCE;
                }
                Object[] var6_48 = (Object[])var5_39.getArray();
                if (var6_48 == null) {
                    yield ValueNull.INSTANCE;
                }
                int var7_52 = var6_48.length;
                Value[] var8_54 = new Value[var7_52];
                for (int var9_56 = 0; var9_56 < var7_52; ++var9_56) {
                    var8_54[var9_56] = ValueToObjectConverter.objectToValue(session, var6_48[var9_56], 0);
                }
                yield ValueArray.get(var8_54, session);
            }
            case 41 -> {
                Object var5_40 = resultSet.getObject(n);
                if (var5_40 == null) {
                    yield ValueNull.INSTANCE;
                }
                if (var5_40 instanceof ResultSet) {
                    yield ValueToObjectConverter.resultSetToValue(session, (ResultSet)var5_40);
                }
                Object[] var6_49 = (Object[])var5_40;
                int var7_53 = var6_49.length;
                Value[] var8_55 = new Value[var7_53];
                for (int var9_57 = 0; var9_57 < var7_53; ++var9_57) {
                    var8_55[var9_57] = ValueToObjectConverter.objectToValue(session, var6_49[var9_57], 0);
                }
                yield ValueRow.get(var8_55);
            }
            default -> throw DbException.getInternalError("data type " + n2);
        };
    }

    private ValueToObjectConverter2() {
    }
}

