/*
 * Decompiled with CFR 0.152.
 */
package org.h2.api;

import org.h2.api.IntervalQualifier;
import org.h2.message.DbException;
import org.h2.util.IntervalUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Interval {
    private final IntervalQualifier qualifier;
    private final boolean negative;
    private final long leading;
    private final long remaining;

    public static Interval ofYears(long years) {
        return new Interval(IntervalQualifier.YEAR, years < 0L, Math.abs(years), 0L);
    }

    public static Interval ofMonths(long months) {
        return new Interval(IntervalQualifier.MONTH, months < 0L, Math.abs(months), 0L);
    }

    public static Interval ofDays(long days) {
        return new Interval(IntervalQualifier.DAY, days < 0L, Math.abs(days), 0L);
    }

    public static Interval ofHours(long hours) {
        return new Interval(IntervalQualifier.HOUR, hours < 0L, Math.abs(hours), 0L);
    }

    public static Interval ofMinutes(long minutes) {
        return new Interval(IntervalQualifier.MINUTE, minutes < 0L, Math.abs(minutes), 0L);
    }

    public static Interval ofSeconds(long seconds) {
        return new Interval(IntervalQualifier.SECOND, seconds < 0L, Math.abs(seconds), 0L);
    }

    public static Interval ofSeconds(long seconds, int nanos) {
        boolean negative;
        boolean bl = negative = (seconds | (long)nanos) < 0L;
        if (negative) {
            if (seconds > 0L || nanos > 0) {
                throw new IllegalArgumentException();
            }
            seconds = -seconds;
            nanos = -nanos;
        }
        return new Interval(IntervalQualifier.SECOND, negative, seconds, nanos);
    }

    public static Interval ofNanos(long nanos) {
        boolean negative;
        boolean bl = negative = nanos < 0L;
        if (negative && (nanos = -nanos) < 0L) {
            return new Interval(IntervalQualifier.SECOND, true, 9223372036L, 854775808L);
        }
        return new Interval(IntervalQualifier.SECOND, negative, nanos / 1000000000L, nanos % 1000000000L);
    }

    public static Interval ofYearsMonths(long years, int months) {
        boolean negative;
        boolean bl = negative = (years | (long)months) < 0L;
        if (negative) {
            if (years > 0L || months > 0) {
                throw new IllegalArgumentException();
            }
            years = -years;
            months = -months;
        }
        return new Interval(IntervalQualifier.YEAR_TO_MONTH, negative, years, months);
    }

    public static Interval ofDaysHours(long days, int hours) {
        boolean negative;
        boolean bl = negative = (days | (long)hours) < 0L;
        if (negative) {
            if (days > 0L || hours > 0) {
                throw new IllegalArgumentException();
            }
            days = -days;
            hours = -hours;
        }
        return new Interval(IntervalQualifier.DAY_TO_HOUR, negative, days, hours);
    }

    public static Interval ofDaysHoursMinutes(long days, int hours, int minutes) {
        boolean negative;
        boolean bl = negative = (days | (long)hours | (long)minutes) < 0L;
        if (negative) {
            if (days > 0L || hours > 0 || minutes > 0) {
                throw new IllegalArgumentException();
            }
            days = -days;
            if (((hours = -hours) | (minutes = -minutes)) < 0) {
                throw new IllegalArgumentException();
            }
        }
        if (minutes >= 60) {
            throw new IllegalArgumentException();
        }
        return new Interval(IntervalQualifier.DAY_TO_MINUTE, negative, days, (long)hours * 60L + (long)minutes);
    }

    public static Interval ofDaysHoursMinutesSeconds(long days, int hours, int minutes, int seconds) {
        return Interval.ofDaysHoursMinutesNanos(days, hours, minutes, (long)seconds * 1000000000L);
    }

    public static Interval ofDaysHoursMinutesNanos(long days, int hours, int minutes, long nanos) {
        boolean negative;
        boolean bl = negative = (days | (long)hours | (long)minutes | nanos) < 0L;
        if (negative) {
            if (days > 0L || hours > 0 || minutes > 0 || nanos > 0L) {
                throw new IllegalArgumentException();
            }
            days = -days;
            if (((long)((hours = -hours) | (minutes = -minutes)) | (nanos = -nanos)) < 0L) {
                throw new IllegalArgumentException();
            }
        }
        if (minutes >= 60 || nanos >= 60000000000L) {
            throw new IllegalArgumentException();
        }
        return new Interval(IntervalQualifier.DAY_TO_SECOND, negative, days, ((long)hours * 60L + (long)minutes) * 60000000000L + nanos);
    }

    public static Interval ofHoursMinutes(long hours, int minutes) {
        boolean negative;
        boolean bl = negative = (hours | (long)minutes) < 0L;
        if (negative) {
            if (hours > 0L || minutes > 0) {
                throw new IllegalArgumentException();
            }
            hours = -hours;
            minutes = -minutes;
        }
        return new Interval(IntervalQualifier.HOUR_TO_MINUTE, negative, hours, minutes);
    }

    public static Interval ofHoursMinutesSeconds(long hours, int minutes, int seconds) {
        return Interval.ofHoursMinutesNanos(hours, minutes, (long)seconds * 1000000000L);
    }

    public static Interval ofHoursMinutesNanos(long hours, int minutes, long nanos) {
        boolean negative;
        boolean bl = negative = (hours | (long)minutes | nanos) < 0L;
        if (negative) {
            if (hours > 0L || minutes > 0 || nanos > 0L) {
                throw new IllegalArgumentException();
            }
            hours = -hours;
            if (((long)(minutes = -minutes) | (nanos = -nanos)) < 0L) {
                throw new IllegalArgumentException();
            }
        }
        if (nanos >= 60000000000L) {
            throw new IllegalArgumentException();
        }
        return new Interval(IntervalQualifier.HOUR_TO_SECOND, negative, hours, (long)minutes * 60000000000L + nanos);
    }

    public static Interval ofMinutesSeconds(long minutes, int seconds) {
        return Interval.ofMinutesNanos(minutes, (long)seconds * 1000000000L);
    }

    public static Interval ofMinutesNanos(long minutes, long nanos) {
        boolean negative;
        boolean bl = negative = (minutes | nanos) < 0L;
        if (negative) {
            if (minutes > 0L || nanos > 0L) {
                throw new IllegalArgumentException();
            }
            minutes = -minutes;
            nanos = -nanos;
        }
        return new Interval(IntervalQualifier.MINUTE_TO_SECOND, negative, minutes, nanos);
    }

    public Interval(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        this.qualifier = qualifier;
        try {
            this.negative = IntervalUtils.validateInterval(qualifier, negative, leading, remaining);
        }
        catch (DbException e) {
            throw new IllegalArgumentException();
        }
        this.leading = leading;
        this.remaining = remaining;
    }

    public IntervalQualifier getQualifier() {
        return this.qualifier;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public long getYears() {
        return IntervalUtils.yearsFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public long getMonths() {
        return IntervalUtils.monthsFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public long getDays() {
        return IntervalUtils.daysFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public long getHours() {
        return IntervalUtils.hoursFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public long getMinutes() {
        return IntervalUtils.minutesFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public long getSeconds() {
        if (this.qualifier == IntervalQualifier.SECOND) {
            return this.negative ? -this.leading : this.leading;
        }
        return this.getSecondsAndNanos() / 1000000000L;
    }

    public long getNanosOfSecond() {
        if (this.qualifier == IntervalQualifier.SECOND) {
            return this.negative ? -this.remaining : this.remaining;
        }
        return this.getSecondsAndNanos() % 1000000000L;
    }

    public long getSecondsAndNanos() {
        return IntervalUtils.nanosFromInterval(this.qualifier, this.negative, this.leading, this.remaining);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.qualifier.hashCode();
        result = 31 * result + (this.negative ? 1231 : 1237);
        result = 31 * result + (int)(this.leading ^ this.leading >>> 32);
        result = 31 * result + (int)(this.remaining ^ this.remaining >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.qualifier == other.qualifier && this.negative == other.negative && this.leading == other.leading && this.remaining == other.remaining;
    }

    public String toString() {
        return IntervalUtils.appendInterval(new StringBuilder(), this.getQualifier(), this.negative, this.leading, this.remaining).toString();
    }
}

