/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.bnf.context.DbSchema;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbContents {
    private DbSchema[] schemas;
    private DbSchema defaultSchema;
    private boolean isOracle;
    private boolean isH2;
    private boolean isPostgreSQL;
    private boolean isDerby;
    private boolean isSQLite;
    private boolean isMySQL;
    private boolean isFirebird;
    private boolean isMSSQLServer;
    private boolean isDB2;
    private boolean databaseToUpper;
    private boolean databaseToLower;
    private boolean mayHaveStandardViews = true;

    public DbSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isMSSQLServer() {
        return this.isMSSQLServer;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isSQLite() {
        return this.isSQLite;
    }

    public boolean isDB2() {
        return this.isDB2;
    }

    public DbSchema[] getSchemas() {
        return this.schemas;
    }

    public boolean mayHaveStandardViews() {
        return this.mayHaveStandardViews;
    }

    public void setMayHaveStandardViews(boolean mayHaveStandardViews) {
        this.mayHaveStandardViews = mayHaveStandardViews;
    }

    public synchronized void readContents(String url, Connection conn) throws SQLException {
        this.isH2 = url.startsWith("jdbc:h2:");
        this.isDB2 = url.startsWith("jdbc:db2:");
        this.isSQLite = url.startsWith("jdbc:sqlite:");
        this.isOracle = url.startsWith("jdbc:oracle:");
        this.isPostgreSQL = url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:vertica:");
        this.isMySQL = url.startsWith("jdbc:mysql:");
        this.isDerby = url.startsWith("jdbc:derby:");
        this.isFirebird = url.startsWith("jdbc:firebirdsql:");
        this.isMSSQLServer = url.startsWith("jdbc:sqlserver:");
        if (this.isH2) {
            Session.StaticSettings settings = ((JdbcConnection)conn).getStaticSettings();
            this.databaseToUpper = settings.databaseToUpper;
            this.databaseToLower = settings.databaseToLower;
        } else if (this.isMySQL || this.isPostgreSQL) {
            this.databaseToUpper = false;
            this.databaseToLower = true;
        } else {
            this.databaseToUpper = true;
            this.databaseToLower = false;
        }
        DatabaseMetaData meta = conn.getMetaData();
        String defaultSchemaName = this.getDefaultSchemaName(meta);
        String[] schemaNames = this.getSchemaNames(meta);
        this.schemas = new DbSchema[schemaNames.length];
        int i = 0;
        while (i < schemaNames.length) {
            String schemaName = schemaNames[i];
            boolean isDefault = defaultSchemaName == null || defaultSchemaName.equals(schemaName);
            DbSchema schema = new DbSchema(this, schemaName, isDefault);
            if (isDefault) {
                this.defaultSchema = schema;
            }
            this.schemas[i] = schema;
            String[] tableTypes = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM", "EXTERNAL"};
            schema.readTables(meta, tableTypes);
            if (!this.isPostgreSQL && !this.isDB2) {
                schema.readProcedures(meta);
            }
            ++i;
        }
        if (this.defaultSchema == null) {
            String best = null;
            DbSchema[] dbSchemaArray = this.schemas;
            int n = this.schemas.length;
            int n2 = 0;
            while (n2 < n) {
                DbSchema schema = dbSchemaArray[n2];
                if ("dbo".equals(schema.name)) {
                    this.defaultSchema = schema;
                    break;
                }
                if (this.defaultSchema == null || best == null || schema.name.length() < best.length()) {
                    best = schema.name;
                    this.defaultSchema = schema;
                }
                ++n2;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData meta) throws SQLException {
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[1];
        }
        ResultSet rs = meta.getSchemas();
        ArrayList<String> schemaList = Utils.newSmallArrayList();
        while (rs.next()) {
            String schema = rs.getString("TABLE_SCHEM");
            String[] ignoreNames = null;
            if (this.isOracle) {
                ignoreNames = new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"};
            } else if (this.isMSSQLServer) {
                ignoreNames = new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"};
            } else if (this.isDB2) {
                ignoreNames = new String[]{"NULLID", "SYSFUN", "SYSIBMINTERNAL", "SYSIBMTS", "SYSPROC", "SYSPUBLIC", "SYSCAT", "SYSIBM", "SYSIBMADM", "SYSSTAT", "SYSTOOLS"};
            }
            if (ignoreNames != null) {
                String[] stringArray = ignoreNames;
                int n = ignoreNames.length;
                int n2 = 0;
                while (n2 < n) {
                    void ignore = stringArray[n2];
                    if (ignore.equals(schema)) {
                        schema = null;
                        break;
                    }
                    ++n2;
                }
            }
            if (schema == null) continue;
            schemaList.add(schema);
        }
        rs.close();
        return schemaList.toArray(new String[0]);
    }

    private String getDefaultSchemaName(DatabaseMetaData meta) {
        String defaultSchemaName;
        block9: {
            block8: {
                defaultSchemaName = "";
                if (this.isH2) {
                    return meta.storesLowerCaseIdentifiers() ? "public" : "PUBLIC";
                }
                if (this.isOracle) {
                    return meta.getUserName();
                }
                if (!this.isPostgreSQL) break block8;
                return "public";
            }
            if (!this.isMySQL) break block9;
            return "";
        }
        try {
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(meta.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return defaultSchemaName;
    }

    public String quoteIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (ParserUtil.isSimpleIdentifier(identifier, this.databaseToUpper, this.databaseToLower)) {
            return identifier;
        }
        return StringUtils.quoteIdentifier(identifier);
    }
}

