/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.code;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class CheckJavadoc {
    private static final int MAX_COMMENT_LINE_SIZE = 100;
    private static final int MAX_SOURCE_LINE_SIZE = 120;
    private int errorCount;

    public static void main(String ... args) throws Exception {
        new CheckJavadoc().run();
    }

    private void run() throws Exception {
        this.check(Paths.get("src", new String[0]));
        if (this.errorCount > 0) {
            throw new Exception(this.errorCount + " errors found");
        }
    }

    private int check(Path file) throws Exception {
        String name = file.getFileName().toString();
        if (Files.isDirectory(file, new LinkOption[0])) {
            boolean foundPackageHtml = false;
            boolean foundJava = false;
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(file);){
                for (Path f : stream) {
                    int type = this.check(f);
                    if (type == 1) {
                        foundJava = true;
                        continue;
                    }
                    if (type != 2) continue;
                    foundPackageHtml = true;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (foundJava && !foundPackageHtml) {
                System.out.println("No package-info.java file, but a Java file found at: " + String.valueOf(file.toAbsolutePath()));
                ++this.errorCount;
            }
        } else if (name.endsWith(".java")) {
            this.checkJavadoc(file);
            return name.equals("package-info.java") ? 2 : 1;
        }
        return 0;
    }

    private void checkJavadoc(Path file) throws IOException {
        List<String> lines = Files.readAllLines(file);
        boolean inComment = false;
        boolean hasJavadoc = false;
        int lineNumber = 0;
        int size = lines.size();
        while (lineNumber < size) {
            String rawLine;
            String line;
            if ((line = (rawLine = lines.get(lineNumber++)).trim()).startsWith("/*")) {
                if (!hasJavadoc && line.startsWith("/**")) {
                    hasJavadoc = true;
                }
                inComment = true;
            }
            int rawLength = rawLine.length();
            if (inComment) {
                int i = line.indexOf("*/", 2);
                if (i >= 0) {
                    inComment = false;
                }
                if (i == rawLength - 2 && rawLength > 100 && !line.trim().startsWith("* http://") && !line.trim().startsWith("* https://")) {
                    System.out.println("Long line: " + String.valueOf(file.toAbsolutePath()) + " (" + String.valueOf(file.getFileName()) + ":" + lineNumber + ")");
                    ++this.errorCount;
                }
            }
            if (!inComment && line.startsWith("//")) {
                if (rawLength <= 100 || line.trim().startsWith("// http://") || line.trim().startsWith("// https://")) continue;
                System.out.println("Long line: " + String.valueOf(file.toAbsolutePath()) + " (" + String.valueOf(file.getFileName()) + ":" + lineNumber + ")");
                ++this.errorCount;
                continue;
            }
            if (inComment || rawLength <= 120) continue;
            System.out.println("Long line: " + String.valueOf(file.toAbsolutePath()) + " (" + String.valueOf(file.getFileName()) + ":" + lineNumber + ")");
            ++this.errorCount;
        }
        if (!hasJavadoc) {
            System.out.println("No Javadoc comment: " + String.valueOf(file.toAbsolutePath()));
            ++this.errorCount;
        }
    }
}

