/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.util.ArrayList;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.build.doc.BnfSyntax;
import org.h2.util.StringUtils;

public class BnfRailroad
implements BnfVisitor {
    private static final boolean RAILROAD_DOTS = true;
    private BnfSyntax syntaxVisitor;
    private Bnf config;
    private String html;

    public String getHtml(Bnf bnf, String syntaxLines) {
        this.syntaxVisitor = new BnfSyntax();
        this.config = bnf;
        syntaxLines = StringUtils.replaceAll(syntaxLines, "\n    ", " ");
        String[] syntaxList = StringUtils.arraySplit(syntaxLines, '\n', true);
        StringBuilder buff = new StringBuilder();
        String[] stringArray = syntaxList;
        int n = syntaxList.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            bnf.visit(this, s);
            this.html = StringUtils.replaceAll(this.html, "</code></td><td class=\"d\"><code class=\"c\">", " ");
            if (buff.length() > 0) {
                buff.append("<br />");
            }
            buff.append(this.html);
            ++n2;
        }
        return buff.toString();
    }

    @Override
    public void visitRuleElement(boolean keyword, String name, Rule link) {
        String x = keyword ? StringUtils.xmlText(name.trim()) : this.syntaxVisitor.getLink(this.config, name.trim());
        this.html = "<code class=\"c\">" + x + "</code>";
    }

    @Override
    public void visitRuleRepeat(boolean comma, Rule rule) {
        StringBuilder buff = new StringBuilder();
        buff.append("<code class=\"c\">");
        if (comma) {
            buff.append(", ");
        }
        buff.append("...</code>");
        this.html = buff.toString();
    }

    @Override
    public void visitRuleFixed(int type) {
        this.html = BnfRailroad.getHtmlText(type);
    }

    static String getHtmlText(int type) {
        switch (type) {
            case 0: {
                return "2000-01-01";
            }
            case 1: {
                return "12:00:00";
            }
            case 2: {
                return "000000000";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "anything";
            }
            case 9: {
                return "0x";
            }
            case 10: {
                return "0o";
            }
            case 11: {
                return "0b";
            }
            case 12: {
                return "||";
            }
            case 13: {
                return "A-Z | _";
            }
            case 14: {
                return "A-F";
            }
            case 15: {
                return "0-9";
            }
            case 16: {
                return "[";
            }
            case 17: {
                return "]";
            }
            case 18: {
                return "JSON text";
            }
        }
        throw new AssertionError((Object)("type=" + type));
    }

    @Override
    public void visitRuleList(boolean or, ArrayList<Rule> list) {
        StringBuilder buff = new StringBuilder();
        if (or) {
            buff.append("<table class=\"railroad\">");
            int i = 0;
            int l = list.size() - 1;
            while (i <= l) {
                this.visitOrItem(buff, list.get(i), i == 0 ? "t" : (i == l ? "l" : "k"));
                ++i;
            }
            buff.append("</table>");
        } else {
            buff.append("<table class=\"railroad\">");
            buff.append("<tr class=\"railroad\">");
            for (Rule r : list) {
                buff.append("<td class=\"d\">");
                r.accept(this);
                buff.append(this.html);
                buff.append("</td>");
            }
            buff.append("</tr></table>");
        }
        this.html = buff.toString();
    }

    @Override
    public void visitRuleOptional(Rule rule) {
        StringBuilder buff = new StringBuilder();
        BnfRailroad.writeOptionalStart(buff);
        buff.append("<tr class=\"railroad\"><td class=\"ls\"></td><td class=\"d\">");
        rule.accept(this);
        buff.append(this.html);
        buff.append("</td><td class=\"le\"></td></tr></table>");
        this.html = buff.toString();
    }

    @Override
    public void visitRuleOptional(ArrayList<Rule> list) {
        StringBuilder buff = new StringBuilder();
        BnfRailroad.writeOptionalStart(buff);
        int i = 0;
        int l = list.size() - 1;
        while (i <= l) {
            this.visitOrItem(buff, list.get(i), i == l ? "l" : "k");
            ++i;
        }
        buff.append("</table>");
        this.html = buff.toString();
    }

    private static void writeOptionalStart(StringBuilder buff) {
        buff.append("<table class=\"railroad\">");
        buff.append("<tr class=\"railroad\"><td class=\"ts\"></td><td class=\"d\">&nbsp;</td><td class=\"te\"></td></tr>");
    }

    private void visitOrItem(StringBuilder buff, Rule r, String a) {
        buff.append("<tr class=\"railroad\"><td class=\"" + a + "s\"></td><td class=\"d\">");
        r.accept(this);
        buff.append(this.html);
        buff.append("</td><td class=\"" + a + "e\"></td></tr>");
    }

    @Override
    public void visitRuleExtension(Rule rule, boolean compatibility) {
        StringBuilder buff = new StringBuilder("<div class=\"").append(compatibility ? "ruleCompat" : "ruleH2").append("\">");
        rule.accept(this);
        this.html = buff.append(this.html).append("</div>").toString();
    }
}

