/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleFixed;
import org.h2.bnf.RuleHead;
import org.h2.build.doc.BnfRailroad;
import org.h2.util.StringUtils;

public class BnfSyntax
implements BnfVisitor {
    private String html;

    public String getHtml(Bnf bnf, String syntaxLines) {
        String s;
        syntaxLines = StringUtils.replaceAll(syntaxLines, "\n    ", "\n");
        StringTokenizer tokenizer = Bnf.getTokenizer(syntaxLines);
        StringBuilder buff = new StringBuilder();
        ArrayDeque<Character> deque = new ArrayDeque<Character>();
        boolean extension = false;
        while (tokenizer.hasMoreTokens()) {
            block17: {
                block18: {
                    s = tokenizer.nextToken();
                    if (s.equals("@c@")) {
                        if (!extension) {
                            extension = true;
                            buff.append("<span class=\"ruleCompat\">");
                        }
                        s = BnfSyntax.skipAfterExtensionStart(tokenizer);
                    } else if (s.equals("@h2@")) {
                        if (!extension) {
                            extension = true;
                            buff.append("<span class=\"ruleH2\">");
                        }
                        s = BnfSyntax.skipAfterExtensionStart(tokenizer);
                    }
                    if (!extension) break block17;
                    if (s.length() != 1) break block18;
                    char c = s.charAt(0);
                    switch (c) {
                        case '[': {
                            deque.addLast(Character.valueOf(']'));
                            break;
                        }
                        case '{': {
                            deque.addLast(Character.valueOf('}'));
                            break;
                        }
                        case ']': 
                        case '}': {
                            char c2 = ((Character)deque.removeLast()).charValue();
                            if (c != c2) {
                                throw new AssertionError((Object)("Expected " + c2 + " got " + c));
                            }
                            break block17;
                        }
                        default: {
                            if (deque.isEmpty()) {
                                deque.add(Character.valueOf('*'));
                                break;
                            }
                            break block17;
                        }
                    }
                    break block17;
                }
                if (deque.isEmpty()) {
                    deque.add(Character.valueOf('*'));
                }
            }
            if (s.length() == 1 || StringUtils.toUpperEnglish(s).equals(s)) {
                buff.append(StringUtils.xmlText(s));
                if (!extension || !deque.isEmpty()) continue;
                extension = false;
                buff.append("</span>");
                continue;
            }
            buff.append(this.getLink(bnf, s));
        }
        if (extension) {
            if (deque.size() != 1 || ((Character)deque.getLast()).charValue() != '*') {
                throw new AssertionError((Object)("Expected " + String.valueOf(deque.getLast()) + " got end of data"));
            }
            buff.append("</span>");
        }
        s = buff.toString();
        s = StringUtils.replaceAll(s, "--", "&#45;-");
        return s;
    }

    private static String skipAfterExtensionStart(StringTokenizer tokenizer) {
        String s;
        while ((s = tokenizer.nextToken()).equals(" ")) {
        }
        return s;
    }

    String getLink(Bnf bnf, String token) {
        RuleHead found = null;
        String key = Bnf.getRuleMapKey(token);
        int i = 0;
        while (i < token.length()) {
            String test = StringUtils.toLowerEnglish(key.substring(i));
            RuleHead r = bnf.getRuleHead(test);
            if (r != null) {
                found = r;
                break;
            }
            ++i;
        }
        if (found == null) {
            return token;
        }
        String page = "grammar.html";
        String section = found.getSection();
        if (section.startsWith("Commands")) {
            page = "commands.html";
        }
        if (section.startsWith("Data Types") || section.startsWith("Interval Data Types")) {
            page = "datatypes.html";
        } else if (section.startsWith("Functions")) {
            page = "functions.html";
        } else {
            if (token.equals("@func@")) {
                return "<a href=\"functions.html\">Function</a>";
            }
            if (found.getRule() instanceof RuleFixed) {
                found.getRule().accept(this);
                return this.html;
            }
        }
        Object link = found.getTopic().toLowerCase().replace(' ', '_');
        link = page + "#" + StringUtils.urlEncode((String)link);
        return "<a href=\"" + (String)link + "\">" + token + "</a>";
    }

    @Override
    public void visitRuleElement(boolean keyword, String name, Rule link) {
    }

    @Override
    public void visitRuleFixed(int type) {
        this.html = BnfRailroad.getHtmlText(type);
    }

    @Override
    public void visitRuleList(boolean or, ArrayList<Rule> list) {
    }

    @Override
    public void visitRuleOptional(Rule rule) {
    }

    @Override
    public void visitRuleOptional(ArrayList<Rule> list) {
    }

    @Override
    public void visitRuleRepeat(boolean comma, Rule rule) {
    }

    @Override
    public void visitRuleExtension(Rule rule, boolean compatibility) {
    }
}

