/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.h2.bnf.Bnf;
import org.h2.build.doc.BnfRailroad;
import org.h2.build.doc.BnfSyntax;
import org.h2.build.doc.RailroadImages;
import org.h2.engine.Constants;
import org.h2.server.web.PageParser;
import org.h2.tools.Csv;
import org.h2.util.StringUtils;

public class GenerateDoc {
    private static final String IN_HELP = "src/main/org/h2/res/help.csv";
    private Path inDir = Paths.get("src/docsrc/html", new String[0]);
    private Path outDir = Paths.get("docs/html", new String[0]);
    private Connection conn;
    private final HashMap<String, Object> session = new HashMap();
    private Bnf bnf;

    public static void main(String ... args) throws Exception {
        new GenerateDoc().run(args);
    }

    /*
     * Unable to fully structure code
     */
    private void run(String ... args) throws Exception {
        i = 0;
        while (i < args.length) {
            if (args[i].equals("-in")) {
                this.inDir = Paths.get(args[++i], new String[0]);
            } else if (args[i].equals("-out")) {
                this.outDir = Paths.get(args[++i], new String[0]);
            }
            ++i;
        }
        Class.forName("org.h2.Driver");
        this.conn = DriverManager.getConnection("jdbc:h2:mem:");
        Files.createDirectories(this.outDir, new FileAttribute[0]);
        new RailroadImages().run(this.outDir.resolve("images"));
        this.bnf = Bnf.getInstance(null);
        this.bnf.linkStatements();
        this.session.put("version", Constants.VERSION);
        this.session.put("versionDate", "2023-08-22");
        this.session.put("downloadRoot", "https://github.com/h2database/h2database/releases/download/version-" + Constants.VERSION);
        help = "SELECT ROWNUM ID, * FROM CSVREAD('src/main/org/h2/res/help.csv', NULL, 'lineComment=#') WHERE SECTION ";
        this.map("commandsDML", help + "= 'Commands (DML)' ORDER BY ID", true, false);
        this.map("commandsDDL", help + "= 'Commands (DDL)' ORDER BY ID", true, false);
        this.map("commandsOther", help + "= 'Commands (Other)' ORDER BY ID", true, false);
        this.map("literals", help + "= 'Literals' ORDER BY ID", true, false);
        this.map("datetimeFields", help + "= 'Datetime fields' ORDER BY ID", true, false);
        this.map("otherGrammar", help + "= 'Other Grammar' ORDER BY ID", true, false);
        this.map("functionsNumeric", help + "= 'Functions (Numeric)' ORDER BY ID", true, false);
        this.map("functionsString", help + "= 'Functions (String)' ORDER BY ID", true, false);
        this.map("functionsTimeDate", help + "= 'Functions (Time and Date)' ORDER BY ID", true, false);
        this.map("functionsSystem", help + "= 'Functions (System)' ORDER BY ID", true, false);
        this.map("functionsJson", help + "= 'Functions (JSON)' ORDER BY ID", true, false);
        this.map("functionsTable", help + "= 'Functions (Table)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsGeneral", help + "= 'Aggregate Functions (General)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsBinarySet", help + "= 'Aggregate Functions (Binary Set)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsOrdered", help + "= 'Aggregate Functions (Ordered)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsHypothetical", help + "= 'Aggregate Functions (Hypothetical Set)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsInverse", help + "= 'Aggregate Functions (Inverse Distribution)' ORDER BY ID", true, false);
        this.map("aggregateFunctionsJSON", help + "= 'Aggregate Functions (JSON)' ORDER BY ID", true, false);
        this.map("windowFunctionsRowNumber", help + "= 'Window Functions (Row Number)' ORDER BY ID", true, false);
        this.map("windowFunctionsRank", help + "= 'Window Functions (Rank)' ORDER BY ID", true, false);
        this.map("windowFunctionsLeadLag", help + "= 'Window Functions (Lead or Lag)' ORDER BY ID", true, false);
        this.map("windowFunctionsNth", help + "= 'Window Functions (Nth Value)' ORDER BY ID", true, false);
        this.map("windowFunctionsOther", help + "= 'Window Functions (Other)' ORDER BY ID", true, false);
        this.map("dataTypes", help + "LIKE 'Data Types%' ORDER BY SECTION, ID", true, true);
        this.map("intervalDataTypes", help + "LIKE 'Interval Data Types%' ORDER BY SECTION, ID", true, true);
        informationSchemaTables = new HashMap<String, String>();
        informationSchemaColumns = new HashMap<Object, String>(512);
        csv = new Csv();
        csv.setLineCommentCharacter('#');
        var6_7 = null;
        var7_10 = null;
        try {
            rs = csv.read("src/docsrc/help/information_schema.csv", null, null);
            try {
                while (rs.next()) {
                    tableName = rs.getString(1);
                    columnName = rs.getString(2);
                    description = rs.getString(3);
                    if (columnName != null) {
                        informationSchemaColumns.put(tableName == null ? columnName : tableName + "." + columnName, description);
                        continue;
                    }
                    informationSchemaTables.put(tableName, description);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable var7_11) {
            if (var6_7 == null) {
                var6_7 = var7_11;
            } else if (var6_7 != var7_11) {
                var6_7.addSuppressed(var7_11);
            }
            throw var6_7;
        }
        errorCount = 0;
        var7_10 = null;
        var8_13 = null;
        try {
            stat = this.conn.createStatement();
            try {
                prep = this.conn.prepareStatement("SELECT COLUMN_NAME, DATA_TYPE_SQL('INFORMATION_SCHEMA', TABLE_NAME, 'TABLE', DTD_IDENTIFIER) DT FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'INFORMATION_SCHEMA' AND TABLE_NAME = ? ORDER BY ORDINAL_POSITION");
                try {
                    rs = stat.executeQuery("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'INFORMATION_SCHEMA' ORDER BY TABLE_NAME");
                    list = new ArrayList<HashMap<String, String>>();
                    builder = new StringBuilder();
                    while (rs.next()) {
                        map = new HashMap<String, Object>(8);
                        table = rs.getString(1);
                        map.put("table", table);
                        map.put("link", "information_schema_" + StringUtils.urlEncode(table.toLowerCase()));
                        description = (String)informationSchemaTables.get(table);
                        if (description == null) {
                            System.out.println("No documentation for INFORMATION_SCHEMA." + table);
                            ++errorCount;
                            description = "";
                        }
                        map.put("description", StringUtils.xmlText(description));
                        prep.setString(1, table);
                        rs2 = prep.executeQuery();
                        builder.setLength(0);
                        while (rs2.next()) {
                            if (rs2.getRow() > 1) {
                                builder.append('\n');
                            }
                            if ((description = (String)informationSchemaColumns.get(table + "." + (column = rs2.getString(1)))) == null && (description = (String)informationSchemaColumns.get(column)) == null) {
                                System.out.println("No documentation for INFORMATION_SCHEMA." + table + "." + column);
                                ++errorCount;
                                description = "";
                            }
                            builder.append("<tr><td>").append(column).append("</td><td>").append(rs2.getString(2)).append("</td></tr><tr><td colspan=\"2\">").append(StringUtils.xmlText(description)).append("</td></tr>");
                        }
                        map.put("columns", builder.toString());
                        list.add(map);
                    }
                    this.putToMap("informationSchema", list);
                }
                finally {
                    if (prep != null) {
                        prep.close();
                    }
                }
                ** if (stat == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                if (var7_10 == null) {
                    var7_10 = var8_14;
                } else if (var7_10 != var8_14) {
                    var7_10.addSuppressed(var8_14);
                }
                if (stat != null) {
                    stat.close();
                }
                throw var7_10;
            }
lbl-1000:
            // 1 sources

            {
                stat.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var8_15) {
            if (var7_10 == null) {
                var7_10 = var8_15;
            } else if (var7_10 != var8_15) {
                var7_10.addSuppressed(var8_15);
            }
            throw var7_10;
        }
        Files.walkFileTree(this.inDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                GenerateDoc.this.process(file);
                return FileVisitResult.CONTINUE;
            }
        });
        this.conn.close();
        if (errorCount > 0) {
            throw new IOException(errorCount + (errorCount == 1 ? " error" : " errors") + " found");
        }
    }

    void process(Path inFile) throws IOException {
        Path outFile = this.outDir.resolve(this.inDir.relativize(inFile));
        Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        byte[] bytes = Files.readAllBytes(inFile);
        if (inFile.getFileName().toString().endsWith(".html")) {
            String page = new String(bytes);
            page = PageParser.parse(page, this.session);
            bytes = page.getBytes();
        }
        Files.write(outFile, bytes, new OpenOption[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void map(String key, String sql, boolean railroads, boolean forDataTypes) throws Exception {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Statement stat = this.conn.createStatement();
            try {
                try (ResultSet rs = stat.executeQuery(sql);){
                    ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        ResultSetMetaData meta = rs.getMetaData();
                        int i = 1;
                        while (i <= meta.getColumnCount()) {
                            String k = StringUtils.toLowerEnglish(meta.getColumnLabel(i));
                            String value = rs.getString(i);
                            value = value.trim();
                            map.put(k, PageParser.escapeHtml(value));
                            ++i;
                        }
                        String topic = rs.getString("TOPIC");
                        if (forDataTypes && topic.endsWith(" Type")) {
                            map.put("topic", topic.substring(0, topic.length() - 5));
                        }
                        String syntax = rs.getString("SYNTAX").trim();
                        if (railroads) {
                            BnfRailroad r = new BnfRailroad();
                            String railroad = r.getHtml(this.bnf, syntax);
                            map.put("railroad", railroad);
                        }
                        BnfSyntax visitor = new BnfSyntax();
                        String syntaxHtml = visitor.getHtml(this.bnf, syntax);
                        map.put("syntax", syntaxHtml);
                        String text = (String)map.get("text");
                        if (text != null) {
                            text = StringUtils.replaceAll(text, "<br /><br />", "</p><p>");
                            text = StringUtils.replaceAll(text, "<br />", " ");
                            text = GenerateDoc.addCode(text);
                            text = GenerateDoc.addLinks(text);
                            map.put("text", text);
                        }
                        String link = topic.toLowerCase();
                        link = link.replace(' ', '_');
                        link = link.replace('@', '_');
                        map.put("link", StringUtils.urlEncode(link));
                        list.add(map);
                    }
                    this.putToMap(key, list);
                }
                if (stat == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stat == null) throw throwable;
                stat.close();
                throw throwable;
            }
            stat.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void putToMap(String key, ArrayList<HashMap<String, String>> list) {
        this.session.put(key, list);
        int div = 3;
        int part = (list.size() + div - 1) / div;
        int i = 0;
        int start = 0;
        while (i < div) {
            int end = Math.min(start + part, list.size());
            List listThird = start <= end ? list.subList(start, end) : Collections.emptyList();
            this.session.put(key + "-" + i, listThird);
            ++i;
            start += part;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String addCode(String text) {
        text = StringUtils.replaceAll(text, "&quot;", "\"");
        buff = new StringBuilder(text.length());
        len = text.length();
        code = false;
        codeQuoted = false;
        i = 0;
        while (i < len) {
            block7: {
                block8: {
                    block5: {
                        block6: {
                            c = text.charAt(i);
                            if (i >= len - 1) break block5;
                            next = text.charAt(i + 1);
                            if (code || codeQuoted) break block5;
                            if (!Character.isUpperCase(c) || !Character.isUpperCase(next)) break block6;
                            buff.append("<code>");
                            code = true;
                            break block5;
                        }
                        if (c != '\"' || i != 0 && text.charAt(i - 1) == '\\') break block5;
                        buff.append("<code>");
                        codeQuoted = true;
                        break block7;
                    }
                    if (!code) break block8;
                    if (!Character.isLetterOrDigit(c) && "_.".indexOf(c) < 0) {
                        buff.append("</code>");
                        code = false;
                    }
                    ** GOTO lbl-1000
                }
                if (codeQuoted && c == '\"' && (i == 0 || text.charAt(i - 1) != '\\')) {
                    buff.append("</code>");
                    codeQuoted = false;
                } else lbl-1000:
                // 2 sources

                {
                    buff.append(c);
                }
            }
            ++i;
        }
        if (code) {
            buff.append("</code>");
        }
        s = buff.toString();
        s = StringUtils.replaceAll(s, "</code>, <code>", ", ");
        s = StringUtils.replaceAll(s, ".</code>", "</code>.");
        s = StringUtils.replaceAll(s, ",</code>", "</code>.");
        s = StringUtils.replaceAll(s, " @<code>", " <code>@");
        s = StringUtils.replaceAll(s, "</code> <code>", " ");
        s = StringUtils.replaceAll(s, "<code>SQL</code>", "SQL");
        s = StringUtils.replaceAll(s, "<code>XML</code>", "XML");
        s = StringUtils.replaceAll(s, "<code>URL</code>", "URL");
        s = StringUtils.replaceAll(s, "<code>URLs</code>", "URLs");
        s = StringUtils.replaceAll(s, "<code>HTML</code>", "HTML");
        s = StringUtils.replaceAll(s, "<code>KB</code>", "KB");
        s = StringUtils.replaceAll(s, "<code>MB</code>", "MB");
        s = StringUtils.replaceAll(s, "<code>GB</code>", "GB");
        return s;
    }

    private static String addLinks(String text) {
        int start = GenerateDoc.nextLink(text, 0);
        if (start < 0) {
            return text;
        }
        StringBuilder buff = new StringBuilder(text.length());
        int len = text.length();
        int offset = 0;
        do {
            if (start > 2 && text.regionMatches(start - 2, "](https://h2database.com/html/", 0, 30)) {
                int descEnd = start - 2;
                int descStart = text.lastIndexOf(91, descEnd - 1) + 1;
                int linkStart = start + 28;
                int linkEnd = text.indexOf(41, start + 29);
                buff.append(text, offset, descStart - 1).append("<a href=\"").append(text, linkStart, linkEnd).append("\">").append(text, descStart, descEnd).append("</a>");
                offset = linkEnd + 1;
                continue;
            }
            int end = start + 7;
            while (end < len && !Character.isWhitespace(text.charAt(end))) {
                ++end;
            }
            buff.append(text, offset, start).append("<a href=\"").append(text, start, end).append("\">").append(text, start, end).append("</a>");
            offset = end;
        } while ((start = GenerateDoc.nextLink(text, offset)) >= 0);
        return buff.append(text, offset, len).toString();
    }

    private static int nextLink(String text, int i) {
        int found = -1;
        found = GenerateDoc.findLink(text, i, "http://", found);
        found = GenerateDoc.findLink(text, i, "https://", found);
        return found;
    }

    private static int findLink(String text, int offset, String prefix, int found) {
        int idx = text.indexOf(prefix, offset);
        if (idx >= 0 && (found < 0 || idx < found)) {
            found = idx;
        }
        return found;
    }
}

