/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.h2.engine.Constants;
import org.h2.util.StringUtils;

public class MergeDocs {
    private static final String BASE_DIR = "docs/html";

    public static void main(String ... args) throws Exception {
        String[] pages = new String[]{"quickstart.html", "installation.html", "tutorial.html", "features.html", "security.html", "performance.html", "advanced.html", "commands.html", "functions.html", "functions-aggregate.html", "functions-window.html", "datatypes.html", "grammar.html", "systemtables.html", "build.html", "history.html", "faq.html"};
        StringBuilder buff = new StringBuilder();
        String[] stringArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String text = MergeDocs.getContent(fileName);
            String[] stringArray2 = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                String page = stringArray2[n4];
                text = StringUtils.replaceAll(text, page + "#", "#");
                ++n4;
            }
            text = MergeDocs.disableRailroads(text);
            text = MergeDocs.removeHeaderFooter(fileName, text);
            text = MergeDocs.fixLinks(text);
            text = MergeDocs.fixTableBorders(text);
            text = MergeDocs.addLegacyFontTag(fileName, text);
            buff.append(text);
            ++n2;
        }
        String finalText = buff.toString();
        PrintWriter writer = new PrintWriter(Files.newBufferedWriter(Paths.get(BASE_DIR, "onePage.html"), new OpenOption[0]));
        writer.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" /><title>");
        writer.println("H2 Documentation");
        writer.println("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheetPdf.css\" /></head><body>");
        writer.println("<p class=\"title\">H2 Database Engine</p>");
        writer.println("<p>Version " + Constants.FULL_VERSION + "</p>");
        writer.println(finalText);
        writer.println("</body></html>");
        writer.close();
    }

    private static String disableRailroads(String text) {
        text = StringUtils.replaceAll(text, "<!-- railroad-start -->", "<!-- railroad-start ");
        text = StringUtils.replaceAll(text, "<!-- railroad-end -->", " railroad-end -->");
        text = StringUtils.replaceAll(text, "<!-- syntax-start", "<!-- syntax-start -->");
        text = StringUtils.replaceAll(text, "syntax-end -->", "<!-- syntax-end -->");
        return text;
    }

    private static String addLegacyFontTag(String fileName, String text) {
        int idx1 = text.indexOf("<span class=\"rule");
        if (idx1 < 0) {
            return text;
        }
        int idx2 = 0;
        int length = text.length();
        StringBuilder builder = new StringBuilder(length + (length >> 4));
        do {
            builder.append(text, idx2, idx1);
            boolean compat = text.regionMatches(idx1 + 17, "Compat\">", 0, 8);
            boolean h2 = text.regionMatches(idx1 + 17, "H2\">", 0, 4);
            if (compat == h2) {
                throw new RuntimeException("Unknown BNF rule style in file " + fileName);
            }
            idx2 = text.indexOf("</span>", idx1 + (compat ? 8 : 4));
            if (idx2 <= 0) {
                throw new RuntimeException("</span> not found in file " + fileName);
            }
            builder.append("<font color=\"").append(compat ? "darkred" : "green").append("\">").append(text, idx1, idx2 += 7).append("</font>");
        } while ((idx1 = text.indexOf("<span class=\"rule", idx2)) >= 0);
        return builder.append(text, idx2, length).toString();
    }

    private static String removeHeaderFooter(String fileName, String text) {
        String start = "<!-- } -->";
        String end = "<!-- [close] { --></div></td></tr></table><!-- } --><!-- analytics --></body></html>";
        int idx = text.indexOf(end);
        if (idx < 0) {
            throw new RuntimeException("Footer not found in file " + fileName);
        }
        text = text.substring(0, idx);
        idx = text.indexOf(start) + start.length();
        text = text.substring(idx + 1);
        return text;
    }

    private static String fixLinks(String text) {
        return text.replaceAll("href=\"build.html\"", "href=\"#build_index\"").replaceAll("href=\"datatypes.html\"", "href=\"#datatypes_index\"").replaceAll("href=\"faq.html\"", "href=\"#faq_index\"").replaceAll("href=\"commands.html\"", "href=\"#commands_index\"").replaceAll("href=\"grammar.html\"", "href=\"#grammar_index\"").replaceAll("href=\"functions.html\"", "href=\"#functions_index\"").replaceAll("href=\"functions-aggregate.html\"", "href=\"#functions_aggregate_index\"").replaceAll("href=\"functions-window.html\"", "href=\"#functions_window_index\"").replaceAll("href=\"tutorial.html\"", "href=\"#tutorial_index\"");
    }

    private static String fixTableBorders(String text) {
        return text.replaceAll("<table class=\"main\">", "<table class=\"main\" border=\"1\" cellpadding=\"5\" cellspacing=\"0\">");
    }

    private static String getContent(String fileName) throws Exception {
        return new String(Files.readAllBytes(Paths.get(BASE_DIR, fileName)), StandardCharsets.UTF_8);
    }
}

