/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class RailroadImages {
    private static final int SIZE = 64;
    private static final int LINE_REPEAT = 32;
    private static final int DIV = 2;
    private static final int STROKE = 6;
    private Path outDir;

    public static void main(String ... args) throws IOException {
        new RailroadImages().run(Paths.get("docs/html/images", new String[0]));
    }

    void run(Path out) throws IOException {
        this.outDir = out;
        Files.createDirectories(this.outDir, new FileAttribute[0]);
        BufferedImage img = new BufferedImage(4096, 2048, 2);
        Graphics2D g = img.createGraphics();
        int i = 0;
        while (i < 2) {
            RailroadImages.setStroke(g, i);
            g.drawLine(0, 32, 4096, 32);
            ++i;
        }
        g.dispose();
        this.savePng(img, "div-d.png");
        img = null;
        img = new BufferedImage(64, 2048, 2);
        g = img.createGraphics();
        i = 0;
        while (i < 2) {
            RailroadImages.setStroke(g, i);
            g.drawLine(0, 32, 64, 32);
            g.drawLine(32, 64, 32, 2048);
            g.drawArc(-32, 32, 64, 64, 0, 90);
            ++i;
        }
        g.dispose();
        this.savePng(img, "div-ts.png");
        this.savePng(RailroadImages.flipHorizontal(img), "div-te.png");
        img = null;
        img = new BufferedImage(64, 2048, 2);
        g = img.createGraphics();
        i = 0;
        while (i < 2) {
            RailroadImages.setStroke(g, i);
            g.drawArc(32, -32, 64, 64, 180, 270);
            ++i;
        }
        this.savePng(img, "div-ls.png");
        this.savePng(RailroadImages.flipHorizontal(img), "div-le.png");
        i = 0;
        while (i < 2) {
            RailroadImages.setStroke(g, i);
            g.drawArc(32, -32, 64, 64, 180, 270);
            g.drawLine(32, 0, 32, 2048);
            ++i;
        }
        g.dispose();
        this.savePng(img, "div-ks.png");
        this.savePng(RailroadImages.flipHorizontal(img), "div-ke.png");
        img = null;
    }

    private static void setStroke(Graphics2D g, int i) {
        if (i == 0) {
            g.setColor(Color.WHITE);
            g.setStroke(new BasicStroke(18.0f));
        } else {
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(6.0f));
        }
    }

    private void savePng(BufferedImage img, String fileName) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage smaller = new BufferedImage(w / 2, h / 2, img.getType());
        Graphics2D g = smaller.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, w / 2, h / 2, 0, 0, w, h, null);
        g.dispose();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (OutputStream out = Files.newOutputStream(this.outDir.resolve(fileName), new OpenOption[0]);){
                ImageIO.write((RenderedImage)smaller, "png", out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedImage flipHorizontal(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage copy = new BufferedImage(w, h, img.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return copy;
    }
}

