/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.h2.build.BuildBase;
import org.h2.samples.Newsfeed;
import org.h2.util.StringUtils;

public class WebSite {
    private static final String ANALYTICS_TAG = "<!-- analytics -->";
    private static final String ANALYTICS_SCRIPT = "";
    private static final String TRANSLATE_START = "<!-- translate";
    private static final String TRANSLATE_END = "translate -->";
    private static final Path SOURCE_DIR = Paths.get("docs", new String[0]);
    private static final Path WEB_DIR = Paths.get("../h2web", new String[0]);
    private final HashMap<String, String> fragments = new HashMap();

    public static void main(String ... args) throws Exception {
        new WebSite().run();
    }

    private void run() throws Exception {
        BuildBase.deleteRecursive(WEB_DIR);
        this.loadFragments();
        this.copy(SOURCE_DIR, WEB_DIR, true, true);
        Newsfeed.main(String.valueOf(WEB_DIR) + "/html");
        this.copy(SOURCE_DIR, SOURCE_DIR, true, false);
    }

    private void loadFragments() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(SOURCE_DIR.resolve("html"), "fragments*");){
            for (Path f : stream) {
                this.fragments.put(f.getFileName().toString(), new String(Files.readAllBytes(f), StandardCharsets.UTF_8));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String replaceFragments(String fileName, String page) {
        if (this.fragments.size() == 0) {
            return page;
        }
        String language = ANALYTICS_SCRIPT;
        int index = fileName.indexOf(95);
        if (index >= 0) {
            int end = fileName.indexOf(46);
            language = fileName.substring(index, end);
        }
        String fragment = this.fragments.get("fragments" + language + ".html");
        int start = 0;
        while ((start = fragment.indexOf("<!-- [", start)) >= 0) {
            int endTag = fragment.indexOf("] { -->", start);
            int endBlock = fragment.indexOf("<!-- } -->", start);
            String tag = fragment.substring(start, endTag);
            String replacement = fragment.substring(start, endBlock);
            int pageStart = 0;
            while ((pageStart = ((String)page).indexOf(tag, pageStart)) >= 0) {
                int pageEnd = ((String)page).indexOf("<!-- } -->", pageStart);
                page = ((String)page).substring(0, pageStart) + replacement + ((String)page).substring(pageEnd);
                pageStart += replacement.length();
            }
            start = endBlock;
        }
        return page;
    }

    private void copy(final Path source, final Path target, final boolean replaceFragments, final boolean web) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                WebSite.this.copyFile(file, target.resolve(source.relativize(file)), replaceFragments, web);
                return super.visitFile(file, attrs);
            }
        });
    }

    void copyFile(Path source, Path target, boolean replaceFragments, boolean web) throws IOException {
        String name = source.getFileName().toString();
        if (name.endsWith("onePage.html") || name.startsWith("fragments")) {
            return;
        }
        if (web ? name.endsWith("main.html") : name.endsWith("mainWeb.html")) {
            return;
        }
        byte[] bytes = Files.readAllBytes(source);
        if (name.endsWith(".html")) {
            String page = new String(bytes, StandardCharsets.UTF_8);
            if (web) {
                page = StringUtils.replaceAll(page, ANALYTICS_TAG, ANALYTICS_SCRIPT);
            }
            if (replaceFragments) {
                page = this.replaceFragments(name, page);
                page = StringUtils.replaceAll(page, "<a href=\"frame", "<a href=\"main");
                page = StringUtils.replaceAll(page, "html/frame.html", "html/main.html");
            }
            if (web) {
                page = StringUtils.replaceAll(page, TRANSLATE_START, ANALYTICS_SCRIPT);
                page = StringUtils.replaceAll(page, TRANSLATE_END, ANALYTICS_SCRIPT);
                page = StringUtils.replaceAll(page, "<pre>", "<pre class=\"notranslate\">");
                page = StringUtils.replaceAll(page, "<code>", "<code class=\"notranslate\">");
            }
            if (name.endsWith("changelog.html")) {
                page = page.replaceAll("Issue\\s+#?(\\d+)", "<a href=\"https://github.com/h2database/h2database/issues/$1\">Issue #$1</a>");
                page = page.replaceAll("PR\\s+#?(\\d+)", "<a href=\"https://github.com/h2database/h2database/pull/$1\">PR #$1</a>");
            }
            bytes = page.getBytes(StandardCharsets.UTF_8);
        }
        Files.write(target, bytes, new OpenOption[0]);
        if (web && name.endsWith("mainWeb.html")) {
            Files.move(target, target.getParent().resolve("main.html"), new CopyOption[0]);
        }
    }
}

