/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Stack;
import org.h2.build.doc.XMLParser;

public class XMLChecker {
    public static void main(String ... args) throws Exception {
        XMLChecker.run(args);
    }

    private static void run(String ... args) throws Exception {
        Path dir = Paths.get(".", new String[0]);
        int i = 0;
        while (i < args.length) {
            if ("-dir".equals(args[i])) {
                dir = Paths.get(args[++i], new String[0]);
            }
            ++i;
        }
        XMLChecker.process(dir.resolve("src"));
        XMLChecker.process(dir.resolve("docs"));
    }

    private static void process(Path path) throws Exception {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().equals("javadoc")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                XMLChecker.processFile(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static void processFile(Path file) throws IOException {
        String fileName = file.getFileName().toString();
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return;
        }
        String suffix = fileName.substring(idx + 1);
        if (!(suffix.equals("html") || suffix.equals("xml") || suffix.equals("jsp"))) {
            return;
        }
        String s = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        Exception last = null;
        try {
            XMLChecker.checkXML(s, !suffix.equals("xml"));
        }
        catch (Exception e) {
            last = e;
            System.out.println("ERROR in file " + fileName + " " + e.toString());
        }
        if (last != null) {
            last.printStackTrace();
        }
    }

    private static void checkXML(String xml, boolean html) throws Exception {
        int event;
        String[] noClose = new String[]{"br", "hr", "input", "link", "meta", "wbr"};
        XMLParser parser = new XMLParser(xml);
        Stack<Object[]> stack = new Stack<Object[]>();
        boolean rootElement = false;
        block0: while ((event = parser.next()) != 8) {
            String n;
            int n2;
            String[] stringArray;
            String name;
            if (event == 1) {
                if (stack.isEmpty()) {
                    if (rootElement) {
                        throw new Exception("Second root element at " + parser.getRemaining());
                    }
                    rootElement = true;
                }
                name = parser.getName();
                if (html) {
                    stringArray = noClose;
                    n2 = noClose.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        n = stringArray[n3];
                        if (name.equals(n)) {
                            name = null;
                            break;
                        }
                        ++n3;
                    }
                }
                if (name == null) continue;
                stack.add(new Object[]{name, parser.getPos()});
                continue;
            }
            if (event == 2) {
                Object[] pop;
                String p;
                name = parser.getName();
                if (html) {
                    stringArray = noClose;
                    n2 = noClose.length;
                    int n4 = 0;
                    while (n4 < n2) {
                        n = stringArray[n4];
                        if (name.equals(n)) continue block0;
                        ++n4;
                    }
                }
                if ((p = (String)(pop = (Object[])stack.pop())[0]).equals(name)) continue;
                String remaining = xml.substring((Integer)pop[1]);
                if (remaining.length() > 100) {
                    remaining = remaining.substring(0, 100);
                }
                throw new Exception("Unclosed element " + p + " at " + remaining);
            }
            if (event == 4 || event == 11 || event == 5) continue;
            int eventType = parser.getEventType();
            throw new Exception("Unexpected event " + eventType + " at " + parser.getRemaining());
        }
        if (!stack.isEmpty()) {
            throw new Exception("Unclosed root element");
        }
    }
}

